-- flag
--
-- VHDL Architecture vme_interface.vme_test_driver.tester
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BANGLADESH)
--          at - 08:52:34 09/06/02
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1a (Build 22)
--
-- hds interface_start
LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY vme_test_driver IS
   PORT( 
      am               : IN     STD_LOGIC_vector (5 DOWNTO 0);
      not_as           : IN     STD_LOGIC;
      not_ds0          : IN     STD_LOGIC;
      not_ds1          : IN     STD_LOGIC;
      not_lword        : IN     STD_LOGIC;
      not_write        : IN     STD_LOGIC;
      amin             : OUT    STD_LOGIC_vector (5 DOWNTO 0);
      burst            : OUT    std_logic;
      burst_cnt        : OUT    STD_LOGIC_vector (7 DOWNTO 0);
      go               : OUT    std_logic;
      mode             : OUT    STD_LOGIC_vector (1 DOWNTO 0);
      not_r_w          : OUT    std_logic;
      sysclk           : BUFFER std_logic;
      adr              : INOUT  STD_LOGIC_vector (31 DOWNTO 0);
      data             : INOUT  STD_LOGIC_vector (31 DOWNTO 0);
      reset            : BUFFER std_logic;
      clkin            : BUFFER STD_LOGIC;
      n_ga0_a          : OUT    std_logic;
      n_ga1_a          : OUT    std_logic;
      n_ga2_a          : OUT    std_logic;
      n_ga3_a          : OUT    std_logic;
      n_ga4_a          : OUT    std_logic;
      n_gap_a          : OUT    std_logic;
      n_iack_a         : OUT    std_logic;
      n_sysfail_a      : OUT    std_logic;
      n_sysreset_a     : OUT    std_logic;
      n_acfail_a       : OUT    std_logic;
      ttc_ready_to_vme : OUT    std_logic
   );

-- Declarations

END vme_test_driver ;


-- hds interface_end
ARCHITECTURE rd_wr_id_prom OF vme_test_driver IS

BEGIN
 vecgen : process(sysclk,reset)
  
 
 begin

    if (reset = 'U') then
      reset    <= '0' after 0 ns;				-- at start all signals are U ( undifined )
      sysclk  <= '0' after 0 ns;				-- so set reset to 1 for 10 ns
	 -- clk <= '0' after 0 ns;
    end if;
    
    If (reset = '0') then
		reset 	<= '1' after 10 ns;			-- after 10 ns ser rst to zero  
		
   	end if;									-- this line will zero reset after 10 ns 
											-- nomatter what set it


    -- Main clock loop

    if (sysclk'event) then					-- clock is activated my an event on its self
      if (sysclk = '1') then
        sysclk <= '0' after 31.25 ns;			-- generate clock on 20ns cycle ie 50Mhz
	--	clk <= '0' after 10 ns;
	
      else
        sysclk <= '1' after 31.25 ns;
	--	clk <= '1' after 10 ns;
		 

      end if;
    end if;
  end process;



	clkmaker : process (reset,clkin)
	begin
	if reset = '0' then
		clkin <= '0';
	end if;
	if (clkin'event) then					-- clock is activated my an event on its self
      		if (clkin = '1') then
        		clkin <= '0' after 12.5 ns;			-- generate clock on 25ns cycle ie 40Mhz
      		else
        		clkin <= '1' after 12.5 ns;
      		end if;
	end if;
end process;

	 --start stimulus for item on test
 	 stim : process

	    constant A32SP	: std_logic_vector := "001110"; --0E
  constant A32SD	: std_logic_vector := "001101"; --0D
  constant A32NPP	: std_logic_vector := "001010"; --0A
  constant A32NPD	: std_logic_vector := "001001"; --09

   -- block TX sets
  constant A32NPBT	: std_logic_vector := "001011"; --0B
  constant A32SBT 	: std_logic_vector := "001111"; --0F

  -- 64bit block TX not inplemennted yet
  constant A32NPMBT 	: std_logic_vector := "001000"; --08
  constant A32SMBT 		: std_logic_vector := "001100"; --0C

	-- vars
 begin
	  
	  amin      	<= (others => '0');
      burst     	<= '0';
      burst_cnt     <= (others => '0');
      go        	<= '0';
      mode          <= (others => '0');
     -- not_dtack 	<= '1';
      not_r_w   	<= '1';
      ttc_ready_to_vme <= '0';
      
      adr          	<= (others => '0');
      data         	<= (others => '0');
	  n_ga0_a   <= '0';
	  n_ga1_a   <= '1';
	  n_ga2_a   <= '1';
	  n_ga3_a   <= '1';
	  n_ga4_a   <= '0';
	  n_gap_a   <= '0';
	  n_sysfail_a <= '1';
	  n_sysreset_a <= '1';
	  n_iack_a <= '1';
	  n_acfail_a <= '1';
	  
 --A32SP 	"001110"; --0E -- A32 superviser Program
 --A32SD 	"001101"; --0D -- A32 superviser Data
 --A32NPP 	"001010"; --0A -- A32 non-priv Program
 --A32NPD 	"001001"; --09 -- A32 non-priv  Data

 -- block TX sets

 --A32NPBT	"001011"; --0B -- A32 non-priv block TX
 --A32SBT  	"001111"; --0F -- A32 superviser TX			
   



	wait for 10 us;	-- wait for reset
 	
	-- the following sets up the vmebus block in the test bench which emulates John's code!
								   
	   burst_cnt     <= "00000011";		-- block trf: no. of blocks (32-bit words)						   
	   burst     	 <= '0';			-- enable block trf (also need Addr Modifier)						   
	   amin 		 <= A32NPD;   		-- block TX	(not a block trf AM)			   
	 															   
	   not_r_w <= '0';   				-- 0 = write  & RD = 1

	   adr  <= "00000000000100010000100001100000";  -- set up addr of reg to talk to $0860		 
	   data <= "00000000000001010101010101010101";	-- send wr cmnd

	  mode <= "11";	     -- 32 bit access
	   wait for 100 ns;
	   go <= '1';
	   wait for 10 ns;
		 go <= '0';



	  -- new command
	   wait for 400 us;	 										   
	   burst_cnt     <= "00000011";								   
	   burst     	 <= '0';									   
	   amin 		 <= A32NPD;   -- block TX				   
	 															   
	   not_r_w <= '0';   		-- 0 = write
		  
	     adr  <= "00000000000100010000100001100000"; -- set up addr of reg to talk to $0864
	     data <= "00000000000011010101010100000000"; -- send read cmnd
	 --    data <= "101010101010101011111111101010";
	   mode <= "11";
	   wait for 100 ns;
	   go <= '1';
	   wait for 10 ns;
		 go <= '0';



	   -- new command	  
		wait for 550 us;	 										   
	   burst_cnt     <= "00000011";								   
	   burst     	 <= '0';									   
	   amin 		 <= A32NPD;   -- block TX				   
	 															   
	   not_r_w <= '0';   		-- 0 = write
		    			   
	   adr  <= "00000000000100010000100001100000";  --read reg
	   data <= "00000000000000000000000000000010";
	   mode <= "11";
	   wait for 100 ns;
	   go <= '1';
	   wait for 10 ns;
		 go <= '0';

	   wait;

	end process;
END rd_wr_id_prom;

