--
-- VHDL Architecture VME_blockram.up_count.rtl
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BANGLADESH)
--          at - 09:02:23 11/14/02
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds interface_start
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY up_count IS
   GENERIC( 
      width_count : integer := 16
   );
   PORT( 
      clear      : IN     std_logic;
      clk        : IN     std_ulogic;
      count_stop : IN     std_logic_vector (width_count - 1 DOWNTO 0);
      en         : IN     std_logic;
      rst        : IN     std_logic;
      count      : BUFFER    std_logic_vector (width_count - 1 DOWNTO 0);
      equ        : OUT    std_logic
   );

-- Declarations

END up_count ;


-- hds interface_end
ARCHITECTURE rtl OF up_count IS
BEGIN
process(clk,rst)
variable v_count : unsigned(width_count - 1 downto 0);
begin
	if rst = '1' then
		count <= (others => '0');
		equ <= '0';
		v_count :=   (others => '0');
		
	elsif clk'event and clk = '1' then
		If clear = '1' then
			v_count := (others => '0');
			equ <= '0';
		end if;
		IF en = '1' then
			If count = count_stop then
				equ <= '1' ;
			else
				equ <= '0';
				v_count := v_count + 1;
		   end if;
			
		
		end if;
		
		count <= conv_std_logic_vector(v_count,width_count);
   	end if;
end process;
END rtl;

