--
-- VHDL Architecture VME_blockram.sel_decoder.rtl
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BANGLADESH)
--          at - 09:09:05 04/29/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY sel_decoder IS
   PORT( 
      clk            : IN     std_logic;
      command_in_int : IN     std_logic;
      rst            : IN     std_logic;
      en_mux         : OUT    std_logic;
      selt           : OUT    std_logic_vector (4 DOWNTO 0)
   );

-- Declarations

END sel_decoder ;
ARCHITECTURE rtl OF sel_decoder IS

BEGIN
process(clk,rst)
variable state  	: std_logic_vector(1 downto 0);
variable sel    	: std_logic_vector(4 downto 0);
variable des    	: std_logic_vector(4 downto 0);
variable length 	: unsigned(15 downto 0);
variable r_wB		: std_logic;
variable a,b,c    	: std_logic;	-- to hold the spacer bits keep it all inline
BEGIN


If rst = '1' then

des	:= (others => '0');
length  := (others => '0');
sel 	:= (others => '0');
state	:=  "00";
a	:=  '0';
b	:=  '0';
c	:=  '0';
en_mux  <=  '0';
r_wB 	:=  '0';
selt 	<=  (others => '0');

elsif clk'event and clk = '1' then

	case state is 
		when "00" =>
		
			c	:= sel(4);
			sel	:= (sel(3 downto 0) & b);
			b	:= r_wB;
			r_wB	:= des(4);
			des	:= (des(3 downto 0) & a);
			a	:= length(15);
			length  := (length(14 downto 0) & command_in_int);
			
			en_mux  <=  '0';
			
			If (c = '1') then 
				state := "01";
				selt  <= (others => '0');
			else
				state := "00";
			
			end if;
			
		when "01" =>
			length := length - '1' ;
				selt  <=  sel;
			If (length = 1) then
				des	:= (others => '0');
				length  := (others => '0');
				sel 	:= (others => '0');
				state	:=  "10";
				a	:=  '0';
				b	:=  '0';
				c	:=  '0';
				en_mux  <=  '0';
				r_wB 	:=  '0';
				
			else
				state 	:=  "01";
				en_mux  <=  '1';
				
			end if;
			
			
		when "10" =>
		
			state := "00";
			des	:= (others => '0');
			length  := (others => '0');
			sel 	:= (others => '0');
			a	:=  '0';
			b	:=  '0';
			c	:=  '0';
			en_mux  <=  '0';
			r_wB 	:=  '0';
			
			
		when others => 
				state := "00";
				des	:= (others => '0');
				length  := (others => '0');
				sel 	:= (others => '0');
				a	:=  '0';
				b	:=  '0';
				c	:=  '0';
				r_wB 	:=  '0';
				en_mux  <=  '0';
	end case;
	
	
end if;
end process;
END rtl;

