--
-- VHDL Architecture VME_serial.mux_data_to_vme.rtl
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BANGLADESH)
--          at - 11:46:34 07/01/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY mux_data_to_vme IS
   PORT( 
      clk                : IN     std_logic;
      data_to_vme_serial : IN     std_logic_vector (31 DOWNTO 0);
      data_to_vme_vlink  : IN     std_logic_VECTOR (31 DOWNTO 0);
      data_to_vme_man    : IN     std_logic_VECTOR (31 DOWNTO 0);
      from_serial_bram   : IN     STD_LOGIC;
      from_man           : IN     std_logic;
      from_slink         : IN     std_logic;
      rst                : IN     std_logic;
      data_to_vme        : BUFFER std_logic_VECTOR (31 DOWNTO 0);
      ACE_data_to_vme    : IN     std_logic_VECTOR (31 DOWNTO 0);
      from_ace           : IN     std_logic;
      rdy_out            : OUT    std_logic
   );

-- Declarations

END mux_data_to_vme ;
ARCHITECTURE rtl OF mux_data_to_vme IS
   signal sel : std_logic_vector(3 downto 0);
BEGIN
process(clk,rst)
begin
	if rst = '1' then

		data_to_vme <= (others => '0');
		sel <= "0000";
		rdy_out <= '0';

	elsif clk'event and clk = '1' then
   rdy_out <= from_ace OR from_man OR from_serial_bram OR from_slink after 1 ns;
	sel <=  from_ace & from_man & from_serial_bram & from_slink after 1 ns;
		case sel is 
			when "0001" => data_to_vme <=  data_to_vme_vlink after 1 ns;
			when "0010" => data_to_vme <=  data_to_vme_serial after 1 ns;	
			when "0100" => data_to_vme <=  data_to_vme_man after 1 ns;
			when "1000" => data_to_vme <=  ACE_data_to_vme after 1 ns;
			when others => data_to_vme <=  data_to_vme after 1 ns;
		end case;	
	end if;			
end process;
END rtl;


