--
-- VHDL Architecture vme_slink.input_ddr.rtl
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BANGLADESH)
--          at - 13:58:38 06/30/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY input_ddr IS
   PORT( 
      clk              : IN     std_logic;
      data_vlink       : IN     std_logic_VECTOR (31 DOWNTO 0);
      rst              : IN     std_logic;
      en               : IN     std_logic;
      data_from_be_lsb : OUT    std_logic_VECTOR (31 DOWNTO 0);
      data_from_be_msb : OUT    std_logic_VECTOR (31 DOWNTO 0)
   );

-- Declarations

-- Declarations
-- attribute IOB : boolean;
-- attribute IOB of data_from_be_lsb : signal is true;      -- this line dosnt work you need to turn on Push flip flops into IOB in ISE
-- attribute IOB of data_from_be_msb : signal is true;


END input_ddr ;
ARCHITECTURE rtl OF input_ddr IS
BEGIN

q1reg : process (clk, rst)
	begin
	if rst='1' then 			--asynchronous reset, active high
		data_from_be_lsb <= (others => '0');
	elsif clk'event and clk='0' then 	--Clock event - -ve edge
		If en = '1' then
			data_from_be_lsb <= data_vlink;
		end if;
	end if;
end process;


q2reg : process (clk, rst)
	begin
		if rst='1' then --asynchronous reset, active high
			data_from_be_msb <= (others => '0');
		elsif clk'event and clk='1' then --Clock event - +ve edge
			if en = '1' then
				data_from_be_msb <= data_vlink;
			end if;
		end if;
end process;
END rtl;




















