--
-- VHDL Architecture vme_interface.address_inc.rtl
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BANGLADESH)
--          at - 09:19:35 09/20/02
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1a (Build 22)
--
-- hds interface_start
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY inc_address IS
   PORT( 
      BT           : IN     std_logic;
      address      : IN     std_logic_vector (15 DOWNTO 0);
      as           : IN     std_logic;
      block_en     : IN     std_logic;
      clk          : IN     std_logic;
      rst          : IN     std_logic;
      address_out  : OUT    std_logic_vector (15 DOWNTO 0);
      load_address : IN     std_logic
   );

-- Declarations

END inc_address ;


-- hds interface_end
ARCHITECTURE rtl OF inc_address IS
BEGIN
process ( clk,rst)
variable address_v : unsigned ( 7 downto 0);
begin
if rst = '1' then
	address_out <= ( others => '0');
	address_v := ( others => '0');
elsif 	clk'event and clk = '1' then 


		if BT = '1' and block_en = '1' then
			address_out <= (address(15 downto 10) & conv_std_logic_vector(address_v,8) & "00");
			address_v := address_v + 1;
		end if;
		
		if BT = '0' and block_en = '1' then
			address_out <= address;
		end if;
		
		if load_address = '1'  then
			address_v := unsigned(address(9 downto 2));
		end if;
			


	
end if;	
end process;			
END rtl;

