--
-- VHDL Architecture cmm.sr_ps.symbol
--
-- Created:
--          by - ipb28.UNKNOWN (TE2WILLENSTAD)
--          at - 16:13:37 18/01/01
--
-- Generated by Mentor Graphics' Renoir(TM) 2000.3 (Build 2)
--
-- hds interface_start
LIBRARY ieee ;
USE ieee.std_logic_1164.all;
USE ieee.numeric_std.all;


ENTITY i2c_sr_ps IS
   GENERIC( 
      width : integer := 16
   );
   PORT( 
      clk         : IN     std_logic;
      din_para    : IN     std_logic_vector (width-1 DOWNTO 0);
      din_serial  : IN     std_logic;
      en_shift    : IN     std_logic;
      load_para   : IN     std_logic;
      rst         : IN     std_logic;
      dout_serial : OUT    std_logic
   );

-- Declarations

END i2c_sr_ps ;


-- hds interface_end
------------------------------------------------------------------------------
ARCHITECTURE rtl OF i2c_sr_ps IS
------------------------------------------------------------------------------
------------------------------------------------------------------------------
BEGIN



  PROCESS(clk, rst)
    VARIABLE idata : std_logic_vector(width-1 downto 0);
  BEGIN
    if ( rst = '1' ) then
      idata := ( others => '0' );
    ELSE
	  if (clk'event and clk = '1') THEN
--        if (load_para = '1' or en_shift = '1') then
	      if ( load_para = '1' ) then
	        idata := din_para;
	      else
	        if (en_shift = '1') then
  	          IDATA(width-2 downto 0 ) := IDATA(width-1 downto 1);
	          IDATA(width-1) := din_serial;
	        end if;
          end if;
      end if;
    end if;
    dout_serial <= idata(0) after 1 ns;
  END PROCESS;


END rtl;

