--
-- VHDL Architecture cmm.sr_i2c_input.rtl
--
-- Created:
--          by - ipb28.UNKNOWN (TE2BELARUS)
--          at - 13:19:20 01/22/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1a (Build 22)
--
-- hds interface_start
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.numeric_std.all;


ENTITY i2c_sr_input IS
   PORT( 
      en_sr_in    : IN     std_logic;
      i2c_rst     : IN     std_logic;
      iclk40      : IN     std_logic;
      sda_in      : IN     std_logic;
      i2c_data_in : OUT    std_logic_vector (7 DOWNTO 0)
   );

-- Declarations

END i2c_sr_input ;


-- hds interface_end
--------------------------------------------------------------------------------
architecture rtl of i2c_sr_input is
--------------------------------------------------------------------------------
-- serial in, parallel out, 1 byte deep, MSB arrives first.
--
  signal data_held: std_logic_vector(7 downto 0);

--------------------------------------------------------------------------------
begin

  i2c_data_in <= data_held;

  sr_proc: process (i2c_rst, iclk40, en_sr_in, sda_in)
  begin
    --
    if (i2c_rst = '1') then
	  data_held <= (others=>'0');
    elsif (iclk40'event and iclk40 = '1') then
	  if (en_sr_in = '1') then
 	    data_held(0) <= sda_in;
 	    data_held(7 downto 1) <= data_held(6 downto 0);
	  end if;
	end if;
	--
  end process;			   

end rtl;

