--
-- VHDL Architecture cmm.reg.symbol
--
-- Created:
--          by - ipb28.UNKNOWN (TE2WILLENSTAD)
--          at - 10:47:43 31/10/01
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2001.3 (Build 11)
--
-- hds interface_start
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.numeric_std.all;


entity i2c_reg_e is
   generic( 
      width : integer   := 16;
      edge  : std_logic := '1'
   );
   port( 
      d   : in     std_logic_vector (width-1 downto 0);
      clk : in     std_logic;
      rst : in     std_logic;
      q   : out    std_logic_vector (width-1 downto 0);
      ce  : in     std_logic
   );

-- Declarations

end i2c_reg_e ;


-- hds interface_end
--------------------------------------------------------------------------------
ARCHITECTURE rtl OF i2c_reg_e IS
--------------------------------------------------------------------------------
-- Register with async reset
-- Generic parameters:
--   width = data width
--   edge  = clock edge used: 1 = rising, 0 = falling
--
--------------------------------------------------------------------------------
BEGIN

  regproc: process (rst, clk, d)
  begin
    if (rst = '1') then
      q <= (others=>'0');
    elsif (clk'event and clk = edge) then
	  if (ce = '1') then
        q <= d;
        -- functional timing stuff:
        -- pragma synthesis_off
        if (d'stable(1 ns) = false) then
          q <= d'last_value;
        end if;
        -- pragma synthesis_on
	  end if;
    end if;
  end process;

END rtl;

