--
-- VHDL Architecture cmm.sda_outmux.rtl
--
-- Created:
--          by - ipb28.UNKNOWN (TE2BELARUS)
--          at - 12:05:43 01/21/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1a (Build 22)
--
-- hds interface_start
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.numeric_std.all;


ENTITY i2c_monitor_sda_out IS
   PORT( 
      data_to_monitor  : IN     std_logic_vector (7 DOWNTO 0);
      i2c_rd_nwr       : IN     std_logic;
      sel_pointer      : IN     std_logic;
      monitor_cmnd     : IN     std_logic_vector (7 DOWNTO 0);
      monitor_ptr_addr : IN     std_logic_vector (6 DOWNTO 0);
      pda_out          : OUT    std_logic_vector (15 DOWNTO 0);
      rst              : IN     std_logic
   );

-- Declarations

END i2c_monitor_sda_out ;


-- hds interface_end
--------------------------------------------------------------------------------
architecture rtl of i2c_monitor_sda_out is
--------------------------------------------------------------------------------
-- Load the S/R with address & 1 data byte
-- (data not transmitted for read operation).
-- Bit-swap each byte so MSB is tranmitted first:
--
--------------------------------------------------------------------------------
begin

  --
  --
  muxproc: process (rst, sel_pointer, i2c_rd_nwr, monitor_cmnd, monitor_ptr_addr, data_to_monitor)
  begin
  
    if (rst = '1') then
	  pda_out <= (others => '0');
    elsif (sel_pointer = '1') then
	  -- writing to voltage monitor pointer register:
      pda_out <= (
          -- byte 1:
          0 => monitor_ptr_addr(6),
          1 => monitor_ptr_addr(5),
          2 => monitor_ptr_addr(4),
          3 => monitor_ptr_addr(3),
          4 => monitor_ptr_addr(2),
          5 => monitor_ptr_addr(1),
          6 => monitor_ptr_addr(0),
          7 => '0', -- write
		  -- byte 2:
         8 => monitor_cmnd(7),
         9 => monitor_cmnd(6),
         10 => monitor_cmnd(5),
         11 => monitor_cmnd(4),
         12 => monitor_cmnd(3),
         13 => monitor_cmnd(2),
         14 => monitor_cmnd(1),
         15 => monitor_cmnd(0)   
      );	 
    elsif (i2c_rd_nwr = '0') then
	  -- writing data....
      pda_out <= (
	      -- byte 1:
          0 => data_to_monitor(7),
          1 => data_to_monitor(6),
          2 => data_to_monitor(5),
          3 => data_to_monitor(4),
          4 => data_to_monitor(3),
          5 => data_to_monitor(2),
          6 => data_to_monitor(1),
          7 => data_to_monitor(0), 
		  -- byte 2:
          8 => '0',
          9 => '0',
         10 => '0',
         11 => '0',
         12 => '0',
         13 => '0',
         14 => '0',
         15 => '0'  
      );
    elsif (i2c_rd_nwr = '1') then
	  -- reading data....
      pda_out <= (
	      -- byte 1:
          0 => monitor_ptr_addr(6),
          1 => monitor_ptr_addr(5),
          2 => monitor_ptr_addr(4),
          3 => monitor_ptr_addr(3),
          4 => monitor_ptr_addr(2),
          5 => monitor_ptr_addr(1),
          6 => monitor_ptr_addr(0),
          7 => i2c_rd_nwr, 
		  -- byte 2:
          8 => '0',
          9 => '0',
         10 => '0',
         11 => '0',
         12 => '0',
         13 => '0',
         14 => '0',
         15 => '0'  
      );
	  end if;
  end process;
end rtl;

