--
-- VHDL Architecture cmm.clk_div.rtl
--
-- Created:
--          by - ipb28.UNKNOWN (TE2BELARUS)
--          at - 13:13:42 01/17/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1a (Build 22)
--
-- hds interface_start
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.numeric_std.all;


ENTITY i2c_clk_gen IS
   PORT( 
      clk40      : IN     std_logic;
      i2c_rst    : IN     std_logic;
      scl_source : OUT    std_logic;
      ce_i2c     : OUT    std_logic;
      ce_i2c_rcv : OUT    std_logic
   );

-- Declarations

END i2c_clk_gen ;


-- hds interface_end
--------------------------------------------------------------------------------
architecture rtl of i2c_clk_gen is
--------------------------------------------------------------------------------
-- To keep Xilinx happy, generate CE signal, ce_i2c, of appropriately low 
-- frequency rather than use combinatorial logic to drive a clock net.
-- scl_source clocks I2C, but doesn't clock any internal logic here. 
--
  constant topbit: natural := 9;	-- MSB of internal counter = reset
  --
  -- the count at which we generate ce_i2c:
  constant cnt_ce_i2c:     unsigned := "010000000"; 
  constant cnt_ce_i2c_rcv: unsigned := "110000000"; 

  --
  signal count: unsigned(topbit-1 downto 0);
  signal rst_cnt: std_logic;
--------------------------------------------------------------------------------
begin

  countproc: process (i2c_rst, clk40, count)
    variable newcount: unsigned (topbit downto 0);
  begin
	--
	if (clk40'event and clk40 = '1') then
	  newcount   := ('0' & count) + 1;
      --ce_i2c     <= newcount(topbit);
      scl_source <= newcount(topbit-1);
      rst_cnt    <= newcount(topbit) or i2c_rst;
	  --
	  if (rst_cnt = '1') then
		count <= (others=>'0');
      else
        count <= newcount(topbit-1 downto 0);
      end if;
      --
	  if (count = cnt_ce_i2c) then
	    ce_i2c <= '1';
	  else
	    ce_i2c <= '0';
	  end if;
      --
	  if (count = cnt_ce_i2c_rcv) then
	    ce_i2c_rcv <= '1';
	  else
	    ce_i2c_rcv <= '0';
	  end if;
      --
  	end if;
  end process;

end rtl;















