-- takes the Globle Address lines from the VME after they have been debounced and sync'ed
-- checks the parity and outputs the slot no. or an slot_error bit.
-- valid addresss is No. on slot_no and slot_error = 0
-- not a valid address is slot_no = 0 and slot_error = 1
--
-- VHDL Architecture vme_interface.glob_address_parity.rtl
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BANGLADESH)
--          at - 14:56:58 08/08/02
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1a (Build 22)
--
-- hds interface_start
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY glob_address_parity IS
   PORT( 
      clk           : IN     std_logic;
      n_ga0         : IN     std_logic;
      n_ga1         : IN     std_logic;
      n_ga2         : IN     std_logic;
      n_ga3         : IN     std_logic;
      n_ga4         : IN     std_logic;
      n_gap         : IN     std_logic;
      rst           : IN     std_logic;
      slot_error 	: OUT    std_logic;
      slot_no       : OUT    std_logic_vector (4 DOWNTO 0)
   );

-- Declarations

END glob_address_parity ;


-- hds interface_end
ARCHITECTURE rtl OF glob_address_parity IS
signal g_address : std_logic_vector(5 downto 0);
BEGIN
g_address <= (n_gap & n_ga4 & n_ga3 & n_ga2 & n_ga1 & n_ga0);
Process (clk, rst)
begin
   if rst = '1' then
   slot_error <= '1';
   slot_no <= (others => '0');
   else
		case   g_address is

 -- commented out as old back panel and slot one are not valid for CMS-FED cards


--		when "111111" =>		   		-- address 0  -- this one will detect if in old back panel
--			slot_error <= '1';
--			slot_no <= "00000";

--		when "111110" =>    			-- address 1	-- this is the slot one controler slot and this is a slave interface 
--			slot_error <= '0';
--			slot_no <= "00001";

		when "111101" =>  				-- address 2
			slot_error <= '0';
			slot_no <= "00010";

 		when "011100" =>  				-- address 3
			slot_error <= '0';
			slot_no <= "00011";

 		when "111011" =>   				-- address 4
 			slot_error <= '0';
			slot_no <= "00100";

  		when "011010" =>   				-- address 5
 			slot_error <= '0';
			slot_no <= "00101";

  		when "011001" => 				-- address 6
 			slot_error <= '0';
			slot_no <= "00110";

  		when "111000" => 				-- address 7
 			slot_error <= '0';
			slot_no <= "00111";


 		when "110111" =>  				-- address 8
 			slot_error <= '0';
			slot_no <= "01000";

  		when "010110" =>  				-- address 9
 			slot_error <= '0';
			slot_no <= "01001";


 		when "010101" =>				-- address 10
 			slot_error <= '0';
			slot_no <= "01010";


		when "110100" =>  				-- address 11
 			slot_error <= '0';
			slot_no <= "01011";
		

  		when "010011" =>				-- address 12
 			slot_error <= '0';
			slot_no <= "01100";


  		when "110010" =>		   		-- address 13
 			slot_error <= '0';
			slot_no <= "01101";


  		when "110001" =>		   		-- address 14
 			slot_error <= '0';
			slot_no <= "01110";

  		when "010000" =>		   		-- address 15
 			slot_error <= '0';
			slot_no <= "01111";


 		when "101111" =>		   		-- address 16
 			slot_error <= '0';
			slot_no <= "10000";

 		when "001110" =>		   		-- address 17
 			slot_error <= '0';
			slot_no <= "10001";


  		when "001101" =>		   		-- address 18
 			slot_error <= '0';
			slot_no <= "10010";


  		when "101100" =>		   		-- address 19
 			slot_error <= '0';
			slot_no <= "10011";

  		when "001011" =>		   		-- address 20
 			slot_error <= '0';
			slot_no <= "10100";

  		when "101010" =>		   		-- address 21
 			slot_error <= '0';
			slot_no <= "10101";

		when others =>
			slot_error <= '1';
			slot_no <= "00000";
		end case;
	end if;
end process;
END rtl;

