--
-- VHDL Architecture vme_slink.frame_counter.rtl
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BANGLADESH)
--          at - 16:11:26 06/26/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds interface_start
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY frame_counter IS
   PORT( 
      CNTRL        : IN     std_logic;
      clk          : IN     std_logic;
      rst          : IN     std_logic;
      frame_count  : OUT    std_logic_vector (31 DOWNTO 0);
      last         : OUT    std_logic
   );

-- Declarations

END frame_counter ;


-- hds interface_end
ARCHITECTURE rtl OF frame_counter IS
signal go 	 : std_logic;
BEGIN
process(clk,rst)
variable v_count : unsigned(31 downto 0);
BEGIN

If rst = '1' then

	go <= '0';
	frame_count  <= (others => '0');
	v_count      := (others => '0');
	last 	     <= '0';
elsif clk'event and clk = '1' then
	If CNTRL = '1' then
		go <= not go;
		If (go = '1' ) then
			last 	     <= '1';
		else 
			last 	     <= '0';
			v_count := v_count + 1;
		end if;
	else
	end if;	
	frame_count <= conv_std_logic_vector(v_count,32);
end if;
end process;
END rtl;

