--
-- VHDL Architecture vme_slink.data_to_vme_mux.rtl
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BANGLADESH)
--          at - 14:38:42 06/30/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds interface_start
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY data_to_vme_mux IS
   PORT( 
      data_bram_vlink   : IN     std_logic_VECTOR (31 DOWNTO 0);
      frame_count       : IN     std_logic_vector (31 DOWNTO 0);
      length_count      : IN     std_logic_vector (31 DOWNTO 0);
      addrb             : IN     std_logic_vector (11 DOWNTO 0);
      read_addrb        : IN     std_logic;
      clk		: IN 	 std_logic;
      rst 		: IN 	 std_logic;
      from_slink	: OUT    std_logic;
      read_bram         : IN     std_logic;
      read_frame_count  : IN     std_logic;
      read_frame_length : IN     std_logic;
      read_run_data     : IN     std_logic;
      run_data          : IN     std_logic_vector (31 DOWNTO 0);
      data_to_vme       : OUT    std_logic_VECTOR (31 DOWNTO 0)
   );

-- Declarations

END data_to_vme_mux ;


-- hds interface_end
ARCHITECTURE rtl OF data_to_vme_mux IS
	
BEGIN


process (clk , rst)
begin
if rst = '1' then
		from_slink <= '0';
		data_to_vme <= (others => '0');
	elsif clk'event and clk = '1' then
	 if read_addrb = '1' then
	 	data_to_vme <=  ("0000000000000000000" & addrb & '0');-- pack out to same length mul by 2 to put in 32 bit words
	 	from_slink <= '1';
	 elsif read_bram 	= '1' then
	 	data_to_vme <= 	data_bram_vlink;
	 	from_slink <= '1';
	 	
	 elsif read_run_data 	= '1' then 		
	 	data_to_vme <= 	run_data;
	 	from_slink <= '1';
	 	
	 elsif read_frame_count = '1' then
		data_to_vme <= 	frame_count;
		from_slink <= '1';
		
	 elsif read_frame_length = '1' then
	    data_to_vme <= 	length_count;
	    from_slink <= '1';
	 else 
	 	from_slink <= '0';
	 end if;
	
end if;			
end process;			
END rtl;	

