--
-- VHDL Architecture vme_managment.data_from_man_mux.rtl
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BANGLADESH)
--          at - 15:47:35 08/07/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY data_from_man_mux IS
   PORT( 
      FED_ID          : IN     std_logic_vector (31 DOWNTO 0);
      clk             : IN     std_logic;
      data_bp_count   : IN     std_logic_vector (31 DOWNTO 0);
      data_clk_sel    : IN     std_logic_vector (31 DOWNTO 0);
      data_eprom_rd   : IN     std_logic_vector (31 DOWNTO 0);
      data_firm_id    : IN     std_logic_vector (31 DOWNTO 0);
      data_lm82_rd    : IN     std_logic_vector (31 DOWNTO 0);
      data_monitor_rd : IN     std_logic_vector (31 DOWNTO 0);
      data_stat_reg   : IN     std_logic_vector (31 DOWNTO 0);
      data_ttc_count  : IN     std_logic_vector (31 DOWNTO 0);
      for_FED_ID      : IN     std_logic;
      for_bp_count    : IN     std_logic;
      for_clk_sel     : IN     std_logic;
      for_eprom_rd    : IN     std_logic;
      for_firm_ID     : IN     std_logic;
      for_lm82_rd     : IN     std_logic;
      for_monitor_rd  : IN     std_logic;
      for_stat_reg    : IN     std_logic;
      for_ttc_count   : IN     std_logic;
      rst             : IN     std_logic;
      data_to_vme_man : OUT    std_logic_VECTOR (31 DOWNTO 0);
      from_man        : OUT    std_logic
   );

-- Declarations

END data_from_man_mux ;
ARCHITECTURE rtl OF data_from_man_mux IS
BEGIN
process(clk,rst)
begin
if rst = '1' then
	from_man <= '0';
	data_to_vme_man <= (others => '0') after 1 ns;
	
elsif clk'event and clk = '1' then

	if for_firm_id = '1' then
		from_man <= '1' after 1 ns;
		data_to_vme_man <= data_firm_id after 1 ns;
		
	elsif for_clk_sel = '1' then
		from_man <= '1' after 1 ns;
		data_to_vme_man <= data_clk_sel after 1 ns;

	elsif for_stat_reg = '1' then
		from_man <= '1' after 1 ns;
		data_to_vme_man <= data_stat_reg after 1 ns;
	
	elsif for_ttc_count = '1' then
		from_man <= '1' after 1 ns;
		data_to_vme_man <= data_ttc_count after 1 ns;

	elsif for_bp_count = '1' then
		from_man <= '1' after 1 ns;
		data_to_vme_man <= data_bp_count after 1 ns;

	elsif for_eprom_rd = '1' then
		from_man <= '1' after 1 ns;
		data_to_vme_man <= data_eprom_rd after 1 ns;	-- read data from ID PROM

	elsif for_lm82_rd = '1' then
		from_man <= '1' after 1 ns;
		data_to_vme_man <= data_lm82_rd after 1 ns;	-- read data from lm82

	elsif for_monitor_rd = '1' then
		from_man <= '1' after 1 ns;
		data_to_vme_man <= data_monitor_rd after 1 ns;	-- read data from voltage monitor

	elsif for_FED_ID = '1' then
		from_man <= '1' after 1 ns;
		data_to_vme_man <= FED_ID after 1 ns;	-- read data from FED ID reg

	else
		from_man <= '0' after 1 ns;

	end if;
end if;
end process;

END rtl;

