--
-- VHDL Architecture vme_firmware.cntr_13bits.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 09:13:06 12/08/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds interface_start
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY cntr_13bits IS
   PORT( 
      clk : IN     std_logic;
      clr : IN     std_logic;
      en  : IN     std_logic;
      Q   : OUT    std_logic_vector (12 DOWNTO 0);
      max : OUT    std_logic
   );

-- Declarations

END cntr_13bits ;


-- hds interface_end
ARCHITECTURE rtl OF cntr_13bits IS
constant TERMINAL_COUNT : std_logic_vector(12 downto 0) := (others => '1'); 
BEGIN

process(clk, clr)
	variable v_count : integer;
begin
	if clr = '1' then
		Q <= (others => '0');
		v_count := 0;
		max <= '1';  -- to apply reset to DCM on power up
	elsif clk'event and clk = '1' then
	 	if en = '1' then
			v_count := v_count + 1;
			Q <= conv_std_logic_vector(v_count,13) after 1 ns;
			if (conv_std_logic_vector(v_count,13) = TERMINAL_COUNT) then
				max <= '1' after 1 ns;
			else
				max <= '0'after 1 ns;
			end if;
		end if;
	end if;
end process;

END rtl;

