--
-- VHDL Architecture vme_firmware.BO_selecta.rtl_with_dcm_status
--
-- Created:
--          by - st79.UNKNOWN (TE2MALDIVES)
--          at - 10:58:11 02/20/04
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds interface_start
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY clk_select IS
   PORT( 
      clk             : IN     std_logic;
      data_clk_sel    : IN     std_logic_vector (31 DOWNTO 0);
      for_clk_sel_int : IN     std_logic;
      locked_bp_B     : IN     std_logic;
      locked_ttc_B    : IN     std_logic;
      rst             : IN     std_logic;
      RST_DCM         : OUT    std_logic;
      clk_sel_1       : BUFFER std_logic;
      clk_sel_2       : BUFFER std_logic;
      clk_sel_3       : BUFFER std_logic;
      locked_xtal_B   : IN     std_logic;
      write           : IN     std_logic;
      clk_changed     : OUT    std_logic;
      no_TTC_clk      : IN     std_logic;
      no_BP_clk       : IN     std_logic;
      no_onboard_clk  : IN     std_logic;
      no_xtal_clk     : IN     std_logic
   );

-- Declarations

END clk_select ;



-- hds interface_end
ARCHITECTURE rtl_with_dcm_status OF clk_select IS

-- added DCM status signals on 20-02-2004

signal a,b,f,g : std_logic;

BEGIN
process(clk, rst)
begin

if rst = '1' then
		clk_sel_1 <= '0';
		clk_sel_2 <= '0';
		clk_sel_3 <= '1';
		RST_DCM <= '0';
		clk_changed <= '0';
		a <= '0';
		b <= '0';
		f <= '0';
		g <= '0';
elsif clk'event and clk = '1' then

	a <= write; -- delay the clock_select valid signal so VME DTACK has time to complete
	b <= a;

	f <= for_clk_sel_int; -- delay the clock_select valid signal so VME DTACK has time to complete
	g <= f;

	if (g = '1' and b = '1') then
		-- if request bp clk  and bp is present
		if 		(no_BP_clk = '0' AND locked_bp_B = '0' and data_clk_sel(2) = '1' and data_clk_sel(0) = '0') then	
				clk_sel_1 <= '1';	  -- go to backplane clock
				clk_sel_2 <= '0';	
				clk_sel_3 <= '0';	
				RST_DCM <= '1';		   -- and generate a reset
			
		-- if request ttc clk  and ttc is present
		elsif	(no_TTC_clk = '0' AND locked_ttc_B = '0' and data_clk_sel(2) = '0' and data_clk_sel(1) = '1') then	
				clk_sel_1 <= '0';
				clk_sel_2 <= '1';	  -- go to ttc clock	
				clk_sel_3 <= '0';
				RST_DCM <= '1';	    -- and generate a reset
   	
		-- if request xtal clk  and xtal is present (two ways of selecting ctal clk)
		elsif	((no_xtal_clk = '0' AND locked_xtal_B = '0' and data_clk_sel(2) = '0' and data_clk_sel(1) = '0')  or
				 (no_xtal_clk = '0' AND locked_xtal_B = '0' and data_clk_sel(2) = '1' and data_clk_sel(0) = '1')) then	
				clk_sel_1 <= '0';
				clk_sel_2 <= '0';	
				clk_sel_3 <= '1';	  -- go to Baord Xtal
				RST_DCM <= '1';	    -- and generate a reset
		else
			RST_DCM <= '0';	    -- leave things as they are
		end if;

	else
		-- if using bp clk and bp clk fails
		if	(g = '0' and locked_bp_B = '1' and clk_sel_1 = '1' and clk_sel_3 = '0') OR		-- loses lock
			(g = '0' and no_BP_clk = '1' and clk_sel_1 = '1' and clk_sel_3 = '0') then		-- loses input clock
			clk_sel_1 <= '0';
			clk_sel_2 <= '0';	
			clk_sel_3 <= '1';	  -- drop back to Baord Xtal
			RST_DCM <= '1';	    -- and generate a reset

		-- if using ttc clk and ttc clk fails
		elsif	(g = '0' and locked_ttc_B = '1' and clk_sel_1 = '0' and clk_sel_2 = '1') OR	-- loses lock
				(g = '0' and no_TTC_clk = '1' and clk_sel_1 = '0' and clk_sel_2 = '1') then	-- loses input clock
				clk_sel_1 <= '0';
				clk_sel_2 <= '0';	
				clk_sel_3 <= '1';	  -- drop back to Baord Xtal
				RST_DCM <= '1';	    -- and generate a reset
		else
			RST_DCM <= '0';	    -- leave things as they are
		end if;
	end if;
end if;
end process;

END rtl_with_dcm_status;

