--
-- VHDL Architecture vme_interface.am_decode.rtl
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BANGLADESH)
--          at - 09:41:00 08/12/02
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1a (Build 22)
--
-- hds interface_start
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY am_decoder IS
   PORT( 
      AM_bus_a        : IN     std_logic_vector (5 DOWNTO 0);
      address_latched : IN     std_logic_vector (31 DOWNTO 1);
      clk             : IN     std_logic;
      as              : IN     std_logic;
	  lsb 			  : IN 	   std_logic;
      n_iack_a        : IN     std_logic;
      rst             : IN     std_logic;
	  am_error		  : out    std_logic;
      slot_no         : IN     std_logic_vector (4 DOWNTO 0);
      address         : OUT    std_logic_vector (15 DOWNTO 0);
      zone_16         : OUT    std_logic;
      zone_24         : OUT    std_logic;
      zone_32         : OUT    std_logic;
	  BT		  	  : OUT    std_logic;   -- block trans
      zone_40         : OUT    std_logic;
      zone_64         : OUT    std_logic;
      zone_CSR        : OUT    std_logic
   );

-- Declarations

END am_decoder ;


-- hds interface_end
ARCHITECTURE rtl OF am_decoder IS
BEGIN


process (clk, rst)

  constant A32SP	: std_logic_vector := "001110"; --0E
  constant A32SD	: std_logic_vector := "001101"; --0D
  constant A32NPP	: std_logic_vector := "001010"; --0A
  constant A32NPD	: std_logic_vector := "001001"; --09

   -- block TX sets
  constant A32NPBT	: std_logic_vector := "001011"; --0B
  constant A32SBT 	: std_logic_vector := "001111"; --0F

  -- 64bit block TX not inplemennted yet
  constant A32NPMBT 	: std_logic_vector := "001000"; --08
  constant A32SMBT 		: std_logic_vector := "001100"; --0C

begin
	if rst = '1' then
	  am_error		<= '0';
	  zone_16 		<= '0';
     zone_24  		<= '0';
 	  zone_32 		<= '0';
     zone_40 		<= '0';
     zone_64 		<= '0';
	  zone_CSR		<= '0';
	  BT     		<= '0';
	  address 		<= (others => '0');
  	elsif
		clk'event and clk = '1' then
			If as = '1' then
			   If (address_latched(31 downto 21) = "00000000000" and address_latched(20 downto 16) = slot_no) -- test if address is for this card. if so enable the correct address area
				
				then address(15 downto 0) <= (address_latched(15 downto 1) & lsb);
			 		
			 		case AM_bus_a is
		 				when  A32SP | A32SD | A32NPP |  A32NPD =>   				-- AM code for 32bit tx
								zone_16 	<= '0';
     								zone_24  	<= '0';
 	  							zone_32 	<= '1'; 
      								zone_40 	<= '0';
      								zone_64 	<= '0';
								zone_CSR	<= '0';
								am_error	<= '0';
								BT     		<= '0';

						when A32NPBT | A32SBT  =>   				-- AM code for 32bit tx
								zone_16 	<= '0';
     								zone_24  	<= '0';
 	  							zone_32 	<= '1'; 
      								zone_40 	<= '0';
      								zone_64 	<= '0';
								zone_CSR	<= '0';
								am_error	<= '0';
								BT       	<= '1';

 		 				when others =>   				
      				    	  		zone_16 		<= '0';
     							zone_24  	<= '0';
 	  						zone_32 	 <= '0'; -- not a valid/recognised opcode
      							zone_40 	 <= '0';
      							zone_64 	 <= '0';	
	    						zone_CSR	 <= '0';
							am_error	 <= '1';
							BT       	<= '0';
					end case;
				else
					address <= (others => '0');
					zone_16 		<= '0';
     				   zone_24  	<= '0';
 	  				zone_32 		<= '0'; 	-- address(31:27) dose not match the globle address there fore not for this card
      				   zone_40 		<= '0';
      				   zone_64 		<= '0';
					zone_CSR		<= '0';
					am_error		<= '0';		-- not for this card so not an error
					BT       	<= '0';
				end if;
		  else
			address <= (others => '0');
			zone_16 		<= '0';
     			zone_24  		<= '0';
 	  		zone_32 		<= '0'; 	-- no as
      			zone_40 		<= '0';
      			zone_64 		<= '0';
			zone_CSR		<= '0';
			am_error		<= '0';		-- not for this card so not an error
			BT       		<= '0';
	   	end if;
	end if;
end process;
END rtl;








