--
-- VHDL Architecture vme_slink.address_gen.rtl
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BANGLADESH)
--          at - 13:21:04 06/24/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds interface_start
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY address_gen IS
   PORT( 
      clear  : IN     	std_logic;
      clk    : IN     	std_logic;
      en     : IN     	std_logic;
      rst    : IN     	std_logic;
      addrb  : BUFFER   std_logic_VECTOR (11 DOWNTO 0);
      stop   : OUT   	std_logic
   );

-- Declarations

END address_gen ;


-- hds interface_end
ARCHITECTURE rtl OF address_gen IS
begin
process(clk,rst)
variable v_count : unsigned(11 downto 0);
begin
	if rst = '1' then
		addrb 	<= (others => '0');
		v_count := (others => '0');
		stop 	<= '0';
		
	elsif clk'event and clk = '1' then
	
	
		If clear = '1' then
			v_count := (others => '0');
			stop 	<= '0';
		end if;
		
		
		IF en = '1' then
			v_count := v_count + 1;
				     
			If addrb >= "111111100111" then	-- the address when it lets controller know it is running out of memory space
				Stop <= '1';
			else
				stop <= '0';
		   	end if;
		else
			stop <= '0';
		
		end if;
		addrb <= conv_std_logic_vector(v_count,12);
   	end if;
end process;
END rtl;

