--
-- VHDL Architecture vme_managment.address_decoder_man.rtl
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BANGLADESH)
--          at - 14:34:42 08/07/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY address_decoder_man IS
   PORT( 
      addr_from_vme      : IN     std_logic_vector (15 DOWNTO 0);
      clk                : IN     std_logic;
      data_ready         : IN     std_logic;
      rst                : IN     std_logic;
      for_bp_count       : OUT    std_logic;
      for_clk_sel        : OUT    std_logic;
      for_firm_ID        : OUT    std_logic;
      for_stat_reg       : OUT    std_logic;
      for_sw_reset       : OUT    std_logic;
      for_TTC_bp_dcm_rst : OUT    std_logic;
      for_ttc_count      : OUT    std_logic;
      for_eprom_wr       : OUT    std_logic;
      for_eprom_rd       : OUT    std_logic;
      for_lm82_wr        : OUT    std_logic;
      for_lm82_rd        : OUT    std_logic;
      for_monitor_wr     : OUT    std_logic;
      for_monitor_rd     : OUT    std_logic;
      for_FED_ID         : OUT    std_logic
   );

-- Declarations

END address_decoder_man ;
ARCHITECTURE rtl OF address_decoder_man IS
BEGIN
process(clk,rst)

begin
	if rst = '1' then
	
		for_firm_ID     	<= '0' after 1 ns;
		for_clk_sel     	<= '0' after 1 ns;	
		for_sw_reset    	<= '0' after 1 ns;	
		for_stat_reg    	<= '0' after 1 ns;   
		for_ttc_count   	<= '0' after 1 ns;  
     	for_bp_count    	<= '0' after 1 ns;
   	  for_TTC_bp_dcm_rst 	<= '0' after 1 ns;
		for_eprom_wr    <= '0' after 1 ns;  
		for_eprom_rd    <= '0' after 1 ns;  
		for_lm82_wr    <= '0' after 1 ns;  
		for_lm82_rd    <= '0' after 1 ns;  
		for_monitor_wr    <= '0' after 1 ns;  
		for_monitor_rd    <= '0' after 1 ns;  
		for_FED_ID    <= '0' after 1 ns;  
		
	elsif clk'event and clk = '1' then

		if data_ready = '1' then
			case addr_from_vme is

				when "0000100000010000" =>	    -- 0x0810 FED ID
					for_firm_ID     <= '0' after 1 ns;
					for_clk_sel     <= '0' after 1 ns;	
					for_sw_reset    <= '0' after 1 ns;	
					for_stat_reg    <= '0' after 1 ns;  
					for_ttc_count   <= '0' after 1 ns;  
					for_bp_count    <= '0' after 1 ns;  
					for_TTC_bp_dcm_rst    <= '0' after 1 ns; 
					for_eprom_wr    <= '0' after 1 ns;  
					for_eprom_rd    <= '0' after 1 ns;  
					for_lm82_wr    <= '0' after 1 ns;  
					for_lm82_rd    <= '0' after 1 ns;  
					for_monitor_wr    <= '0' after 1 ns;  
					for_monitor_rd    <= '0' after 1 ns;  
             		for_FED_ID    <= '1' after 1 ns;  
				
				when "0000100000110000" =>	    -- 0x0830 firmware ID
					for_firm_ID     <= '1' after 1 ns;
					for_clk_sel     <= '0' after 1 ns;	
					for_sw_reset    <= '0' after 1 ns;	
					for_stat_reg    <= '0' after 1 ns;  
					for_ttc_count   <= '0' after 1 ns;  
					for_bp_count    <= '0' after 1 ns;  
					for_TTC_bp_dcm_rst    <= '0' after 1 ns; 
					for_eprom_wr    <= '0' after 1 ns;  
					for_eprom_rd    <= '0' after 1 ns;  
					for_lm82_wr    <= '0' after 1 ns;  
					for_lm82_rd    <= '0' after 1 ns;  
					for_monitor_wr    <= '0' after 1 ns;  
					for_monitor_rd    <= '0' after 1 ns;  
             		for_FED_ID    <= '0' after 1 ns;  
				
				when "0000100000110100" =>		-- 0x0834 clock select 	
					for_firm_ID     <= '0' after 1 ns;
					for_clk_sel     <= '1' after 1 ns;	
					for_sw_reset    <= '0' after 1 ns;	
					for_stat_reg    <= '0' after 1 ns;  
					for_ttc_count   <= '0' after 1 ns;  
					for_bp_count    <= '0' after 1 ns;  
					for_TTC_bp_dcm_rst    <= '0' after 1 ns; 
					for_eprom_wr    <= '0' after 1 ns;  
					for_eprom_rd    <= '0' after 1 ns;  
					for_lm82_wr    <= '0' after 1 ns;  
					for_lm82_rd    <= '0' after 1 ns;  
					for_monitor_wr    <= '0' after 1 ns;  
					for_monitor_rd    <= '0' after 1 ns;  
             		for_FED_ID    <= '0' after 1 ns;  
					
				when "0000100000111000" =>		-- 0x0838 SW reset 	
					for_firm_ID     <= '0' after 1 ns;
					for_clk_sel     <= '0' after 1 ns;	
					for_sw_reset    <= '1' after 1 ns;	
					for_stat_reg    <= '0' after 1 ns;  
					for_ttc_count   <= '0' after 1 ns;  
					for_bp_count    <= '0' after 1 ns;  
					for_TTC_bp_dcm_rst    <= '0' after 1 ns; 
					for_eprom_wr    <= '0' after 1 ns;  
					for_eprom_rd    <= '0' after 1 ns;  
					for_lm82_wr    <= '0' after 1 ns;  
					for_lm82_rd    <= '0' after 1 ns;  
					for_monitor_wr    <= '0' after 1 ns;  
					for_monitor_rd    <= '0' after 1 ns;  
             		for_FED_ID    <= '0' after 1 ns;  
				
				when "0000100000111100" =>		-- 0x083C Status register 	
					for_firm_ID     <= '0' after 1 ns;				
					for_clk_sel     <= '0' after 1 ns;	
					for_sw_reset    <= '0' after 1 ns;	
					for_stat_reg    <= '1' after 1 ns;  
					for_ttc_count   <= '0' after 1 ns;  
					for_bp_count    <= '0' after 1 ns; 
					for_TTC_bp_dcm_rst    <= '0' after 1 ns; 
					for_eprom_wr    <= '0' after 1 ns;  
					for_eprom_rd    <= '0' after 1 ns;  
					for_lm82_wr    <= '0' after 1 ns;  
					for_lm82_rd    <= '0' after 1 ns;  
					for_monitor_wr    <= '0' after 1 ns;  
					for_monitor_rd    <= '0' after 1 ns;  
             		for_FED_ID    <= '0' after 1 ns;  
				
				when "0000100001000000" =>		-- 0x0840 TTC clock count 	
					for_firm_ID     <= '0' after 1 ns;				
					for_clk_sel     <= '0' after 1 ns;	
					for_sw_reset    <= '0' after 1 ns;	
					for_stat_reg    <= '0' after 1 ns;  
					for_ttc_count   <= '1' after 1 ns;  
					for_bp_count    <= '0' after 1 ns; 
					for_TTC_bp_dcm_rst    <= '0' after 1 ns; 
					for_eprom_wr    <= '0' after 1 ns;  
					for_eprom_rd    <= '0' after 1 ns;  
					for_monitor_wr    <= '0' after 1 ns;  
					for_monitor_rd    <= '0' after 1 ns;  
             		for_FED_ID    <= '0' after 1 ns;  
					
				when "0000100001000100" =>		-- 0x0844 BP clock count 	
					for_firm_ID     <= '0' after 1 ns;				
					for_clk_sel     <= '0' after 1 ns;	
					for_sw_reset    <= '0' after 1 ns;	
					for_stat_reg    <= '0' after 1 ns;  
					for_ttc_count   <= '0' after 1 ns;  
					for_bp_count    <= '1' after 1 ns; 
					for_TTC_bp_dcm_rst    <= '0' after 1 ns; 
					for_eprom_wr    <= '0' after 1 ns;  
					for_eprom_rd    <= '0' after 1 ns;  
					for_lm82_wr    <= '0' after 1 ns;  
					for_lm82_rd    <= '0' after 1 ns;  
					for_monitor_wr    <= '0' after 1 ns;  
					for_monitor_rd    <= '0' after 1 ns;  
             		for_FED_ID    <= '0' after 1 ns;  
 
				when "0000100001001000" =>		-- 0x0848 TTC & Back plane DCM reset
					for_firm_ID     <= '0' after 1 ns;				
					for_clk_sel     <= '0' after 1 ns;	
					for_sw_reset    <= '0' after 1 ns;	
					for_stat_reg    <= '0' after 1 ns;  
					for_ttc_count   <= '0' after 1 ns;  
					for_bp_count    <= '0' after 1 ns; 
					for_TTC_bp_dcm_rst    <= '1' after 1 ns; 
					for_eprom_wr    <= '0' after 1 ns;  
					for_eprom_rd    <= '0' after 1 ns;  
					for_lm82_wr    <= '0' after 1 ns;  
					for_lm82_rd    <= '0' after 1 ns;  
					for_monitor_wr    <= '0' after 1 ns;  
					for_monitor_rd    <= '0' after 1 ns;  
             		for_FED_ID    <= '0' after 1 ns;  

				when "0000100001100000" =>		-- 0x0860 eprom write 	
					for_firm_ID     <= '0' after 1 ns;				
					for_clk_sel     <= '0' after 1 ns;	
					for_sw_reset    <= '0' after 1 ns;	
					for_stat_reg    <= '0' after 1 ns;  
					for_ttc_count   <= '0' after 1 ns;  
					for_bp_count    <= '0' after 1 ns; 
					for_TTC_bp_dcm_rst    <= '0' after 1 ns; 
					for_eprom_wr    <= '1' after 1 ns;  
					for_eprom_rd    <= '0' after 1 ns;  
					for_lm82_wr    <= '0' after 1 ns;  
					for_lm82_rd    <= '0' after 1 ns;  
					for_monitor_wr    <= '0' after 1 ns;  
					for_monitor_rd    <= '0' after 1 ns;  
             		for_FED_ID    <= '0' after 1 ns;  
 
				when "0000100001100100" =>		-- 0x0864 eprom read 	
					for_firm_ID     <= '0' after 1 ns;				
					for_clk_sel     <= '0' after 1 ns;	
					for_sw_reset    <= '0' after 1 ns;	
					for_stat_reg    <= '0' after 1 ns;  
					for_ttc_count   <= '0' after 1 ns;  
					for_bp_count    <= '0' after 1 ns; 
					for_TTC_bp_dcm_rst    <= '0' after 1 ns; 
					for_eprom_wr    <= '0' after 1 ns;  
					for_eprom_rd    <= '1' after 1 ns;  
					for_lm82_wr    <= '0' after 1 ns;  
					for_lm82_rd    <= '0' after 1 ns;  
					for_monitor_wr    <= '0' after 1 ns;  
					for_monitor_rd    <= '0' after 1 ns;  
             		for_FED_ID    <= '0' after 1 ns;  
 
				when "0000100001101000" =>		-- 0x0868 lm82 write 	
					for_firm_ID     <= '0' after 1 ns;				
					for_clk_sel     <= '0' after 1 ns;	
					for_sw_reset    <= '0' after 1 ns;	
					for_stat_reg    <= '0' after 1 ns;  
					for_ttc_count   <= '0' after 1 ns;  
					for_bp_count    <= '0' after 1 ns; 
					for_TTC_bp_dcm_rst    <= '0' after 1 ns; 
					for_eprom_wr    <= '0' after 1 ns;  
					for_eprom_rd    <= '0' after 1 ns;  
					for_lm82_wr    <= '1' after 1 ns;  
					for_lm82_rd    <= '0' after 1 ns;  
					for_monitor_wr    <= '0' after 1 ns;  
					for_monitor_rd    <= '0' after 1 ns;  
             		for_FED_ID    <= '0' after 1 ns;  
 
				when "0000100001101100" =>		-- 0x086C lm82 read 	
					for_firm_ID     <= '0' after 1 ns;				
					for_clk_sel     <= '0' after 1 ns;	
					for_sw_reset    <= '0' after 1 ns;	
					for_stat_reg    <= '0' after 1 ns;  
					for_ttc_count   <= '0' after 1 ns;  
					for_bp_count    <= '0' after 1 ns; 
					for_TTC_bp_dcm_rst    <= '0' after 1 ns; 
					for_eprom_wr    <= '0' after 1 ns;  
					for_eprom_rd    <= '0' after 1 ns;  
					for_lm82_wr    <= '0' after 1 ns;  
					for_lm82_rd    <= '1' after 1 ns;  
					for_monitor_wr    <= '0' after 1 ns;  
					for_monitor_rd    <= '0' after 1 ns;  
             		for_FED_ID    <= '0' after 1 ns;  
 
				when "0000100001110000" =>		-- 0x0870 voltage monitor write 	
					for_firm_ID     <= '0' after 1 ns;				
					for_clk_sel     <= '0' after 1 ns;	
					for_sw_reset    <= '0' after 1 ns;	
					for_stat_reg    <= '0' after 1 ns;  
					for_ttc_count   <= '0' after 1 ns;  
					for_bp_count    <= '0' after 1 ns; 
					for_TTC_bp_dcm_rst    <= '0' after 1 ns; 
					for_eprom_wr    <= '0' after 1 ns;  
					for_eprom_rd    <= '0' after 1 ns;  
					for_lm82_wr    <= '0' after 1 ns;  
					for_lm82_rd    <= '0' after 1 ns;  
					for_monitor_wr    <= '1' after 1 ns;  
					for_monitor_rd    <= '0' after 1 ns;  
             		for_FED_ID    <= '0' after 1 ns;  
 
				when "0000100001110100" =>		-- 0x0874 voltage monitor read 	
					for_firm_ID     <= '0' after 1 ns;				
					for_clk_sel     <= '0' after 1 ns;	
					for_sw_reset    <= '0' after 1 ns;	
					for_stat_reg    <= '0' after 1 ns;  
					for_ttc_count   <= '0' after 1 ns;  
					for_bp_count    <= '0' after 1 ns; 
					for_TTC_bp_dcm_rst <= '0' after 1 ns; 
					for_eprom_wr    <= '0' after 1 ns;  
					for_eprom_rd    <= '0' after 1 ns;  
					for_lm82_wr    <= '0' after 1 ns;  
					for_lm82_rd    <= '0' after 1 ns;  
					for_monitor_wr    <= '0' after 1 ns;  
					for_monitor_rd    <= '1' after 1 ns;  
             		for_FED_ID    <= '0' after 1 ns;  
 
				when others =>
					for_firm_ID     <= '0' after 1 ns;		
					for_clk_sel     <= '0' after 1 ns;		
					for_sw_reset    <= '0' after 1 ns;	
					for_stat_reg    <= '0' after 1 ns;  
				   for_ttc_count   <= '0' after 1 ns;  
					for_bp_count    <= '0' after 1 ns; 
					for_TTC_bp_dcm_rst    <= '0' after 1 ns; 
					for_eprom_wr    <= '0' after 1 ns;  
					for_eprom_rd    <= '0' after 1 ns;  
					for_lm82_wr    <= '0' after 1 ns;  
					for_lm82_rd    <= '0' after 1 ns;  
					for_monitor_wr    <= '0' after 1 ns;  
					for_monitor_rd    <= '0' after 1 ns;  
             		for_FED_ID    <= '0' after 1 ns;  
		
				end case;
				
		else
			for_firm_ID     <= '0' after 1 ns;		
			for_clk_sel     <= '0' after 1 ns;		
			for_sw_reset    <= '0' after 1 ns;	
			for_stat_reg    <= '0' after 1 ns;  
			for_ttc_count   <= '0' after 1 ns;  
			for_bp_count    <= '0' after 1 ns;  
			for_TTC_bp_dcm_rst    <= '0' after 1 ns; 
			for_eprom_wr    <= '0' after 1 ns;  
			for_eprom_rd    <= '0' after 1 ns;  
			for_lm82_wr    <= '0' after 1 ns;  
			for_lm82_rd    <= '0' after 1 ns;  
			for_monitor_wr    <= '0' after 1 ns;  
			for_monitor_rd    <= '0' after 1 ns;  
       		for_FED_ID    <= '0' after 1 ns;  
		
	 	end if;
	end if;
end process;
END rtl;




