--
-- VHDL Architecture VME_blockram.address_decoder_32.rtl
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BANGLADESH)
--          at - 11:09:28 11/14/02
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds interface_start
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY address_decoder_32 IS
   PORT( 
      address_from_vme : IN     std_logic_vector (15 DOWNTO 0);
      clk              : IN     std_logic;
      data_latch       : IN     std_logic;
      rst              : IN     std_logic;
      en_length_reg    : OUT    std_logic;
      en_stat_reg      : OUT    std_logic;
      en_read_reg      : OUT    std_logic;
      en_ext_rd_lsb    : OUT    std_logic;
      en_ext_rd_msb    : OUT    std_logic
   );

-- Declarations

END address_decoder_32 ;


-- hds interface_end
ARCHITECTURE rtl OF address_decoder_32 IS
BEGIN
process(clk,rst)

begin
	if rst = '1' then
		en_length_reg 	<= '0';
		en_read_reg 	<= '0';
		en_stat_reg     <= '0';
		en_ext_rd_lsb     <= '0';
		en_ext_rd_msb     <= '0';
		
	elsif clk'event and clk = '1' then

		if data_latch = '1' then
			case address_from_vme is
				when "0000100000000000" =>    --$0800 write command serial
							en_length_reg <= '1';
							en_read_reg   <= '0';
							en_stat_reg   <= '0';
							en_ext_rd_lsb     <= '0';
							en_ext_rd_msb     <= '0';
				when "0000100000000100" =>      --$0804 read command serial
							en_length_reg <= '0';
							en_read_reg   <= '1';
							en_stat_reg   <= '0';
							en_ext_rd_lsb     <= '0';
							en_ext_rd_msb     <= '0';
				when "0000100000001100" =>      --$080C  status serial
							en_length_reg <= '0';
							en_read_reg   <= '0';
							en_stat_reg   <= '1';
							en_ext_rd_lsb     <= '0';
							en_ext_rd_msb     <= '0';
				when "0000100001010000" =>      --$0850 extended read LSM
							en_length_reg <= '0';
							en_read_reg   <= '0';
							en_stat_reg   <= '0';
							en_ext_rd_lsb     <= '1';
							en_ext_rd_msb     <= '0';
				when "0000100001010100" =>      --$0854 extended read MSB
							en_length_reg <= '0';
							en_read_reg   <= '0';
							en_stat_reg   <= '0';
							en_ext_rd_lsb     <= '0';
							en_ext_rd_msb     <= '1';
				when others =>
							en_length_reg <= '0';
							en_read_reg   <= '0';
							en_stat_reg   <= '0';
							en_ext_rd_lsb     <= '0';
							en_ext_rd_msb     <= '0';
						
				end case;
		else
			en_length_reg 	<= '0';
			en_read_reg 	<= '0';
			en_stat_reg     <= '0';
			en_ext_rd_lsb     <= '0';
			en_ext_rd_msb     <= '0';
	 	end if;
	end if;
end process;
END rtl;

