--
-- VHDL Architecture vme_slink.add_decode_vlink.rtl
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BANGLADESH)
--          at - 13:50:15 07/03/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.VITAL_Timing.all;
LIBRARY UNISIM;
USE UNISIM.VCOMPONENTS.all;

ENTITY add_decode_vlink IS
   PORT( 
      address_from_vme  : IN     std_logic_vector (15 DOWNTO 0);
      clk               : IN     std_logic;
      clk_80            : IN     std_logic;
      data_latch        : IN     std_logic;
      rst               : IN     std_logic;
      read_addrb        : OUT    std_logic;
      read_frame_count  : OUT    std_logic;
      read_frame_length : OUT    std_logic;
      read_run_data     : OUT    std_logic
   );

-- Declarations

END add_decode_vlink ;


ARCHITECTURE rtl OF add_decode_vlink IS
BEGIN
process(clk,rst)

begin
	if rst = '1' then
		read_addrb         <= '0';
		read_frame_count   <= '0';
		read_frame_length  <= '0';
      		read_run_data      <= '0';
		
	elsif clk'event and clk = '1' then

		if data_latch = '1' then
			case address_from_vme is
				when "0000100000100000" =>
				      
					read_addrb         <= '1';		
					read_frame_count   <= '0';		
					read_frame_length  <= '0';		
					read_run_data      <= '0';
					
				when "0000100000100100" => 	
					read_addrb         <= '0';	
					read_frame_count   <= '1';	
					read_frame_length  <= '0';	
					read_run_data      <= '0';
					
					
				when "0000100000101000" => 	
					read_addrb         <= '0';	
					read_frame_count   <= '0';	
					read_frame_length  <= '1';	
					read_run_data      <= '0';
					
					
				when "0000100000101100" => 	
					read_addrb         <= '0';	
					read_frame_count   <= '0';	
					read_frame_length  <= '0';	
					read_run_data      <= '1';				

					
					when others =>
					read_addrb         <= '0';		
					read_frame_count   <= '0';	
					read_frame_length  <= '0';
					read_run_data      <= '0';
				end case;
		else
			  
			read_addrb         <= '0';		
			read_frame_count   <= '0';	
			read_frame_length  <= '0';
			read_run_data      <= '0';
		
		
		
		
			
			
	 	end if;
	end if;
end process;
END rtl;

