--
-- VHDL Architecture vme_firmware.ace_rst_sr.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2MALDIVES)
--          at - 11:20:10 15/10/2004
--
-- using Mentor Graphics HDL Designer(TM) 2003.2 (Build 28)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.VITAL_Timing.all;
USE IEEE.VITAL_Primitives.all;

ENTITY ace_rst_sr IS
   PORT( 
      C   : IN     std_logic;
      CE  : IN     std_logic;
      CLR : IN     std_logic;
      D   : IN     std_logic;
      Q   : OUT    std_logic
   );

-- Declarations

END ace_rst_sr ;

--
ARCHITECTURE rtl OF ace_rst_sr IS

   
   signal a : std_logic;
   signal b : std_logic;
   signal e : std_logic;
   signal f : std_logic;
   signal g : std_logic;
   signal h : std_logic;
   
   BEGIN  
     process(C, CLR)
     begin
       if (CLR = '1') then
         Q   <= '0';
         a   <= '0';
         b   <= '0';
         e   <= '0';
         f   <= '0';
         g   <= '0';
         h   <= '0';
       elsif (rising_edge(C)) then
         if (CE = '1') then
           Q <= a after 100 ps;
           a <= b after 100 ps;
           b <= e after 100 ps;
           e <= f after 100 ps;
           f <= g after 100 ps;
           g <= h after 100 ps;
           h <= D after 100 ps;
         end if;
       end if;
     end process;
END rtl;

