--
-- VHDL Architecture vme_firmware.ace_registers.rtl_ace_reg
--
-- Created:
--          by - st79.UNKNOWN (TE2MALDIVES)
--          at - 14:55:04 01/28/04
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.VITAL_Timing.all;
USE IEEE.VITAL_Primitives.all;

ENTITY ace_registers IS
   PORT( 
      ace_data_en   : IN     std_logic;
      ace_reg_en    : IN     std_logic;
      addr_from_vme : IN     std_logic_VECTOR (6 DOWNTO 2);
      clk           : IN     std_logic;
      data_from_vme : IN     std_logic_VECTOR (15 DOWNTO 0);
      sw_hw_rst     : IN     std_logic;
      cf_mode_pin   : OUT    std_logic;
      cfg_addr      : OUT    std_logic_vector (2 DOWNTO 0);
      mp_addr_1     : OUT    std_logic_vector (6 DOWNTO 0);
      mp_data_1     : OUT    std_logic_vector (15 DOWNTO 0)
   );

-- Declarations

END ace_registers ;
ARCHITECTURE rtl_ace_reg OF ace_registers IS
BEGIN
process (clk, sw_hw_rst)
begin
	cf_mode_pin <= '1';		-- to make ACE start programming after power up reset
	if sw_hw_rst = '1' then
 		mp_addr_1 <= (others => '0');
 		mp_data_1 <= (others => '0');
		cf_mode_pin <= '1';		-- to make ACE start programming after power up reset
		cfg_addr <= "000";		-- set ACE configuration address to "000"
	elsif clk'event and clk = '1' then
		if ace_reg_en = '1' then		-- when ACE registers are addressed.
			 mp_addr_1 <= ('0' & addr_from_vme & '0') after 1 ns;
			 mp_data_1 <= data_from_vme after 1 ns;
		elsif ace_data_en = '1' then	-- when ACE data buffers are addressed
			 mp_addr_1 <= ('1' & addr_from_vme & '0') after 1 ns;
			 mp_data_1 <= data_from_vme after 1 ns;
		end if;
	end if;
end process;
END rtl_ace_reg;

