--
-- VHDL Architecture vme_firmware.ace_addr_decode.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2MALDIVES)
--          at - 10:33:28 01/28/04
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.VITAL_Timing.all;
USE IEEE.VITAL_Primitives.all;

ENTITY ace_reg_decoder IS
   PORT( 
      addr_from_vme     : IN     std_logic_VECTOR (15 DOWNTO 0);
      clk               : IN     std_logic;
      data_rdy_1        : IN     std_logic;
      sw_hw_rst         : IN     std_logic;
      en_bus_mode_reg   : OUT    std_logic;
      en_cfg_lbareg_lsb : OUT    std_logic;
      en_cfg_lbareg_msb : OUT    std_logic;
      en_cntl_reg_lsb   : OUT    std_logic;
      en_cntl_reg_msb   : OUT    std_logic;
      en_error_reg_lsb  : OUT    std_logic;
      en_error_reg_msb  : OUT    std_logic;
      en_fatstat_reg    : OUT    std_logic;
      en_mpu_lbareg_lsb : OUT    std_logic;
      en_mpu_lbareg_msb : OUT    std_logic;
      en_seccntcmd_reg  : OUT    std_logic;
      en_status_reg_lsb : OUT    std_logic;
      en_status_reg_msb : OUT    std_logic;
      en_version_reg    : OUT    std_logic
   );

-- Declarations

END ace_reg_decoder ;
ARCHITECTURE decode_single_reg OF ace_reg_decoder IS
BEGIN

process(clk, sw_hw_rst)

begin
	if sw_hw_rst = '1' then
		en_bus_mode_reg 	<= '0' after 1 ns;
		en_status_reg_lsb     <= '0' after 1 ns;
		en_status_reg_msb     <= '0' after 1 ns;
		en_error_reg_lsb     <= '0' after 1 ns;
		en_error_reg_msb     <= '0' after 1 ns;
		en_cfg_lbareg_lsb 	<= '0' after 1 ns;
		en_cfg_lbareg_msb     <= '0' after 1 ns;
		en_mpu_lbareg_lsb 	<= '0' after 1 ns;
		en_mpu_lbareg_msb     <= '0' after 1 ns;
		en_seccntcmd_reg     <= '0' after 1 ns;
		en_version_reg     <= '0' after 1 ns;
		en_cntl_reg_lsb     <= '0' after 1 ns;
		en_cntl_reg_msb     <= '0' after 1 ns;
		en_fatstat_reg     <= '0' after 1 ns;

	elsif clk'event and clk = '1' then
		if data_rdy_1 = '1' then
			case addr_from_vme is

				when "0000100100000000" =>    -- $0900
					en_bus_mode_reg 	<= '1' after 1 ns;
					en_status_reg_lsb     <= '0' after 1 ns;
					en_status_reg_msb     <= '0' after 1 ns;
					en_error_reg_lsb     <= '0' after 1 ns;
					en_error_reg_msb     <= '0' after 1 ns;
					en_cfg_lbareg_lsb 	<= '0' after 1 ns;
					en_cfg_lbareg_msb     <= '0' after 1 ns;
					en_mpu_lbareg_lsb 	<= '0' after 1 ns;
					en_mpu_lbareg_msb     <= '0' after 1 ns;
					en_seccntcmd_reg     <= '0' after 1 ns;
					en_version_reg     <= '0' after 1 ns;
					en_cntl_reg_lsb     <= '0' after 1 ns;
					en_cntl_reg_msb     <= '0' after 1 ns;
					en_fatstat_reg     <= '0' after 1 ns;

				when "0000100100000010" =>    -- $0902
					en_bus_mode_reg 	<= '0' after 1 ns;
					en_status_reg_lsb     <= '1' after 1 ns;
					en_status_reg_msb     <= '0' after 1 ns;
					en_error_reg_lsb     <= '0' after 1 ns;
					en_error_reg_msb     <= '0' after 1 ns;
					en_cfg_lbareg_lsb 	<= '0' after 1 ns;
					en_cfg_lbareg_msb     <= '0' after 1 ns;
					en_mpu_lbareg_lsb 	<= '0' after 1 ns;
					en_mpu_lbareg_msb     <= '0' after 1 ns;
					en_seccntcmd_reg     <= '0' after 1 ns;
					en_version_reg     <= '0' after 1 ns;
					en_cntl_reg_lsb     <= '0' after 1 ns;
					en_cntl_reg_msb     <= '0' after 1 ns;
					en_fatstat_reg     <= '0' after 1 ns;

				when "0000100100000011" =>    -- $0903
					en_bus_mode_reg 	<= '0' after 1 ns;
					en_status_reg_lsb     <= '0' after 1 ns;
					en_status_reg_msb     <= '1' after 1 ns;
					en_error_reg_lsb     <= '0' after 1 ns;
					en_error_reg_msb     <= '0' after 1 ns;
					en_cfg_lbareg_lsb 	<= '0' after 1 ns;
					en_cfg_lbareg_msb     <= '0' after 1 ns;
					en_mpu_lbareg_lsb 	<= '0' after 1 ns;
					en_mpu_lbareg_msb     <= '0' after 1 ns;
					en_seccntcmd_reg     <= '0' after 1 ns;
					en_version_reg     <= '0' after 1 ns;
					en_cntl_reg_lsb     <= '0' after 1 ns;
					en_cntl_reg_msb     <= '0' after 1 ns;
					en_fatstat_reg     <= '0' after 1 ns;

				when "0000100100000100" =>    -- $0904
					en_bus_mode_reg 	<= '0' after 1 ns;
					en_status_reg_lsb     <= '0' after 1 ns;
					en_status_reg_msb     <= '0' after 1 ns;
					en_error_reg_lsb     <= '1' after 1 ns;
					en_error_reg_msb     <= '0' after 1 ns;
					en_cfg_lbareg_lsb 	<= '0' after 1 ns;
					en_cfg_lbareg_msb     <= '0' after 1 ns;
					en_mpu_lbareg_lsb 	<= '0' after 1 ns;
					en_mpu_lbareg_msb     <= '0' after 1 ns;
					en_seccntcmd_reg     <= '0' after 1 ns;
					en_version_reg     <= '0' after 1 ns;
					en_cntl_reg_lsb     <= '0' after 1 ns;
					en_cntl_reg_msb     <= '0' after 1 ns;
					en_fatstat_reg     <= '0' after 1 ns;

				when "0000100100000101" =>    -- $0905
					en_bus_mode_reg 	<= '0' after 1 ns;
					en_status_reg_lsb     <= '0' after 1 ns;
					en_status_reg_msb     <= '0' after 1 ns;
					en_error_reg_lsb     <= '0' after 1 ns;
					en_error_reg_msb     <= '1' after 1 ns;
					en_cfg_lbareg_lsb 	<= '0' after 1 ns;
					en_cfg_lbareg_msb     <= '0' after 1 ns;
					en_mpu_lbareg_lsb 	<= '0' after 1 ns;
					en_mpu_lbareg_msb     <= '0' after 1 ns;
					en_seccntcmd_reg     <= '0' after 1 ns;
					en_version_reg     <= '0' after 1 ns;
					en_cntl_reg_lsb     <= '0' after 1 ns;
					en_cntl_reg_msb     <= '0' after 1 ns;
					en_fatstat_reg     <= '0' after 1 ns;

				when "0000100100000110" =>    -- $0906
					en_bus_mode_reg 	<= '0' after 1 ns;
					en_status_reg_lsb     <= '0' after 1 ns;
					en_status_reg_msb     <= '0' after 1 ns;
					en_error_reg_lsb     <= '0' after 1 ns;
					en_error_reg_msb     <= '0' after 1 ns;
					en_cfg_lbareg_lsb 	<= '1' after 1 ns;
					en_cfg_lbareg_msb     <= '0' after 1 ns;
					en_mpu_lbareg_lsb 	<= '0' after 1 ns;
					en_mpu_lbareg_msb     <= '0' after 1 ns;
					en_seccntcmd_reg     <= '0' after 1 ns;
					en_version_reg     <= '0' after 1 ns;
					en_cntl_reg_lsb     <= '0' after 1 ns;
					en_cntl_reg_msb     <= '0' after 1 ns;
					en_fatstat_reg     <= '0' after 1 ns;

				when "0000100100000111" =>    -- $0907
					en_bus_mode_reg 	<= '0' after 1 ns;
					en_status_reg_lsb     <= '0' after 1 ns;
					en_status_reg_msb     <= '0' after 1 ns;
					en_error_reg_lsb     <= '0' after 1 ns;
					en_error_reg_msb     <= '0' after 1 ns;
					en_cfg_lbareg_lsb 	<= '0' after 1 ns;
					en_cfg_lbareg_msb     <= '1' after 1 ns;
					en_mpu_lbareg_lsb 	<= '0' after 1 ns;
					en_mpu_lbareg_msb     <= '0' after 1 ns;
					en_seccntcmd_reg     <= '0' after 1 ns;
					en_version_reg     <= '0' after 1 ns;
					en_cntl_reg_lsb     <= '0' after 1 ns;
					en_cntl_reg_msb     <= '0' after 1 ns;
					en_fatstat_reg     <= '0' after 1 ns;

				when "0000100100001000" =>    -- $0908
					en_bus_mode_reg 	<= '0' after 1 ns;
					en_status_reg_lsb     <= '0' after 1 ns;
					en_status_reg_msb     <= '0' after 1 ns;
					en_error_reg_lsb     <= '0' after 1 ns;
					en_error_reg_msb     <= '0' after 1 ns;
					en_cfg_lbareg_lsb 	<= '0' after 1 ns;
					en_cfg_lbareg_msb     <= '0' after 1 ns;
					en_mpu_lbareg_lsb 	<= '1' after 1 ns;
					en_mpu_lbareg_msb     <= '0' after 1 ns;
					en_seccntcmd_reg     <= '0' after 1 ns;
					en_version_reg     <= '0' after 1 ns;
					en_cntl_reg_lsb     <= '0' after 1 ns;
					en_cntl_reg_msb     <= '0' after 1 ns;
					en_fatstat_reg     <= '0' after 1 ns;

				when "0000100100001001" =>    -- $0909
					en_bus_mode_reg 	<= '0' after 1 ns;
					en_status_reg_lsb     <= '0' after 1 ns;
					en_status_reg_msb     <= '0' after 1 ns;
					en_error_reg_lsb     <= '0' after 1 ns;
					en_error_reg_msb     <= '0' after 1 ns;
					en_cfg_lbareg_lsb 	<= '0' after 1 ns;
					en_cfg_lbareg_msb     <= '0' after 1 ns;
					en_mpu_lbareg_lsb 	<= '0' after 1 ns;
					en_mpu_lbareg_msb     <= '1' after 1 ns;
					en_seccntcmd_reg     <= '0' after 1 ns;
					en_version_reg     <= '0' after 1 ns;
					en_cntl_reg_lsb     <= '0' after 1 ns;
					en_cntl_reg_msb     <= '0' after 1 ns;
					en_fatstat_reg     <= '0' after 1 ns;

				when "0000100100001010" =>    -- $090A
					en_bus_mode_reg 	<= '0' after 1 ns;
					en_status_reg_lsb     <= '0' after 1 ns;
					en_status_reg_msb     <= '0' after 1 ns;
					en_error_reg_lsb     <= '0' after 1 ns;
					en_error_reg_msb     <= '0' after 1 ns;
					en_cfg_lbareg_lsb 	<= '0' after 1 ns;
					en_cfg_lbareg_msb     <= '0' after 1 ns;
					en_mpu_lbareg_lsb 	<= '0' after 1 ns;
					en_mpu_lbareg_msb     <= '0' after 1 ns;
					en_seccntcmd_reg     <= '1' after 1 ns;
					en_version_reg     <= '0' after 1 ns;
					en_cntl_reg_lsb     <= '0' after 1 ns;
					en_cntl_reg_msb     <= '0' after 1 ns;
					en_fatstat_reg     <= '0' after 1 ns;

				when "0000100100001011" =>    -- $090B
					en_bus_mode_reg 	<= '0' after 1 ns;
					en_status_reg_lsb     <= '0' after 1 ns;
					en_status_reg_msb     <= '0' after 1 ns;
					en_error_reg_lsb     <= '0' after 1 ns;
					en_error_reg_msb     <= '0' after 1 ns;
					en_cfg_lbareg_lsb 	<= '0' after 1 ns;
					en_cfg_lbareg_msb     <= '0' after 1 ns;
					en_mpu_lbareg_lsb 	<= '0' after 1 ns;
					en_mpu_lbareg_msb     <= '0' after 1 ns;
					en_seccntcmd_reg     <= '0' after 1 ns;
					en_version_reg     <= '1' after 1 ns;
					en_cntl_reg_lsb     <= '0' after 1 ns;
					en_cntl_reg_msb     <= '0' after 1 ns;
					en_fatstat_reg     <= '0' after 1 ns;

				when "0000100100001100" =>    -- $090C
					en_bus_mode_reg 	<= '0' after 1 ns;
					en_status_reg_lsb     <= '0' after 1 ns;
					en_status_reg_msb     <= '0' after 1 ns;
					en_error_reg_lsb     <= '0' after 1 ns;
					en_error_reg_msb     <= '0' after 1 ns;
					en_cfg_lbareg_lsb 	<= '0' after 1 ns;
					en_cfg_lbareg_msb     <= '0' after 1 ns;
					en_mpu_lbareg_lsb 	<= '0' after 1 ns;
					en_mpu_lbareg_msb     <= '0' after 1 ns;
					en_seccntcmd_reg     <= '0' after 1 ns;
					en_version_reg     <= '0' after 1 ns;
					en_cntl_reg_lsb     <= '1' after 1 ns;
					en_cntl_reg_msb     <= '0' after 1 ns;
					en_fatstat_reg     <= '0' after 1 ns;

				when "0000100100001101" =>    -- $090D
					en_bus_mode_reg 	<= '0' after 1 ns;
					en_status_reg_lsb     <= '0' after 1 ns;
					en_status_reg_msb     <= '0' after 1 ns;
					en_error_reg_lsb     <= '0' after 1 ns;
					en_error_reg_msb     <= '0' after 1 ns;
					en_cfg_lbareg_lsb 	<= '0' after 1 ns;
					en_cfg_lbareg_msb     <= '0' after 1 ns;
					en_mpu_lbareg_lsb 	<= '0' after 1 ns;
					en_mpu_lbareg_msb     <= '0' after 1 ns;
					en_seccntcmd_reg     <= '0' after 1 ns;
					en_version_reg     <= '0' after 1 ns;
					en_cntl_reg_lsb     <= '0' after 1 ns;
					en_cntl_reg_msb     <= '1' after 1 ns;
					en_fatstat_reg     <= '0' after 1 ns;

				when "0000100100001110" =>    -- $090E
					en_bus_mode_reg 	<= '0' after 1 ns;
					en_status_reg_lsb     <= '0' after 1 ns;
					en_status_reg_msb     <= '0' after 1 ns;
					en_error_reg_lsb     <= '0' after 1 ns;
					en_error_reg_msb     <= '0' after 1 ns;
					en_cfg_lbareg_lsb 	<= '0' after 1 ns;
					en_cfg_lbareg_msb     <= '0' after 1 ns;
					en_mpu_lbareg_lsb 	<= '0' after 1 ns;
					en_mpu_lbareg_msb     <= '0' after 1 ns;
					en_seccntcmd_reg     <= '0' after 1 ns;
					en_version_reg     <= '0' after 1 ns;
					en_cntl_reg_lsb     <= '0' after 1 ns;
					en_cntl_reg_msb     <= '0' after 1 ns;
					en_fatstat_reg     <= '1' after 1 ns;

				when others =>
					en_bus_mode_reg 	<= '0' after 1 ns;
					en_status_reg_lsb     <= '0' after 1 ns;
					en_status_reg_msb     <= '0' after 1 ns;
					en_error_reg_lsb     <= '0' after 1 ns;
					en_error_reg_msb     <= '0' after 1 ns;
					en_cfg_lbareg_lsb 	<= '0' after 1 ns;
					en_cfg_lbareg_msb     <= '0' after 1 ns;
					en_mpu_lbareg_lsb 	<= '0' after 1 ns;
					en_mpu_lbareg_msb     <= '0' after 1 ns;
					en_seccntcmd_reg     <= '0' after 1 ns;
					en_version_reg     <= '0' after 1 ns;
					en_cntl_reg_lsb     <= '0' after 1 ns;
					en_cntl_reg_msb     <= '0' after 1 ns;
					en_fatstat_reg     <= '0' after 1 ns;
				end case;
			else
				en_bus_mode_reg 	<= '0' after 1 ns;
				en_status_reg_lsb     <= '0' after 1 ns;
				en_status_reg_msb     <= '0' after 1 ns;
				en_error_reg_lsb     <= '0' after 1 ns;
				en_error_reg_msb     <= '0' after 1 ns;
				en_cfg_lbareg_lsb 	<= '0' after 1 ns;
				en_cfg_lbareg_msb     <= '0' after 1 ns;
				en_mpu_lbareg_lsb 	<= '0' after 1 ns;
				en_mpu_lbareg_msb     <= '0' after 1 ns;
				en_seccntcmd_reg     <= '0' after 1 ns;
				en_version_reg     <= '0' after 1 ns;
				en_cntl_reg_lsb     <= '0' after 1 ns;
				en_cntl_reg_msb     <= '0' after 1 ns;
				en_fatstat_reg     <= '0' after 1 ns;
			end if; 
		end if;
end process;
END decode_single_reg;

