--
-- VHDL Architecture vme_firmware.ace_data_decoder.data_en_short
--
-- Created:
--          by - st79.UNKNOWN (TE2MALDIVES)
--          at - 08:32:20 02/18/04
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds interface_start
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY ace_data_decoder IS
   PORT( 
      addr_from_vme : IN     std_logic_VECTOR (15 DOWNTO 7);
      clk           : IN     std_logic;
      data_ready    : IN     std_logic;
      sw_hw_rst     : IN     std_logic;
      ace_data_en   : OUT    std_logic
   );

-- Declarations

END ace_data_decoder ;


-- hds interface_end
ARCHITECTURE data_en_short OF ace_data_decoder IS
BEGIN
process(clk, sw_hw_rst)

begin
	if sw_hw_rst = '1' then
		ace_data_en <= '0';

	elsif clk'event and clk = '1' then

		if data_ready = '1' then		-- data ready signal
			if addr_from_vme = "000010010" then		-- addr = $0900 to $097F : ACE data buffers
				ace_data_en <= '1' after 1 ns;
			else
				ace_data_en <= '0' after 1 ns;
			end if;
		else
			ace_data_en <= '0' after 1 ns;
	 	end if;
	end if;
end process;

END data_en_short;

