--
-- VHDL Architecture vme_firmware.ace_cntl_decoder.cntl_en_short
--
-- Created:
--          by - st79.UNKNOWN (TE2MALDIVES)
--          at - 08:33:40 02/18/04
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds interface_start
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY ace_cntl_decoder IS
   PORT( 
      addr_from_vme : IN     std_logic_VECTOR (15 DOWNTO 7);
      clk           : IN     std_logic;
      data_ready    : IN     std_logic;
      sw_hw_rst     : IN     std_logic;
      ace_reg_en    : OUT    std_logic
   );

-- Declarations

END ace_cntl_decoder ;


-- hds interface_end
ARCHITECTURE cntl_en_short OF ace_cntl_decoder IS
BEGIN
process(clk, sw_hw_rst)

begin
	if sw_hw_rst = '1' then
		ace_reg_en <= '0';
	elsif clk'event and clk = '1' then
		if data_ready = '1' then		-- data ready signal
			if addr_from_vme = "000010001" then		-- addr = $0880 to $08FF : ACE cntl/status registers
				ace_reg_en <= '1' after 1 ns;
			else
				ace_reg_en <= '0' after 1 ns;
			end if;
		else
			ace_reg_en <= '0' after 1 ns;
	 	end if;
	end if;
end process;


END cntl_en_short;

