--
-- VHDL Architecture vme_firmware.ace_decoder.rtl_ace_decoder
--
-- Created:
--          by - st79.UNKNOWN (TE2MALDIVES)
--          at - 14:22:05 01/28/04
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.VITAL_Timing.all;
USE IEEE.VITAL_Primitives.all;

ENTITY ace_cntl_decoder IS
   PORT( 
      addr_from_vme : IN     std_logic_VECTOR (15 DOWNTO 7);
      clk           : IN     std_logic;
      data_rdy_1    : IN     std_logic;
      sw_hw_rst     : IN     std_logic;
      ace_reg_en    : OUT    std_logic
   );

-- Declarations

END ace_cntl_decoder ;
ARCHITECTURE cntl_en_long OF ace_cntl_decoder IS

signal tmp1 : std_logic;
signal tmp2 : std_logic;

BEGIN

process(clk, sw_hw_rst)

begin
	if sw_hw_rst = '1' then
		ace_reg_en <= '0';
		tmp1 <= '0';
		tmp2 <= '0';
	elsif clk'event and clk = '1' then
		tmp2 <= tmp1 after 1 ns;
		ace_reg_en <= tmp2 OR tmp1 after 1 ns; -- this makes output signal 2 clock cycles wide
		if data_rdy_1 = '1' then		-- data ready signal
			if addr_from_vme = "000010001" then		-- addr = $0880 to $08FF : ACE cntl/status registers
				tmp1 <= '1' after 1 ns;
			else
				tmp1 <= '0' after 1 ns;
			end if;
		else
			tmp1 <= '0' after 1 ns;
	 	end if;
	end if;
end process;
END cntl_en_long;

