#include <iostream>
#include "FFv1Object.hh"
using namespace std;
int getBaseAddress(unsigned long *);

int opto_data;
int scope_len;
unsigned int readback_data;
int fe_id = 1;
int fe_chan = 1;
int dac_offset = 64;
// dac chan 1 feeds fe chan 12 !
int dac_chan_map[12] = { 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1 };
unsigned int pattern;
int temp;
int delay_chip;
int coarse, fine;
int lm82_data;
unsigned int threshold;
int be_cmd, be_rw;
unsigned int be_data;
int fe_cmd, fe_rw;
unsigned int fe_data;
int fe_id_tmp;
int clock_select;
int trigger_select;


FILE *output_file;

	time_t now;
	struct tm *date;
	char start_date_str[40];
	char stop_date_str[40];

// hacked by jac 01.05.2003

int main(void)
{
  const unsigned long memLength=0x40;

  cout << "Clunky Software presents..." << '\n';

  unsigned long baseAddress=0;
  if(getBaseAddress(&baseAddress))
   {
     cout<<"base address not found"<<endl;
     return -1;
   }
  string addressTableLocation="/home/xdaq/TriDAS/daq/fed_debug/src/linux/x86/FFv1AddressTable.dat";

  FFv1Object * ffv1Debug= new FFv1Object(baseAddress,addressTableLocation);
  string ffv1AddressItem="FFv1BaseItemSingleDataNonPriv";

  cout<<"fed base address: 0x"<<hex<<baseAddress<<endl;

//    {
//      unsigned long  mydata = 0;
//      unsigned long offset = 0;
//          int retVal=ffv1Debug->ffv1SingleRead(&mydata, offset);
//          if(retVal)
//    	cout<<"ffv1SingleRead() reported an error"<<endl;
//          cout<<"data from memory location [0] = "<<mydata<<endl;
//    }
//  	return 0;

  // output file

//    char file_name_str[60] = "fed9u_";
//  	{		
//  		/* Convert it to a broken-down time.	*/
//  		time( &now );
//  		date = localtime( &now );

//  		/* Convert that to a string.		*/
//  		/* strftime( start_date_str, 40, "%a_%d_%b_%Y_%H%M%S", date ); */
//  		strftime( start_date_str, 40, "%Y_%m_%d_%H%M%S", date );

//  		printf( "Run Start time : %s\n", start_date_str );
//         		printf( "\n" );
//  	}
	
//  	/* output file */
//  	strcat( file_name_str, start_date_str );

//  	printf( "Output file_name_str = \"%s\"\n", file_name_str );

//  	output_file = fopen( file_name_str, "w" );

//  	if ( output_file == NULL )
//  	{
//  		printf( "*** ERROR => Couldn't open output file name = %s\n", file_name_str );
//  		return -1;
//  	}
//  	else
//  	{
//  		printf( "INFO => Output file opened with pointer = %p\n", output_file );
//  	}

//  	fprintf(output_file, "Test output file \n");


  for (;;) {

  int choice = ffv1Debug->userPrompt();

   switch (choice) {
      case 'a' :
	cout << "Please enter OptoRx control bits (Hex X7:X0): ";
	cin >> hex >> opto_data;
	ffv1Debug->SetOptoRx(fe_id, opto_data);
	break;
   case 'b' :
     ffv1Debug->SetRunMode(fe_id, 1); // scope
     break;
   case 'c' :
	cout << "Set Clock Skews : ";
	cout << "Please enter Delay Chip (0-2) or 3 for ALL: ";
	cin >> dec >> delay_chip;
	cout << "Please enter Coarse delay (0-15): ";
	cin >> dec >> coarse;
	cout << "Please enter Fine delay (0-31): ";
	cin >> dec >> fine;
	ffv1Debug->SetClockSkew(fe_id, delay_chip, 0, coarse, fine);
	break;
      case 'd' :
	cout << "Please enter Scope Mode length (dec): ";
	cin >> dec >> scope_len;
	ffv1Debug->SetScopeLength(fe_id, scope_len);
	break;
   case 'e' :
     ffv1Debug->SetRunMode(fe_id, 2); // frame finding
     break;
      case 'f' :
	cout << "Please enter Frame Finding Threshold (same for ALL 12 fibres) (0-31) {x32 steps}: ";
	cin >> dec >> threshold;
	ffv1Debug->SetFrameThresholds(fe_id, threshold);
	break;
    case 'g' :
      ffv1Debug->EnableAPVChans(fe_id, 0); // Enable ALL 24 channels (data passed is ignored for now)
      break;
   case 'h' :
     cout << "BE FPGA; Please enter command code (dec): ";
     cin >> dec >> be_cmd;
     cout << "Enter 0 for Write or 1 for Read: ";
     cin >> dec >> be_rw;
     if (be_rw == 0)
       {
	 cout << "Writing: Please enter data (hex): ";
	 cin >> hex >> be_data;
       }

     ffv1Debug->BECommand(be_cmd, be_rw, &be_data, 2);
     break;
    case 'i' :
      {
	int run_type = 0;
//  	char *run_type_str[2] = {"Scope Mode", "Frame Finding Mode"};

      // set up all fpga settings in one go...

	cout << "Please enter Run Type" << '\n';
	cout << "(1 = Scope Mode ; 2 = Frame Mode/VIRGIN RAW ; 3 = Frame Mode/ZERO SUPPRESSED): ";
	cin >> dec >> run_type;
       
     cout << "Please Enter Clock Source (1=Oscillator ; 2=TTC ; 4=BackPlane) :";
     cin >> dec >> clock_select;
     // this also resets FED so must be first operation
     ffv1Debug->SelectClock(clock_select, 2);
 
     cout << "Please Enter Trigger Source (1=TTC ; 2=BackPlane ; 4=Software) :";
     cin >> dec >> trigger_select;

	if (run_type == 1)
	  {
	    cout << "Setting up FED for a Scope Run: ";

	// for scope mode...  // 8 x FE FPGA
	fe_id_tmp = fe_id;
	fe_id = 15; // broadcast
	ffv1Debug->SetRunMode(fe_id, run_type); // set all fe to scope mode
	cout << "Please enter Scope Mode length for all FE's (dec): ";
	cin >> dec >> scope_len;
	ffv1Debug->SetScopeLength(fe_id, scope_len);
	fe_id = fe_id_tmp; // restore current setting

	  }
	else if (run_type == 2)
	  {
	    cout << "Setting up FED for a Frame Finding Run (with RAW Data): " << '\n';

//      ffv1Debug->SetAD8802(fe_id, 0x0f); // DAC Reset
//  	cout << "DAC was reset:" << '\n';
//  	cout << "Please enter new DAC offset value for ALL 12 fibres = (dec 0-255):";
//  	cin >> dec >> dac_offset;
//      ffv1Debug->SetDAC(fe_id, i, dac_offset);

	// for frame finding mode...  // 8 x FE FPGA
	fe_id_tmp = fe_id;
	fe_id = 15; // broadcast
	ffv1Debug->SetRunMode(fe_id, run_type); // set all fe to frame finding mode
	fe_id = fe_id_tmp; // restore current setting

	  }
	else if (run_type == 3)
	  {
	    cout << "Setting up FED for a Frame Finding Run (with ZERO Suppressed Data): " << '\n';

	// for frame finding mode...  // 8 x FE FPGA
	fe_id_tmp = fe_id;
	fe_id = 15; // broadcast
	ffv1Debug->SetRunMode(fe_id, run_type); // set all fe to frame finding mode
	fe_id = fe_id_tmp; // restore current setting
  }
	else
	  {
	    cout << "Sorry Illegal Run Type: ";
	    break;
	  }

	if (run_type == 2 || run_type ==3) {
  	
//      ffv1Debug->EnableAPVChans(fe_id, 0); // Enable ALL 24 channels (data passed is ignored for now)
//  	cout << "All 24 APV channels are now enabled:" << '\n';

        cout << "Please enter Frame Finding Threshold for all 96 channels (0-31) {x32 steps}: " << '\n';
  	cin >> dec >> threshold;
  	ffv1Debug->SetFrameThresholds(15, threshold);
	}

  	ffv1Debug->SetOptoRx(15, 0x05);
        cout << "Setting all 96 channels OptoRX offset = 0x05 " << '\n';

        ffv1Debug->SetClockSkew(15, 3, 0, 0, 0);
	cout << "Setting all 96 channels Clock skews coarse = 0 ; fine = 0" << '\n';

	// reset trimDACs
	unsigned int dac_reset = 0x2000;
	ffv1Debug->FECommand(15, 6, 0, &dac_reset, 2);
         cout << "Resetting all 96 channels TrimDACs" << '\n';

	printf("Setting up BE FPGA.. \n");
	ffv1Debug->InitBE(run_type, trigger_select); // BE FPGA

      }
      break;
   case 'j':
     ffv1Debug->DisplayBEStatus(1);
     break;
     case 'k' :
       {
	 int num_triggers = 0;
	 int num_microsecs = 0;

       cout << "Test Frame Finding " << '\n';

	cout << "Nr Triggers to send (dec):";
	cin >> dec >> num_triggers;
	cout << "Nr Microsecs to send APV Frames (dec):";
	cin >> dec >> num_microsecs;

       ffv1Debug->TestFrameFinding(num_triggers, num_microsecs);
       }

//  	cout << "Set FE LM82 signal lines: ";
//  	cin >> hex >> lm82_data;
//  	ffv1Debug->SetLM82(fe_id, lm82_data);

	break;
   case 'l':
     ffv1Debug->ReadLM82(fe_id, &readback_data);
     cout << "Chip id = " << fe_id << " LM82 signals $ = " << hex << readback_data << '\n';
     break;
   case 'm':
     ffv1Debug->ReadOptoRx(fe_id, &readback_data);
     cout << "Chip id = " << fe_id << " OptoRx control bits (Hex X7:0) = " << hex << readback_data << '\n';
     break;
   case 'n':
     ffv1Debug->ReadScopeLength(fe_id, &readback_data);
     cout << "Chip id = " << fe_id << " Scope length  = " << dec << readback_data << '\n';
     break;
   case 'o':
     // ffv1Debug->SetLM82(fe_id, 3);
     // ffv1Debug->ReadLM82(fe_id, &readback_data);
     //cout << "Chip id = " << fe_id << " LM82 reg  = " << dec << readback_data << '\n';
     //  ffv1Debug->ReadTemp(fe_id, &temp);
     //  cout << "Chip id = " << fe_id << " Local Temp  = " << dec << temp << " degrees C" << '\n';

     fe_id_tmp = fe_id;
     cout << "FE FPGA; Please enter FPGA nr (1-8, 15 for all): ";
     cin >> dec >> fe_id;
     cout << "FE FPGA; Please enter command code (dec): ";
     cin >> dec >> fe_cmd;
     cout << "Enter 0 for Write or 1 for Read: ";
     cin >> dec >> fe_rw;
     if (fe_rw == 0)
       {
	 cout << "Writing: Please enter data (hex): ";
	 cin >> hex >> fe_data;
       }

     ffv1Debug->FECommand(fe_id, fe_cmd, fe_rw, &fe_data, 2);
     fe_id = fe_id_tmp; // restore current setting
     break;
   case 'p':
     	cout << "FE channel = (1-12) (0 for ALL ; 13 for Reset/ignores value) :";
	cin >> dec >> fe_chan;
	cout << "DAC offset value = (dec 0-255):";
	cin >> dec >> dac_offset;
	if (fe_chan == 0)
	  {
	  for (int i=1; i<=12; i++)
	    ffv1Debug->SetDAC(fe_id, i, dac_offset);
	  }
	else if (fe_chan == 13)
	  {
	  ffv1Debug->SetAD8802(fe_id, 0x0f); // Reset
	  cout << "Reset AD8802" << '\n';
	  ffv1Debug->SetAD8802(fe_id, 0x1f); // release Reset!
	  }
	else if (fe_chan <= 12)
	  {
	  ffv1Debug->SetDAC(fe_id, fe_chan, dac_offset);
	  }
	else
	  cout << "Sorry Illegal channel number" << '\n';

     break;
   case 'q':
     ffv1Debug->ReadAD8802(fe_id, &readback_data);
     cout << "Chip id = " << fe_id << " AD8802 signals $ = " << hex << readback_data << '\n';
     break;

   case 't' :
     ffv1Debug->SendSWTrig();
     // clear readout csr to allow next trigger
     usleep(10000); // wait for vme buffer to fill with event
     ffv1Debug->ClearReadoutCSR(2);
     break;
   case 'v':
     cout << "Please enter Pattern to fill VME Memory (Hex 0-fffffff): ";
     cin >> hex >> pattern;
     ffv1Debug->FillVMEMem(pattern);
     break;
   case 'u':
     cout << "Show VME Buffer...." << '\n';
     ffv1Debug->DumpVMEMem();
     break;
   case 'w':
     cout << "Please enter FE FPGA id (1-8 ; 15 for Broadcast): ";
     cin >> dec >> fe_id;
     break;
   case 'x' :
     return 0;
     break;
   case 'y' :
     ffv1Debug->DisplayVMEStatus(2);
     break;
   case 'z' :
     ffv1Debug->TestReadout(2);
     break;
   case '1' :
     ffv1Debug->ResetFED(2);
     break;
   case '2' :
     cout << "Please Enter New Clock Selection (1=Osc ; 2=TTC ; 4=BkPlane) :";
     cin >> dec >> clock_select;
     ffv1Debug->SelectClock(clock_select, 2);
     break;
   case '3' :
     // just s/w trigger, without clear of readout csr
     ffv1Debug->SendSWTrig();
     break;
   case '4' :
     // clear of readout csr
     ffv1Debug->ClearReadoutCSR(2);
     break;
   case '5' :
     // ramp trimdac values on chan 1 for scope capture
     	cout << "Ramp Trimdac on FE channel = (1-12) :";
	cin >> dec >> fe_chan;
     for (int i=0; i<=255; i+=10)
	  ffv1Debug->SetDAC(fe_id, fe_chan, i);
     break;
   case '6' :
     ffv1Debug->DisplayClockCounters(2);
     break;
      default:
	cout << "Sorry didn't recognise that choice. Try again. " << '\n';
	break;
      }
  }

  return 0; 


//    {
//      unsigned long  mydata = 0;
//      unsigned long offset = 0;
//          int retVal=ffv1Debug->ffv1SingleRead(&mydata, offset);
//          if(retVal)
//    	cout<<"ffv1SingleRead() reported an error"<<endl;
//          cout<<"data from memory location [0] = "<<mydata<<endl;
//    }
//  	return 0;


  //initial testing routines. 

//    if(ffv1Debug->preliminaryTest(ffv1AddressItem))
//      cout<<"error reported by preliminaryTest()"<<endl; 

//    if(ffv1Debug->writeBlockMemTest())
//      cout<<"error reported by writeBlockMemTest()"<<endl; 
   
//    if(ffv1Debug->readBlockMemTest())
//      cout<<"error reported by readBlockMemTest()"<<endl; 


   unsigned long dataFromFFv1[memLength]={0};
//    if(ffv1Debug->ffv1BlockRead(dataFromFFv1, memLength))
//      cout<<"error reported by ffv1BlockRead()"<<endl; 

  unsigned long dataToFFv1[memLength]={0};
  for(unsigned long i=0; i<memLength; i++)
    dataToFFv1[i]=rand();

  if(ffv1Debug->ffv1BlockWrite(dataToFFv1, memLength))
    cout<<"error reported by ffv1BlockWrite()"<<endl; 
  

    for(unsigned long i=0; i<memLength; i++)
      {
        int retVal=ffv1Debug->ffv1SingleRead(&dataFromFFv1[i],i);
        if(retVal)
  	cout<<"ffv1SingleRead() reported an error"<<endl;
        cout<<"data from memory location ["<<i<<"] = "<<dataFromFFv1[i]<<endl;
      }

    ffv1Debug->checkData(dataToFFv1, dataFromFFv1, memLength);
  
  delete ffv1Debug;
  return 0;
}



int getBaseAddress(unsigned long * pBaseAddr)
{
  ifstream baseAddressFile;
  baseAddressFile.open("/home/xdaq/TriDAS/daq/fed_debug/src/linux/x86/FFv1BaseAddress.dat");
  if(!baseAddressFile.is_open())
    {
      cout<<"file /home/xdaq/TriDAS/daq/fed_debug/src/linux/x86/FFv1BaseAddress.dat not opened"<<endl;
      return 1;
    }
  baseAddressFile>>hex>>(*pBaseAddr);
  baseAddressFile.close();
  return 0;
}
 

