// version checked out from cern cvs 30.01.06

#include <iostream>

extern "C" {
#include "crcmodel.h"	// crc checking ; include before FFv1Object.hh
}

#include "FFv1Object.hh"


using namespace std;

int getBaseAddress(unsigned long *);

unsigned int opto_data;
int scope_len;
unsigned int readback_data;
int fe_id = 0;
int fe_chan = 1;
int dac_offset = 64;
// dac chan 1 feeds fe chan 12 !
//int dac_chan_map[12] = { 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1 };
unsigned int pattern_type;
unsigned int pattern;
int temp;
int delay_chip;
int delay_chan;
int coarse, fine;
int fine_skew_max;
int skew_done;
unsigned int threshold;
int be_cmd, be_rw;
unsigned int be_data;
int fe_cmd, fe_rw;
unsigned int fe_data;
int fe_id_tmp;
int clock_select;
int trigger_select;
int trk_hdr_format;
int num_trigs = 1;
int super_mode = 0;
int ped_mode = 0;
int strip_mode = 1;
int frame_thresh;
int spy_cmd;
int spy_bits;
int spy_offset;
int spy_words;
int eprom_cmd;
int eprom_mode;
unsigned int eprom_addr;
unsigned int eprom_data;
unsigned int eprom_quad;
unsigned int eprom_ser;
unsigned int eprom_fedid;
int lm82_cmd;
int lm82_nr;
int lm82_reg;
unsigned int lm82_data;
unsigned int lm82_tcrit;
int adm1025_cmd;
int adm1025_reg;
unsigned int adm1025_data;
int ttc_cmd;
unsigned int ttc_addr;
unsigned int ttc_data;
unsigned int ttc_bxctr, ttc_evtctr;
unsigned int ttc_skew;
unsigned int ttc_skew_start, ttc_skew_stop;
unsigned int ttc_ctrl;
int bram;
int nwords;
unsigned int mem_start;
int dac_cmd;
int dac_chan;
unsigned int dac_value;
int blt_flag;
int blt_type;
unsigned int blt_words;
unsigned int blt_tests;
unsigned int blt_memory;
int readout_source;
int event_format;
int event_stop;
int event_nr;
int endian_swap;
int ace_cmd;
int ace_confirm;
unsigned int ace_reg;
unsigned int ace_data;
unsigned int ace_lba;
unsigned int ace_sectors;
unsigned int ace_clusters;
unsigned int ace_file;
unsigned int ace_write;
unsigned int ace_test;
unsigned int ace_rev;

unsigned int ttcvi_cmd;
unsigned int ttcvi_trig;
unsigned int ttcvi_rate;
unsigned int ttcvi_orbit;
unsigned int ttcvi_bgo_nr;
unsigned int ttcvi_bgo_reg;
unsigned int ttcvi_bgo_delay;
unsigned int ttcvi_bgo_duration;
unsigned int ttcvi_bgo_enable;
unsigned int ttcvi_bgo_sync;
unsigned int ttcvi_bgo_single;
unsigned int ttcvi_bgo_fifo;
unsigned int ttcvi_bgo_format;
unsigned int ttcvi_ctr;
unsigned int ttcvi_async_type;
unsigned long ttcvi_short_cmd;
unsigned long ttcvi_long_ttcaddr;
unsigned long ttcvi_long_subaddr;
unsigned long ttcvi_long_data;
unsigned long ttcvi_long_ext;

int rbt_flag = 0;
int apve_check = 0;

int monitor_select;

int fake_cmd;
unsigned int fake_fibre;
unsigned int fake_addr;
unsigned int fake_data;
unsigned int fake_apv_reorder;

unsigned int vme_test;
unsigned int vme_offset;
unsigned int vme_data;
unsigned int vme_loops;

unsigned int fmm_test, fmm_data;
typedef enum fmm_bits { disconnected, warning_overflow, out_of_sync, busy = 4, ready = 8, error = 12 };
unsigned int be_test;

int pedfix = 0;
int cluslowfix = 50;
int clushighfix = 100;

	time_t now;
	struct tm *date;
	char start_date_str[40];
	char stop_date_str[40];



// hacked by jac 01.05.2003

//int main(void)
int main(int argc, char *argv[])
{
  unsigned int crate_nr = 0; // default is test crate
  unsigned int slot_nr = 999;
  unsigned int ser_nr = 0;
  unsigned int fed_ver = 1;

  const unsigned long memLength=0x40;

  cout << "FED hardware debug software... John Coughlan   last updated  23/06/2009..." << '\n';
	
//	return 0;

  if (argc > 1) {
    cout << argv[1];
    for (int i = 2; i != argc; i++)
      cout << " " << argv[i];
  }
  cout << endl;

  if (argc > 1) {
    crate_nr = atoi(argv[1]);
  }
  if (argc > 2) {
    slot_nr = atoi(argv[2]);
  }

  unsigned long baseAddress=0;
  if (slot_nr == 999) { // get default base address from file
    if(getBaseAddress(&baseAddress)) {
	cout<<"base address not found"<<endl;
	return -1;
    }
  }
  else {
    baseAddress = slot_nr * 0x10000;
  }

  printf("FED:\n");
  printf("    Crate Nr = %d \n", crate_nr);
  printf("     Slot Nr = %d \n", slot_nr);
  printf("Base Address = $%08x \n", (unsigned int) baseAddress);

  // string addressTableLocation="/home/xdaq/TriDAS/daq/fed_debug/src/linux/x86/FFv1AddressTable.dat";
  //  string addressTableLocation="/home/xdaq/local/fed_debug/src/linux/x86/FFv1AddressTable.dat";  
  string addressTableLocation="FFv1AddressTable.dat";  

  FFv1Object * ffv1Debug= new FFv1Object(crate_nr, baseAddress,addressTableLocation);
  string ffv1AddressItem="FFv1BaseItemSingleDataNonPriv";

  cout<<"FED base address = 0x"<<hex<<baseAddress<<endl;

  ffv1Debug->ReadSerNrEPROM(&ser_nr, &eprom_fedid, 1);

	printf("Initialising TTCrx \n");
	ttc_ctrl = 0xd3;
	ffv1Debug->WriteTTCrx(3, &ttc_ctrl, 1);
	printf("Chan B serial output is enabled ; ctrl reg = $%02x \n", ttc_ctrl);

  TTCvi_Card = TTCvi_Card_Base - baseAddress; // use slot nr to calculate ttcvi base relative to FED for HAL
  cout<<"TTCvi relative base address = 0x"<<hex<<TTCvi_Card<<endl;

  DPM_Test_Card = DPM_Test_Card_Base - baseAddress; // use slot nr to calculate DPM base relative to FED for HAL
  cout<<"DPM A32 relative base address = 0x"<<hex<<DPM_Test_Card<<endl;

//	lm82_tcrit = 65;
//	printf("==> INFO : Initialising all 8 FE FPGA LM82 TCrits at %d deg C\n", lm82_tcrit);
//  ffv1Debug->SetLM82_TCrits(lm82_tcrit, 0);



//    {
//      unsigned long  mydata = 0;
//      unsigned long offset = 0;
//          int retVal=ffv1Debug->ffv1SingleRead(&mydata, offset);
//          if(retVal)
//    	cout<<"ffv1SingleRead() reported an error"<<endl;
//          cout<<"data from memory location [0] = "<<mydata<<endl;
//    }
//  	return 0;

  // output file

  char file_name_str[60] = "fed9u_";
	{		
		/* Convert it to a broken-down time.	*/
		time( &now );
		date = localtime( &now );

		/* Convert that to a string.		*/
		/* strftime( start_date_str, 40, "%a_%d_%b_%Y_%H%M%S", date ); */
		strftime( start_date_str, 40, "%Y_%m_%d_%H%M%S", date );

		printf( "Run Start time : %s\n", start_date_str );
       		printf( "\n" );
	}
	
	/* output file */
	strcat( file_name_str, start_date_str );

	printf( "Output file_name_str = \"%s\"\n", file_name_str );

	if (0) {
		output_file = fopen( file_name_str, "w" );	// must reenable output if we want to save a cflash file

		if ( output_file == NULL )
		{
			printf( "*** ERROR => Couldn't open output file name = %s\n", file_name_str );
			return -1;
		}
		else
		{
			printf( "INFO => Output file opened with pointer = %p\n", output_file );
			// fprintf(output_file, "Test output file \n");
		}
	}

	// fill the channel lookup table following Francois's numbering scheme
	int chan = 0;
	for (int fe=8; fe>0; fe--) {
		for (int fib=12; fib>0; fib--) {
			lut_chan[chan] = fe * 100 + fib;
			chan++;
		}
	}
	
	// pick some sensible defaults for fibre frame thresholds and pedestals
	for (int i=0; i<chan_max; i++) {
	    fibre_thresh_calc[i] = 16;
	    fibre_ped_calc[i] = 0;
	}

  for (;;) {

  int choice = ffv1Debug->userPrompt(crate_nr, baseAddress, ser_nr);
  unsigned int num_secs = 0;

   switch (choice) {
      case 'a' :
	cout << "Please enter OptoRx control bits (Hex X7:X0): ";
	cin >> hex >> opto_data;
	ffv1Debug->SetOptoRx(fe_id, opto_data);
	break;
   case 'b' :
     cout << "Temperature LM82s (0 = Display All ; 1 = Set Register ; 2 = Set All Tcrits ; 3 = Set All Tcrit at 70 deg) : ";
     cin >> dec >> lm82_cmd;
     if (lm82_cmd == 1) {
       cout << "Enter Device Nr (1-8 FE FPGAs ; 9 = BE FPGA ; 10 = VME FPGA) ";
       cin >> dec >> lm82_nr;
       cout << "Enter Register Nr (hex) ";
       cin >> hex >> lm82_reg;
       cout << "Enter Data (hex) ";
       cin >> hex >> lm82_data;
			 if (lm82_nr < 9) {
			 lm82_nr = 9  - lm82_nr;  // for fedv2 fe numbering
			 }
       ffv1Debug->WriteLM82(lm82_nr-1, lm82_reg, &lm82_data, 1);
     }
     else if (lm82_cmd == 2){
			cout << "Please enter TCrit limit deg C (for all 8 FE FPGAs ; same for local and remote): ";
			cin >> dec >> lm82_tcrit;
       ffv1Debug->SetLM82_TCrits(lm82_tcrit, 0);
     } 
     else if (lm82_cmd == 3){
			lm82_tcrit = 70;
       ffv1Debug->SetLM82_TCrits(lm82_tcrit, 0);
     } 
			 else {   
       ffv1Debug->DisplayTemperatures(1);
			}
     break;
   case 'c' :
	cout << "Set Clock Skews : ";
	printf("\nNB as all 4 channels must be set together and clock skews cannot be read back ; unselected ADC channels will be set to fine & coarse skew = 0 \n");
	cout << "Please enter Delay FPGA (0-3) or 3 for ALL: ";
	cin >> dec >> delay_chip;
	cout << "Please enter ADC Channel (0-3) or 4 for ALL: ";
	cin >> dec >> delay_chan;
	cout << "Please enter Coarse delay (0-15): ";
	cin >> dec >> coarse;
	#ifdef FED_NEW_FINE_SKEW
	cout << "NEW FINE SKEW ==> Please enter Fine delay (0-63) [99 for skewing through all values]: ";
	#else
	cout << "Please enter Fine delay (0-31) [99 for skewing through all values]: ";
	#endif
	cin >> dec >> fine;

	#ifdef FED_NEW_FINE_SKEW
	fine_skew_max = 64;
	#else
	fine_skew_max = 32;
	#endif 
	
	if (fine == 99) {
		printf("Skewing clock through all Fine Delay settings... \n");
		for (int i=0; i<fine_skew_max; i++) {
				ffv1Debug->SetClockSkew(fe_id, delay_chip, delay_chan, coarse, i, 0);
				printf("fine skew = %d \n", i);
				usleep(1000000);
		}
	}
	else {
		ffv1Debug->ReadDelayFPGAClockSkewDone(fe_id, delay_chip, &skew_done);
		printf("At Start Clock Skew Done = $%08x\n", skew_done);
	
		printf("Setting Clock Skew...\n");
		ffv1Debug->SetClockSkew(fe_id, delay_chip, delay_chan, coarse, fine, 2);
	
		ffv1Debug->ReadDelayFPGAClockSkewDone(fe_id, delay_chip, &skew_done);
		printf("At End Clock Skew Done = $%08x\n", skew_done);
	}

	break;
      case 'd' :
	cout << "Select TrimDAC Cmd : (1 = Set value ; 2 = Reset ; 3 = Shutdown) : ";
	cin >> dec >> dac_cmd;
	if (dac_cmd == 2) {
	  ffv1Debug->ResetTrimDAC(fe_id, 1);
	}
	else if (dac_cmd == 3) {
	  ffv1Debug->ShutdownTrimDAC(fe_id, 1);
	}
	else {
	  cout << "Enter Chan nr : (1-12 (Bot-Top) ; 0 = ALL 12) : ";
	  cin >> dec >> dac_chan;
	  cout << "Enter value : (0-255) : ";
	  cin >> dec >> dac_value;
	  ffv1Debug->WriteTrimDAC(fe_id, dac_chan, &dac_value, 2);
	}
	break;
   case 'e' :
     cout << "Serial EPROM (0 = Display ; 1 = Single Read ; 2 = Single Write ; 3 = Enable Write ; 4 = Read FED Ser nr ; 5 = Load FED Ser nr; 6 = Industry Test Results) : ";
     cin >> dec >> eprom_cmd;
     if (eprom_cmd == 0) {
       cout << "Enter Quadrant Nr  (0 = 0-511 ; 1 = 511-1023 ; 2 = 1024-1535 ; 3 = 1536-2047) ";
       cin >> dec >> eprom_quad;
       ffv1Debug->DumpSerialEPROM(eprom_quad, 1);
     }
     else if (eprom_cmd == 3) {
       cout << "Enter Write Protection Mode  (0 = None ; 1 = Upper Quarter ; 2 = Upper Half ; 3 = All ; 4 = WPEN & Upper Half) ";
       cin >> dec >> eprom_mode;
       ffv1Debug->EnableWriteEPROM(eprom_mode, 1);
     }
     else if (eprom_cmd == 1 || eprom_cmd == 2) {
       cout << "Enter EPROM Byte Address ( 0 - 2047) : ";
       cin >> dec >> eprom_addr;
       if (eprom_cmd == 2) {
       cout << "Enter Data (0-ff) $ : ";
       cin >> hex >> eprom_data;
	 ffv1Debug->WriteSerialEPROM(eprom_addr, &eprom_data, 2);
       }
       else {
 	 ffv1Debug->ReadSerialEPROM(eprom_addr, &eprom_data, 2);
	 printf("Serial EPROM Data = $%02x \n", eprom_data);
      }
     }
     else if (eprom_cmd == 4) {
       ffv1Debug->ReadSerNrEPROM(&eprom_ser, &eprom_fedid, 1);
 //      printf("FED ID = $ %08x \n", eprom_fedid);
       printf("FED Serial Nr = %03d \n", eprom_ser);
      }
     else if (eprom_cmd == 5) {
       cout << "Enter FED Serial Nr (dec) ";
       cin >> dec >> eprom_ser;
       cout << "Enter FED Board Version (1 or 2) ";
       cin >> dec >> fed_ver; 
       ffv1Debug->WriteSerNrEPROM(eprom_ser, fed_ver, 1);
     }
     else if (eprom_cmd == 6) {
        ffv1Debug->ReadEPROMData();
     }
      
     break;
      case 'f' :
	cout << "SystemACE cmds (0 = Display Regs; 1 = Single Reg Write ; 2 = Single Reg Read ; 3 = Access CF Contents ; 4 = Reload FPGAs ; 5 = Reset CFlash ; 6 = Save CFlash to Disk ; 7 = Load CFlash from Disk) : ";
	cin >> dec >> ace_cmd;

      ffv1Debug->WordModeSystemACE(2); // must be in WORD mode before first access

      if (ace_cmd == 0) {
 	ffv1Debug->DisplaySystemACE(1);
      }
      else if (ace_cmd == 1) {
	cout << "Enter SystemACE Reg Nr (WORD $00 - $3f) Hex : ";
	cin >> hex >> ace_reg;
	cout << "Enter Value ($0-$ffff) Hex : ";
	cin >> hex >> ace_data;
 	ffv1Debug->WriteSystemACE(ace_reg, ace_data, 1);
      }
      else if (ace_cmd == 2) {
	cout << "Enter SystemACE Reg Nr (WORD $00 - $3f) Hex : ";
	cin >> hex >> ace_reg;
	ffv1Debug->ReadSystemACE(ace_reg, &ace_data, 1);
	printf("Reg nr $%02x ; Value = $%02x \n", ace_reg, ace_data);
      }
      else if (ace_cmd == 3) {
	// if reading more than one cluster (256 sectors) must read entire clusters.
	// if reading just one cluster can read any number of sectors
	cout << "Enter access type : (Read From CF = 0 ; Write To CF = 1) : ";
	cin >> hex >> ace_write;

	cout << "Enter Starting Logical Block Address ($00 - $ffffff) Hex : ";
	cin >> hex >> ace_lba;
	cout << "Enter Number of Clusters Dec : ";
	cin >> dec >> ace_clusters;
	if (ace_clusters > 512) {
	  ace_clusters = 512;
	  printf("WARNING: Max nr clusters for 64MB CF is 512\n");
	}
//  	if (ace_clusters == 1) {
	  cout << "Enter Number of Sectors Dec : ";
	  cin >> dec >> ace_sectors;
//  	}
//  	else {
//  	  ace_sectors = 256;  // max nr sectors per cluster
//  	}
	if (ace_write == 0) {
	  cout << "Save contents to file (0 = No ; 1 = Yes) : ";
	  cin >> dec >> ace_file;
	}
	else {
	  ace_file = 0;
	}
	cout << "Simulate hardware access (0 = No ; 1 = Yes) : ";
        cin >> dec >> ace_test;

	unsigned int verbosity = 1;
	if (ace_test == 1) verbosity = 2;

	for (unsigned int i=0; i<ace_clusters; i++) {
	  if (ace_write == 1) {
	    printf("Writing %d sectors to CF @ LBA $%04x cluster %d (end LBA = $%04x) \n",
		   ace_sectors, ace_lba, i,  (ace_clusters-1) * 256 + ace_sectors - 1);
	  }
	  else {
	    printf("Reading %d sectors from CF @ LBA $%04x cluster %d (end LBA = $%04x) \n",
		   ace_sectors, ace_lba, i,  (ace_clusters-1) * 256 + ace_sectors - 1);
	  }
	  ffv1Debug->AccessCFSectorSystemACE(ace_lba, ace_sectors, verbosity, ace_file, ace_write, ace_test, i);
	  ace_lba += 256;  // each lba points to a sector (512 byte) location
//  	  usleep(5000000);
	}
	printf("\nFinished Accessing Compact Flash Card contents\n");
      }
      else if (ace_cmd == 4) {
	cout << "Enter ACE File Rev nr (0-7) : ";
	cin >> dec >> ace_rev;
	ffv1Debug->ReloadFPGASystemACE(ace_rev, 2);
      }
      else if (ace_cmd == 5) {
	ffv1Debug->ResetSystemACE(2);
      }
			else if (ace_cmd == 6)
			{
	   	 printf("Saving an Image of the Compact Flash card to Disk with file name = 'cf_image_output.txt'\n");
//	   	 printf("Warning. If this operation is interrupted the Compact Flash card may need to be reformatted.\n");
				cout << "Do you wish to proceed ? (0=NO ; 1=YES) : ";
				cin >> dec >> ace_confirm;
				if (ace_confirm == 1) 
				{
	   	 		printf("saving compact flash image contents to file...this takes a couple of minutes....\n");
					ace_write = 0;
					ace_lba = 0;
					ace_sectors = 256;
					ace_clusters = 80;
					ace_file = 1;
					ace_test = 0;
					
					for (unsigned int i=0; i<ace_clusters; i++)
					{
	    			printf("Reading %d sectors from CF @ LBA $%04x cluster %d (end LBA = $%04x) \n",
		  				 ace_sectors, ace_lba, i,  (ace_clusters-1) * 256 + ace_sectors - 1);
		  
						ffv1Debug->AccessCFSectorSystemACE(ace_lba, ace_sectors, 0, ace_file, ace_write, ace_test, i);
	  						ace_lba += 256;  // each lba points to a sector (512 byte) location
					}
		   		printf("\n**** Compact Flash image has been saved to disk in file 'cf_image_output.txt'.\n");
				}
			}
			else if (ace_cmd == 7)
			{
	   	 printf("Downloading an Image from Disk to the Compact Flash card from file name = 'cf_image_input.txt'\n");
	   	 printf("WARNING. If this operation is interrupted the Compact Flash card may need to be reformatted.\n");
				cout << "Do you wish to proceed ? (0=NO ; 1=YES) : ";
				cin >> dec >> ace_confirm;
				if (ace_confirm == 1) 
				{
	   	 		printf("saving compact flash image contents to file...this takes a couple of minutes....\n");
					ace_write = 1;
					ace_lba = 0;
					ace_sectors = 256;
					ace_clusters = 80;
					ace_file = 1;
					ace_test = 0;
					
					for (unsigned int i=0; i<ace_clusters; i++)
					{
	    			printf("Writing %d sectors to CF @ LBA $%04x cluster %d (end LBA = $%04x) \n",
		   					ace_sectors, ace_lba, i,  (ace_clusters-1) * 256 + ace_sectors - 1);
		  
						ffv1Debug->AccessCFSectorSystemACE(ace_lba, ace_sectors, 0, ace_file, ace_write, ace_test, i);
	  						ace_lba += 256;  // each lba points to a sector (512 byte) location
					}
				}
		   	printf("\n**** Compact Flash contents should now have been updated.\n");
		   	printf("**** A Compact Flash Reset is now needed to reload FPGAs with new bit files.\n");
		}


//  	cout << "Please enter Frame Finding Threshold (same for ALL 12 fibres) (0-31) {x32 steps}: ";
//  	cin >> dec >> threshold;
//  	ffv1Debug->SetFrameThresholds(fe_id, threshold);

	break;
    case 'g' :
      cout << "TTCrx cmds (0 = Display ; 1 = Write ; 2 = I2C Reset ; 3 = TTCReset ; 4 = BX ctrs ; 5 = Set Fine Skew ; 6 Scan Fine Skews ; 7 = Enable Chan B) : ";
      cin >> dec >> ttc_cmd;
      if (ttc_cmd == 2) {
	ffv1Debug->ResetTTCrx(1);  // reset cmd via I2C
      }
      else if (ttc_cmd == 3) {
	ttc_data = 0;
	ffv1Debug->BECommand(11, 0, &ttc_data, 2); // reset via TTCreset line
      }
      else if (ttc_cmd == 1) {
	cout << "Enter TTCrx Reg Nr (0-29) : ";
	cin >> dec >> ttc_addr;
	cout << "Enter Value (0-ff) Hex : ";
	cin >> hex >> ttc_data;
	ffv1Debug->WriteTTCrx(ttc_addr, &ttc_data, 1);
      }
      else if (ttc_cmd == 4) {
	for (int i=0 ; i<20; i++) {
	  ffv1Debug->ReadTTCrxBXCtr(1, &ttc_bxctr, &ttc_evtctr);
	  printf("TTCrx : EVT ctr = %d ; BX ctr = %d \n", ttc_evtctr, ttc_bxctr);
	}
      }
      else if (ttc_cmd == 5) {
	cout << "Enter Fine Skew 1 (0-239 steps of 104 psec) : ";
	cin >> dec >> ttc_skew;
	ffv1Debug->WriteTTCrxFineSkew1(&ttc_skew, 1);
      }
      else if (ttc_cmd == 6) {
	cout << "Enter Start Skew value (0-239 steps of 104 psec) : ";
	cin >> dec >> ttc_skew_start;
	cout << "Enter Stop Skew value (0-239 steps of 104 psec) : ";
	cin >> dec >> ttc_skew_stop;
	if (ttc_skew_start < 240 && ttc_skew_stop < 240 && ttc_skew_stop > ttc_skew_start) {
	  for (unsigned int i=ttc_skew_start; i<ttc_skew_stop+1; i++) {
	    ttc_skew = i;
	    ffv1Debug->WriteTTCrxFineSkew1(&ttc_skew, 1);
	  }
	}
	else {
	  printf("Sorry illegal skew values \n");
	}
      }		
     else if (ttc_cmd == 7) {
			 ttc_ctrl = 0xd3;
	ffv1Debug->WriteTTCrx(3, &ttc_ctrl, 1);
	printf("Chan B serial output is enabled ; ctrl reg = $%02x \n", ttc_ctrl);
      }
      else {
	ffv1Debug->DisplayTTCrx(0);
      }
      break;
   case 'h' :
     cout << "BE FPGA; Please enter command code (dec): ";
     cin >> dec >> be_cmd;
     cout << "Enter 0 for Write or 1 for Read: ";
     cin >> dec >> be_rw;
     if (be_rw == 0)
       {
	 cout << "Writing: Please enter data (hex): ";
	 cin >> hex >> be_data;
       }

     ffv1Debug->BECommand(be_cmd, be_rw, &be_data, 2);
     break;
    case 'i' :
      {
	int run_type = 0;
//  	char *run_type_str[2] = {"Scope Mode", "Frame Finding Mode"};

      // set up all fpga settings in one go...

	cout << "Please enter Run Type (hex value)" << '\n';
	cout << "(1 = SCOPE ; 2 = VIR RAW ; 3 = VIR RAW FAKE ; 6 = PROC RAW ; 7 = PROC RAW FAKE ; a = ZS ; b = ZS FAKE ; c = ZS-LITE ; d = ZS-LITE FAKE): ";
	cin >> hex >> run_type;

     cout << "Please Enter Clock Source (1=Oscillator ; 2=TTC ; 4=BackPlane) :";
     cin >> dec >> clock_select;
     // this also resets FED so must be first operation
//		 printf("WARNING TEST no clock change... \n");
     ffv1Debug->SelectClock(clock_select, 2);
   
     cout << "Please Enter Trigger Source (1=TTC ; 2=BackPlane ; 4=Software) :";
     cin >> dec >> trigger_select;

	cout << "Please Tracker Header Type (1=Full Debug ; 2=APV Error) :";
     	cin >> dec >> trk_hdr_format;

	fe_id_tmp = fe_id;
	fe_id = 15; // broadcast


	if (run_type == 1)
	  {
	    cout << "Setting up FED for a Scope Run: ";

	// for scope mode...  // 8 x FE FPGA
	ffv1Debug->SetRunMode(fe_id, run_type); // set all fe to scope mode
	cout << "Please enter Scope Mode length for all FE's (dec): ";
	cin >> dec >> scope_len;
	ffv1Debug->SetScopeLength(fe_id, scope_len);

	  }
	else if (run_type == 2 || run_type == 3)
	  {
	    cout << "Setting up FED for a Frame Finding Run (with VIRGIN RAW Data): " << '\n';

	// for frame finding mode...  // 8 x FE FPGA
	ffv1Debug->SetRunMode(fe_id, run_type); // set all fe to frame finding mode

		if (run_type == 3) {
		printf("Using FAKE events\n");
		super_mode = 0x1;
		}
		else super_mode = 0x0;
		ffv1Debug->SetFESuperMode(fe_id, super_mode, 2);
		
	  }
	else if (run_type == 0xa || run_type == 0xb || run_type == 0xc || run_type == 0xd)
	  {
	    cout << "Setting up FED for a Frame Finding Run (with ZERO Suppressed Data): " << '\n';

	// for frame finding mode...  // 8 x FE FPGA
	ffv1Debug->SetRunMode(fe_id, run_type); // set all fe to frame finding mode
	
	usleep(1);  // needed for SBS at RAL or super mode is not set ??
	
		if (run_type == 0xb) {
		printf("Using FAKE events\n");
		super_mode = 0x1;
		}
		else if (run_type == 0xc) super_mode = 0x2;
		else if (run_type == 0xd) {
		printf("Using FAKE events\n");
		super_mode = 0x3;
		}
		else super_mode = 0x0;
		
		ffv1Debug->SetFESuperMode(fe_id, super_mode, 0);
	
  }
	else if (run_type == 6 || run_type == 7)
	  {
	    cout << "Setting up FED for a Frame Finding Run (with Processed RAW Data): " << '\n';

	// for frame finding mode...  // 8 x FE FPGA
	ffv1Debug->SetRunMode(fe_id, run_type); // set all fe to frame finding mode

		if (run_type == 7) {
		printf("Using FAKE events\n");
		super_mode = 0x1;
		}
		else super_mode = 0x0;
		
		ffv1Debug->SetFESuperMode(fe_id, super_mode, 0);

  }
	else
	  {
	    cout << "Sorry Illegal Run Type: ";
	    break;
	  }
		
//			exit (0); // debugging
		
	
	fe_id = fe_id_tmp; // restore current setting

// loading frame thresholds before pedestal rams seems to lead to incomplete peds ?? 09.03.06
   	if (run_type > 1) {
  	
//      ffv1Debug->EnableAPVChans(fe_id, 0); // Enable ALL 24 channels (data passed is ignored for now)
//  	cout << "All 24 APV channels are now enabled:" << '\n';

//          cout << "Please enter Frame Finding Threshold for all 96 channels (0-31) {x32 steps}: " << '\n';
//    	cin >> dec >> threshold;
//    	ffv1Debug->SetFrameThresholds(15, threshold);

	ffv1Debug->LoadFrameThresholds(1, 2, 100); // with constant 
//	ffv1Debug->LoadFrameThresholds(1, 0, 0); // with previously calculated values from scope mode run with external triggers
	printf("Loaded Frame Thresholds \n");  

	} 	  

//			exit (0); // debugging
	
	if (run_type == 0xa || run_type == 0xb || run_type == 0xc || run_type == 0xd) {  // ZS
	
		if (run_type == 0xb || run_type == 0xd) {
					pedfix = 10;
					printf("Loading Pedestals with fixed value = %d\n", pedfix);  // fake
     			ffv1Debug->LoadFibrePedestals(5, pedfix, 0);
//					printf("Loading Pedestals with counting data for Test \n");  // fake
//     			ffv1Debug->LoadFibrePedestals(6, 0);
		} else {
 					printf("Loading Pedestals with calculated values \n");  
    			ffv1Debug->LoadFibrePedestals(1, 0, 0);  
		}
					cluslowfix = 50;
					clushighfix = 100;
 					printf("Loading Cluster Thresholds with fixed values \n");  
	    		ffv1Debug->LoadClusterThresholds(0, cluslowfix, clushighfix, 0);  // set fixed low and high	
// 					printf("Loading Cluster Thresholds with counting data for Test \n");  
//	    		ffv1Debug->LoadClusterThresholds(1, 50, 100, 0);  // set fixed low and high	
 	}
	
//			exit (0); // debugging

	
// moved to start of initialisation  23/06/09 
       ffv1Debug->SetClockSkew(15, 3, 0, 0, 0, 0);
	cout << "Setting all 96 channels Clock skews coarse = 0 ; fine = 0" << '\n';

 // FAKE DATA modes
 // This must be after the Clock Skew in initialisation sequence for fake data to work???  jac 23/06/09
	if (run_type == 0x3 || run_type == 0x7 || run_type == 0xb || run_type == 0xd) {  
 		printf("\nYou have selected a FAKE data mode.\n"); 
		printf("Load same Fake data pattern to all 96 channels. Reads values from fakedata.txt\n");
		if (run_type == 0x7 || run_type == 0xb || run_type == 0xd) { 	
			ffv1Debug->LoadFakeEventData(15, 12, 1, 0, 0);  // broadcast to all 8 FEs ; fake data is reordered 
		} else {
			ffv1Debug->LoadFakeEventData(15, 12, 0, 0, 0);  // broadcast to all 8 FEs ; fake data not reordered for Virgin Raw
		}
//		printf("Set Fake Tick Level to full scale on all 96 channels\n");
//		ffv1Debug->LoadFakeEventData(15, 12, 0, 1, 0);
	}



	// reset trimDACs
//	unsigned int dac_reset = 0x2000;
//	ffv1Debug->FECommand(15, 6, 0, &dac_reset, 2);
//         cout << "Resetting all 96 channels TrimDACs" << '\n';

 	unsigned int trimdac_global = 100;  // 127 is reset value
	  ffv1Debug->WriteTrimDAC(15, 0, &trimdac_global, 1);
   printf("Setting all TRIMDACs = %d\n", trimdac_global);



        cout << "Please enter OptoRx setting (0 - 0xff) Hex: " << '\n';
  	cin >> hex >> opto_data;
  	// ffv1Debug->SetOptoRx(15, opto_data);
	ffv1Debug->FECommand(15, 0x16, 0, &opto_data, 2);
        cout << "Setting all 96 channels OptoRX offset = $" << hex << opto_data << '\n';


	printf("Setting up BE FPGA.. \n");
	ffv1Debug->InitBE(run_type, trigger_select, trk_hdr_format); // BE FPGA
 
/* 		printf("Initialising TTCrx \n");
			 ttc_ctrl = 0xd3;
		ffv1Debug->WriteTTCrx(3, &ttc_ctrl, 1);
		printf("Chan B serial output is enabled ; ctrl reg = $%02x \n", ttc_ctrl);
 */
 

      }
      break;
   case 'j':
     ffv1Debug->DisplayBEStatus(1);
     break;
     case 'k' :
//         {
//  	 int num_triggers = 0;
//  	 int num_microsecs = 0;

//         cout << "Test Frame Finding " << '\n';

//  	cout << "Nr Triggers to send (dec):";
//  	cin >> dec >> num_triggers;
//  	cout << "Nr Microsecs to send APV Frames (dec):";
//  	cin >> dec >> num_microsecs;

//         ffv1Debug->TestFrameFinding(num_triggers, num_microsecs);
//         }
     cout << "ADM1025 Voltage Monitor (0 = Display ; 1 = Set Register ; 2 = Dump Registers ; 3 Set Limits) : ";
     cin >> dec >> adm1025_cmd;
     if (adm1025_cmd == 1) {
       cout << "Enter Register Nr (hex) ";
       cin >> hex >> adm1025_reg;
       cout << "Enter Data (hex) ";
       cin >> hex >> adm1025_data;
       ffv1Debug->WriteADM1025(adm1025_reg, adm1025_data, 1);
     }
     else if (adm1025_cmd == 2) {
      ffv1Debug->WriteADM1025(0x40, 0x01, 1);  // enable monitoring
      ffv1Debug->DisplayADM1025(3, 1);
     }    
     else if (adm1025_cmd == 3) {
       ffv1Debug->WriteADM1025(0x2b, 0xc8, 1);  // 2.5V high
       ffv1Debug->WriteADM1025(0x2c, 0xb8, 1);  // 2.5V low
       ffv1Debug->WriteADM1025(0x2d, 0x88, 1);  // VCCP = 1.5V high
       ffv1Debug->WriteADM1025(0x2e, 0x78, 1);  // VCCP = 1.5V low
       ffv1Debug->WriteADM1025(0x2f, 0xc8, 1);  // 3.3V high
       ffv1Debug->WriteADM1025(0x30, 0xb8, 1);  // 3.3V low
       ffv1Debug->WriteADM1025(0x31, 0xc8, 1);  // 5V high
       ffv1Debug->WriteADM1025(0x32, 0xb8, 1);  // 5V low
       ffv1Debug->WriteADM1025(0x33, 0xc4, 1);  // 12V high
       ffv1Debug->WriteADM1025(0x34, 0xbd, 1);  // 12V low
       ffv1Debug->WriteADM1025(0x35, 0xc8, 1);  // VCC = 3.3V high
       ffv1Debug->WriteADM1025(0x36, 0xb8, 1);  // VCC = 3.3V low
       ffv1Debug->WriteADM1025(0x37, 0x0, 1);  // Remote Temp hign
       ffv1Debug->WriteADM1025(0x38, 0x0, 1);  // Remote Temp low
       ffv1Debug->WriteADM1025(0x39, 0x30, 1);  // Local Temp hign
       ffv1Debug->WriteADM1025(0x3a, 0x10, 1);  // Local Temp low
         } 
     else {
      ffv1Debug->WriteADM1025(0x40, 0x01, 1);  // enable monitoring
      ffv1Debug->DisplayADM1025(0, 1);
     }    
     break;

   case 'l' :
	   cout << "Load Data (1 = Pedestal per Strip ; 2 = Cluster Thresholds per Strip ; 3 = Frame Thresholds per Fibre) ";
     cin >> dec >> strip_mode;
		 if (strip_mode == 3) {
				printf("Please Enter Frame Threshold for all 96 Fibres (dec) 0-1023\n");
	    		cin >> dec >> frame_thresh;			
					ffv1Debug->LoadFrameThresholds(1, 2, frame_thresh); // with constant 		 
		 }
 			else if (strip_mode == 2) {
				printf("Please Enter low thresh (dec)\n");
	    		cin >> dec >> cluslowfix;			
 				printf("Please Enter high thresh (dec)\n");
	    		cin >> dec >> clushighfix;			
   		ffv1Debug->LoadClusterThresholds(0, cluslowfix, clushighfix, 0);	// normal
	 // 		ffv1Debug->LoadClusterThresholds(1, cluslowfix, clushighfix, 0);   //  testing multiple string commands
		} else {
     		cout << "Please Enter Loading mode (0=Normal; 1=Single serial cmds ; 2=Multiple serial cmds ; 3=Multiple Serial cmds and BLT32 ; 5=Fixed Value ; 6=Test Counting) :";
     		cin >> dec >> ped_mode;
				if (ped_mode == 5) {
				printf("Please Enter fixed ped value (dec)\n");
	    		cin >> dec >> pedfix;			
				}
     		ffv1Debug->LoadFibrePedestals(ped_mode, pedfix, 0);
			}
     break;
    case 'm':
      {
	int berr = 0;
	unsigned int fedmap[22], fedbase[22];
	FFv1Object * ffv1Debug_temp;
	unsigned int dummy1;
	unsigned long dummy2;

	for (int slot=1; slot<22; slot++) {
	  fedmap[slot] = 0;
	  ffv1Debug_temp = new FFv1Object(crate_nr, slot * 0x10000, addressTableLocation);
	  berr = ffv1Debug_temp->ffv1SingleRead(&dummy2, 0); // check for FED in slot
	  if (berr != -1) {
	    ffv1Debug_temp->ReadSerNrEPROM(&fedmap[slot], &dummy1, 1);
	    fedbase[slot] = slot * 0x10000;
	  }
	}
	printf("\n\nCrate nr = %02d \n", crate_nr);
	printf("Slot \tFED\n");
	printf("\tSer Nr \tBase Addr $ \n");
	for (int slot=1; slot<22; slot++) {
	  printf("%02d", slot);
	  if (fedmap[slot] != 0) {
	      printf("\t %03d \t$%08x\n", fedmap[slot], fedbase[slot]);
	  }
	  else {
	    printf("\t ---\n");
	  }
	}
      }
     break;
   case 'n':
	   cout << "Display Strip Data (1 = Pedestals ; 2 = Cluster Thresholds ; 3 = Frame Thresholds) ";
     cin >> dec >> strip_mode;
		 if (strip_mode == 3) {
 		   ffv1Debug->DisplayFrameThresholds(1);
		 }
			else if (strip_mode == 2) {
     	 ffv1Debug->DisplayClusterThresholds(0);
			} else {
     	 ffv1Debug->DisplayFibrePedestals(1);
			}			
     break;
   case 'o':
     fe_id_tmp = fe_id;
     cout << "Please enter FE FPGA nr (NB Use FEDv2 order:  1 (BOT) -> 8 (TOP) ; 15 for Broadcast): ";
     cin >> dec >> fe_id;
     if (fe_id < 1 || (fe_id > 8 && fe_id != 15 )) {
       printf("Sorry Illegal FE FPGA nr, setting to nr 8 \n");
       fe_id = 0;
     } else {
       if (fe_id != 15) {
	 fe_id = 8 - fe_id; // translate back from new FEDv2 ordering 8->1 to fe fpga readout ordering 1->8 ; internally fe cmd string uses index 0 top - 7 bot
       }
     }
     cout << "FE FPGA; Please enter command code (dec): ";
     cin >> dec >> fe_cmd;
     cout << "Enter 0 for Write or 1 for Read: ";
     cin >> dec >> fe_rw;
     if (fe_rw == 0)
       {
	 cout << "Writing: Please enter data (hex): ";
	 cin >> hex >> fe_data;
       }

     ffv1Debug->FECommand(fe_id, fe_cmd, fe_rw, &fe_data, 2);
     fe_id = fe_id_tmp; // restore current setting
     break;
   case 'p' :
     ffv1Debug->DisplayFEStatus(1);
      break;
   case 'q' :
     ffv1Debug->DisplayFirmwareVersions(stdout, 1);
     break;
   case 'r' :
     // ffv1Debug->DisplayFrameThresholds(1);
		 // fake frames
		 
     printf("Which Fake Event Data Command ( 0 = Display RAMs ; 1 = Load All 96 RAMs ; 2 = Load All 96 Tick Levels ; 3 = Enable Fake Events ; 4 = Write Reg ; 5 = Read Reg) ? \n");
		 cin >> fake_cmd;
		 if (fake_cmd == 0) {
     	//	cout << "Enter Fibre Nr (12 (top) - 1 (bot)): ";
      cout << "Enter RAM Nr (0 - 11): (corresponds to Fibre Nrs 12 - 1): ";
   	 	cin >> dec >> fake_fibre;
			 ffv1Debug->DumpFakeEventData(fe_id, fake_fibre, 0);
			 
			 	
/* 	int strip;
	for (int i=0; i<128; i++) {
		strip = 32 * (i % 4) + 8 * (i/4) - 31 * (i/16);
		printf("i = %d; strip = %d \n", i, strip);
	}
 */
		 }
		 else if (fake_cmd == 1) {
//     		cout << "Enter Fibre Nr (12 (top) - 1 (bot) ; 0 = ALL 12): ";
				printf("This loads same Fake data pattern to all 96 channels. Reads values from fakedata.txt\n");
//     		cout << "Enter RAM Nr (0 - 11 ; 12 = ALL 12): ";
//    	 	cin >> dec >> fake_fibre;
//			 ffv1Debug->LoadFakeEventData(fe_id, fake_fibre, 0, 0);
    		cout << "Fill RAM in APV order? (1 for FE FPGA Modes: Raw Proc, ZS, ZS-Lite) ; 0 = No / 1 = Yes): ";
    	 	cin >> dec >> fake_apv_reorder;
			 ffv1Debug->LoadFakeEventData(15, 12, fake_apv_reorder, 0, 0);  // broadcast to all 8 FEs
		 }
		 else if (fake_cmd == 2) {
//     		cout << "Enter Fibre Nr (12 (top) - 1 (bot) ; 0 = ALL 12): ";
			printf("This sets Fake Tick Level to full scale on all 96 channels\n");
			 ffv1Debug->LoadFakeEventData(15, 12, 0, 1, 0);
		 }
		 else if (fake_cmd == 3) {
			 ffv1Debug->EnableFakeEventData(fe_id, 0);
		 }
		 else if (fake_cmd == 4) {
     		cout << "Enter Fake Address (hex): ";
    	 	cin >> hex >> fake_addr;
    	 	cout << "Enter Data (dec): ";
     		cin >> dec >> fake_data;
			 	ffv1Debug->WriteFakeAddr(fe_id, &fake_addr, 0);
			 	ffv1Debug->WriteFakeData(fe_id, &fake_data, 0);
		 }
		 else if (fake_cmd == 5) {
     		cout << "Enter Fake Address (hex): ";
    	 	cin >> hex >> fake_addr;
			 	ffv1Debug->WriteFakeAddr(fe_id, &fake_addr, 0);
			 	ffv1Debug->ReadFakeData(fe_id, &fake_data, 0);
				printf("Read Data = %d (dec)\n", fake_data);
		 }
		 else {
		 }
 		 
     break;
   case 's' :
     cout << "Which Spy Command (7 = ARM ; 8 = FIRE ; 6 = DELAY FIRMWARE ID) : ";
     cin >> dec >> spy_cmd;
     cout << "Please enter Delay Chip (0-2 ; 3 for ALL [but only for ARM]) : ";
     cin >> dec >> delay_chip;
     if (spy_cmd == FED_SPY_FIRE || spy_cmd == FED_DELAY_ID) {
       cout << "How many bits to transfer from Delay to VME Serial Memory ? (0 to 41000) : ";
       cin >> dec >> spy_bits;

       ffv1Debug->FillMemory(FED_Serial_BRAM, 2048/4, 0, 0xffffffff, 0);  // pre-fill serial memory
       printf("Pre-fill Serial Memory with $ffffffff \n");

       ffv1Debug->SpyCommand(fe_id, delay_chip, spy_cmd, spy_bits);

       //      ffv1Debug->SpyDisplay(0);
     }
     else if (spy_cmd == FED_SPY_ARM) {
       ffv1Debug->SpyArm(fe_id, delay_chip);
     }
     break;
   case 't' :
			 
      ffv1Debug->SendSWTrig(0);
     // clear readout csr to allow next trigger
     usleep(10000); // wait for vme buffer to fill with event
     ffv1Debug->ClearReadoutCSR(2);
 
      break;
   case 'u':
     cout << "Which Block RAM (1 = Serial Memory ; 2 = VME Buffer ; 3 = DPM Test Card) : ";
     cin >> dec >> bram;
     cout << "Transfer type? (0=Normal ; 1 = BLT32 ; 2 = Turbo BLT32) ";
     cin >> dec >> blt_flag;
     cout << "How many (32 bit) words to readout ? ";
     cin >> dec >> nwords;
     if (nwords > 8*1024) nwords = 8*1024; // max mem is 32 Kbytes
     if (bram == 1) {
       mem_start = FED_Serial_BRAM;
     }
     else if (bram == 3) {
       mem_start = DPM_Test_Card;
     }
     else {
       mem_start = FED_Readout_BRAM;
     }
     if (nwords == 0) nwords = 1024*2;
     ffv1Debug->DumpMemory(mem_start, nwords, blt_flag);

    break;
   case 'v':
     cout << "Which Block RAM (1 = Serial Memory ; 2 = VME Buffer ; 3 = DPM Test Card) : ";
     cin >> dec >> bram;
     cout << "Transfer type? (0=Normal ; 1 = BLT32 ; 2 = Turbo BLT32) ";
     cin >> dec >> blt_flag;
     cout << "How many (32 bit) words to fill? ";
     cin >> dec >> nwords;
     if (nwords > 8*1024) nwords = 8*1024; // max mem is 32 Kbytes
     cout << "Pattern type? (0=Single Value ; 1 = Sequence) ";
     cin >> dec >> pattern_type;
     if (pattern_type == 1) {
     }
     else {
       cout << "Please enter Pattern to fill VME Memory (Hex 0-fffffff) : ";
       cin >> hex >> pattern;
     }
     if (bram == 1) {
       mem_start = FED_Serial_BRAM;
     }
     else if (bram == 3) {
       mem_start = DPM_Test_Card;
     }
     else {
       mem_start = FED_Readout_BRAM;
     }
     if (nwords == 0) nwords = 1024*2;
     ffv1Debug->FillMemory(mem_start, nwords, pattern_type, pattern, blt_flag);

     break;
   case 'w':
     cout << "Please enter FE FPGA nr (NB Use FEDv2 order:  1 (BOT) -> 8 (TOP) ; 15 for Broadcast): ";
     cin >> dec >> fe_id;
     if (fe_id < 0 || (fe_id > 7 && fe_id != 15 )) {
       printf("Sorry Illegal FE FPGA nr, setting to nr 8 \n");
       fe_id = 0;
     } else {
       if (fe_id != 15) {
	 fe_id = 8 - fe_id; // translate back from new FEDv2 ordering 8->1 to fe fpga readout ordering 1->8
       }
     }
     break;
   case 'x' :
     return 0;
     break;
   case 'y' :
     ffv1Debug->DisplayVMEStatus(2);
     break;
   case 'z' :
     cout << "Test readout from VME or File? (0 = VME ; 1 = File (eventinput.txt) >> ";
     cin >> dec >> readout_source;
     if (readout_source == 1) {
//        cout << "Do an Endian swap ? (0 = No ; 1 = Yes) >> ";
//       cin >> dec >> endian_swap;
       cout << "What type of Event Format to check? (1 = Scope Mode ; 2 = Zero Suppressed ; 3 = Counting Pattern) >> ";
       cin >> dec >> event_format;
 //      cout << "Event Nr in File (-1 to ignore value) >> ";
 //      cin >> dec >> event_nr;
		 printf("\n");
       ffv1Debug->TestReadoutFromFile(1, event_format, event_nr, endian_swap);
  
//	      ffv1Debug->TestReadoutFromFile(1, -1, 0);	 // to speed up testing!
		    }
     else {
       cout << "How many software triggers ? (0 = wait for external triggers ; -1 = send s/w for nsecs) >> ";
       cin >> dec >> num_trigs;
       if (num_trigs == 0) {
	 cout << "How many seconds to wait for external hardware triggers ? >> ";
	 cin >> dec >> num_secs;
       }
       else if (num_trigs == -1) {
	 cout << "How many seconds to run with software triggers ? >> ";
	 cin >> dec >> num_secs; 
       }
       else {
       	 cout << "Do you want to check APVe Address errors ? TTCvi card must be connected to FED via TTC fibre (1 = Yes; 0 = No) >> ";
       	 cin >> dec >> apve_check;
	 if (apve_check == 1) {
		ttc_ctrl = 0xd3;
		ffv1Debug->WriteTTCrx(3, &ttc_ctrl, 1);
		printf("TTCRX Chan B serial output is enabled\n");
	 }
       }
       
 //      cout << "What type of Event Format to check? (1 = Scope Mode ; 2 = Zero Suppressed ; 3 = S-Link Pattern) >> ";
 //      cin >> dec >> event_format;
       cout << "Do you want to Stop test at the first error? (1 = Yes ; 2 = No) >> ";
       cin >> dec >> event_stop;
        cout << "Turbo Block Transfer Readout? (1 = Yes ; 0 = No) >> ";
       cin >> dec >> rbt_flag;
      ffv1Debug->ReadSerNrEPROM(&eprom_ser, &eprom_fedid, 1);
 //      printf("FED ID = $ %08x \n", eprom_fedid);
       printf("FED Serial Nr = %03d \n", eprom_ser);
       ffv1Debug->DisplayFEStatus(1);
       ffv1Debug->DisplayBEStatus(1);
       ffv1Debug->DisplayClockStatus(1);
       if (num_trigs == 0) {
           printf("Sending External random triggers from TTCvi at 1 Hz \n");  
	 cout << "TTCvi : Please chose Random Rate (0 = 1 Hz ; 1 = 100 Hz ; 2 = 1 kHz ; 3 = 5 kHz ; 4 = 10 kHz ; 5 = 25 kHz ; 6 = 50 kHz ; 7 = 100 kHz) : ";
	 cin >> dec >> ttcvi_rate;
           ffv1Debug->TTCvi_Select_Trigger(TTCvi_Card, 0, ttcvi_rate, 2);
	}

       ffv1Debug->TestReadout(num_trigs, num_secs, 1, event_stop, rbt_flag, apve_check);

       if (num_trigs == 0) {
           printf("Disabling External triggers from TTCvi \n");  
           ffv1Debug->TTCvi_Select_Trigger(TTCvi_Card, 7, 0, 2);
	}
     }
     break;
   case '1' :
     ffv1Debug->ResetFED(2);
     break;
   case '2' :
     cout << "Please Enter New Clock Selection (1=Osc ; 2=TTC ; 4=BkPlane) :";
     cin >> dec >> clock_select;
     ffv1Debug->SelectClock(clock_select, 2);
     break;
   case '3' :
     // just s/w trigger, without clear of readout csr
     ffv1Debug->SendSWTrig(0);
     break;
   case '4' :
     // clear of readout csr
     ffv1Debug->ClearReadoutCSR(2);
     break;
    case '5' :
     // FMM card tests
 		cout << "Select FMM Test  : (1 = Set FMM Test Reg ; 2 = Read FMM Test Reg ; 3 = Send Sequence FMM bits ) : ";
		cin >> dec >> fmm_test;
		if (fmm_test == 1) {
			cout << "Enter 4 FMM bits (Hex) : (Ready = msb)";
			cin >> hex >> fmm_data;
			ffv1Debug->BECommand(34, 0, &fmm_data, 0); 
		}
		else if (fmm_test == 2) {
			ffv1Debug->BECommand(34, 1, &fmm_data, 0); 
		  printf("FMM Test Reg:	Ready/Busy/Out of Sync/Warn Overflow = $%01x \n", (unsigned int) fmm_data);
			for (int i=0; i<3; i++) {
				printf(" %01x /", fmm_data >> i & 0x1);
			}
		}
 		else if (fmm_test == 3) {
			printf("Sending Sequence => Ready -> Warn Overflow -> Busy -> Out of Sync  (NB this operation overwrites BE Test register)\n");
			fmm_bits fmm_sequence[4] = { ready, warning_overflow, busy, out_of_sync };
			be_test = 0x10;
			ffv1Debug->BECommand(4, 0, &be_test, 0); 	// must enable FMM test register			
			for (int i=3; i>=0; i--) {
				fmm_data = 1<<i & 0x1;
				ffv1Debug->BECommand(34, 0, (unsigned int *) &fmm_sequence[i], 0); 		
				sleep(1);
			}		
			be_test = 0x0;
			ffv1Debug->BECommand(4, 0, &be_test, 0); 	// must disable FMM test register			
		}
   
     break;
  case '6' :
     // external TTCvi card commands
     cout << "TTCvi cmd (0 = Display; 1 = Set Defaults; 2 = Send Trig ; 3 = Sel Trig ; 4 = Sel Orbit ; 5 = Chan B cmds ; 6 = Reset Ctrs ; 7 = Select Ctr ; 8 = VME Async ChanB ; 9 = Reset Module ; 10 = BX orbit resets) : ";
     cin >> dec >> ttcvi_cmd;
     if (ttcvi_cmd == 0) {
       ffv1Debug->TTCvi_Display(TTCvi_Card, 2);
     }
     else if (ttcvi_cmd == 1) {
       //       ffv1Debug->TTCvi_Set_Defaults(TTCvi_Card, 2);
     }
     else if (ttcvi_cmd == 2) {
       ffv1Debug->TTCvi_SW_Trigger(TTCvi_Card, 2);
     }
     else if (ttcvi_cmd == 3) {
       cout << "TTCvi : Trigger Source (0 = Random; 1 = Calibr; 2 = VME cmd; 3 = L1A<0>; 4 = L1A<1>; 5 = L1A<2>; 6 = L1A<3>; 7 = Disable ) : ";
       cin >> dec >> ttcvi_trig;
       if (ttcvi_trig == 0 ) {
	 cout << "TTCvi : Random Rate (0 = 1 Hz ; 1 = 100 Hz ; 2 = 1 kHz ; 3 = 5 kHz ; 4 = 10 kHz ; 5 = 25 kHz ; 6 = 50 kHz ; 7 = 100 kHz) : ";
	 cin >> dec >> ttcvi_rate;
       }
       ffv1Debug->TTCvi_Select_Trigger(TTCvi_Card, ttcvi_trig, ttcvi_rate, 2);
     }
     else if (ttcvi_cmd == 4) {
       // differs from TTCvi register description?
       cout << "TTCvi : Orbit signal (1 = Internal; 0 = External) : ";
       cin >> dec >> ttcvi_orbit;
       ffv1Debug->TTCvi_Select_Orbit(TTCvi_Card, ttcvi_orbit, 2);
     }
     else if (ttcvi_cmd == 5) {
       cout << "TTCvi : Chan B : Select B-Go  (0 - 3) : ";
       cin >> dec >> ttcvi_bgo_nr;
       cout << "TTCvi : Chan B : Select cmd (0 = Inhibit ; 1 = Mode ; 2 = Data ; 3 = Write ; 4 = Reset FIFO) : ";
       cin >> dec >> ttcvi_bgo_reg;
       if (ttcvi_bgo_reg == 0) {
        cout << "TTCvi : Enter BGO Inhibit Delay (0-2047) : ";
	cin >> dec >> ttcvi_bgo_delay;
        cout << "TTCvi : Enter BGO Inhibit Duration (0-255) : ";
	cin >> dec >> ttcvi_bgo_duration;
	ffv1Debug->TTCvi_BGO_Inhibit(TTCvi_Card, ttcvi_bgo_nr, ttcvi_bgo_delay, ttcvi_bgo_duration, 2);
      }
      else if (ttcvi_bgo_reg == 1) {
        cout << "TTCvi : BGO : Front Panel Input (0 = Enable; 1 = Disable) : ";
	cin >> dec >> ttcvi_bgo_enable;
        cout << "TTCvi : BGO : Synch (0 = Synchronous; 1 = Asynchronous) : ";
	cin >> dec >> ttcvi_bgo_sync;
        cout << "TTCvi : BGO : Single (0 = Single ; 1 = Repetitive) : ";
	cin >> dec >> ttcvi_bgo_single;
        cout << "TTCvi : BGO : FIFO (0 = Start not Empty; 1 = Don't look at FIFO) : ";
	cin >> dec >> ttcvi_bgo_fifo;
	ffv1Debug->TTCvi_BGO_Mode(TTCvi_Card, ttcvi_bgo_nr, ttcvi_bgo_enable, ttcvi_bgo_sync, ttcvi_bgo_single, ttcvi_bgo_fifo, 2);
      }
      else if (ttcvi_bgo_reg == 2) {
        cout << "TTCvi : BGO : FIFO Command Format (0 = Short ; 1 = Long) ";
	cin >> dec >> ttcvi_bgo_format;
	ffv1Debug->TTCvi_BGO_Data(TTCvi_Card, ttcvi_bgo_nr, ttcvi_bgo_format, 2);
      }
      else if (ttcvi_bgo_reg == 3) {
	ffv1Debug->TTCvi_BGO_Write(TTCvi_Card, ttcvi_bgo_nr, 2);
      }
      else if (ttcvi_bgo_reg == 4) {
	ffv1Debug->TTCvi_BGO_Reset_FIFO(TTCvi_Card, ttcvi_bgo_nr, 2);
      }
     }
     else if (ttcvi_cmd == 6) {
       ffv1Debug->TTCvi_Reset_Counters(TTCvi_Card, 2);
     }
     else if (ttcvi_cmd == 7) {
        cout << "TTCvi : Counter (0 = Events ; 1 = Orbits) ";
	cin >> dec >> ttcvi_ctr;
        ffv1Debug->TTCvi_Select_Counter(TTCvi_Card, ttcvi_ctr, 2);
     } 
     else if (ttcvi_cmd == 8) {
        cout << "TTCvi : Send Async Chan B cmd (0 = Broadcast ; 1 = Individually Addressable) ";
	cin >> dec >> ttcvi_async_type;
	if (ttcvi_async_type == 0) {
	  cout << "TTCvi : Enter Broadcast Data ($0-$ff) : ";
	  cin >> hex >> ttcvi_short_cmd;
	  ffv1Debug->TTCvi_Async_Short(TTCvi_Card, ttcvi_short_cmd, 2);
	}
	else if (ttcvi_async_type == 1) {
	  cout << "TTCvi : Enter TTCrx Address Command ($0-$3fff) : ";
	  cin >> hex >> ttcvi_long_ttcaddr;
	  cout << "TTCvi : Enter Subaddr ($0-$ff) : ";
	  cin >> hex >> ttcvi_long_subaddr;
	  cout << "TTCvi : Enter Data ($0-$ff) : ";
	  cin >> hex >> ttcvi_long_data;
	  cout << "TTCvi : Internal / External (0/1) : ";
	  cin >> hex >> ttcvi_long_ext;

	  ffv1Debug->TTCvi_Async_Long(TTCvi_Card, ttcvi_long_ttcaddr, ttcvi_long_subaddr, ttcvi_long_data, ttcvi_long_ext, 2);
	}
     }
      else if (ttcvi_cmd == 9) {
       ffv1Debug->TTCvi_Reset_Module(TTCvi_Card, 2);
     }
      else if (ttcvi_cmd == 10) {
	// set up BGO<0> to generate BX reset on each orbit
        ffv1Debug->TTCvi_Select_Counter(TTCvi_Card, 0, 2);
	ffv1Debug->TTCvi_Reset_Counters(TTCvi_Card, 2);

	ffv1Debug->TTCvi_BGO_Reset_FIFO(TTCvi_Card, 0, 2);
 	ffv1Debug->TTCvi_BGO_Retransmit(TTCvi_Card, 0, 2);
 	ffv1Debug->TTCvi_BGO_Inhibit(TTCvi_Card, 0, 1, 1, 2);
	ffv1Debug->TTCvi_BGO_Mode(TTCvi_Card, 0, 1, 0, 1, 1, 2);
	ffv1Debug->TTCvi_BGO_Data(TTCvi_Card, 0, 0, 2);
 
        ffv1Debug->TTCvi_Select_Orbit(TTCvi_Card, 1, 2);
     }

//       ffv1Debug->DisplayClockCounters(2);
     break;
   case '7' :
		 cout << "Display Monitor Data for SPY channel or TRK HEADER (1 or 2)? ";
      cin >> dec >> monitor_select;
			if (monitor_select == 1) {
    cout << "How many (32 bit) words of spy data in the VME serial memory to show? ";
     cin >> dec >> spy_words;
    cout << "How many bits in serial memory to skip before spy data starts ? (was 44) ";
     cin >> dec >> spy_offset;
     ffv1Debug->SpyDisplay(spy_offset, spy_words);
	 }
	 else {
     ffv1Debug->DisplayTrackerHeaderMonitor(1);
	 }
     break;
   case '8' :	 
	 		printf("VME Bus Read and Write Tests (Single VME cycles A32 D32) \n");
     cout << "Test type (1 = Write ; 2 = Read) : ";
     cin >> dec >> vme_test;
     cout << "Address offset in BYTES from FED base (hex) [e.g. SERIAL Cmd BRAM starts @ 0 ; VME Buffer BRAM starts @ 8000] ";
     cin >> hex >> vme_offset;
     cout << "Number of Loops to run (dec) : ";
     cin >> dec >> vme_loops;

 
 if (vme_test == 1) {
    cout << "Data to write (hex) ";
     cin >> hex >> vme_data;
		 
	 	printf("Continuously Writing to single location on VME bus...\n");
		 ffv1Debug->VMEWriteLoop(vme_offset, vme_data, vme_loops);

		 } else {
		 
	 	printf("Continuously Reading from single location on VME bus... \n");
		 		 ffv1Debug->VMEReadLoop(vme_offset, vme_loops, 1);
		 }
		 		 

 //    ffv1Debug->DisplayFibreBufferLevels(1);
     break;
   case '9' :
 	   cout << "Which Type of TURBO Block Transfer (READ=0/WRITE=1) ? ";
     cin >> dec >> blt_type; 
	   cout << "Block Transfer Test : Which memory to test [Serial buffer = 1 ; VME buffer = 2 ; DPM Test card = 3] ? ";
     cin >> dec >> blt_memory; 
	   cout << "Block Transfer Test : How many (32 bit) words to Read [VME buffer max = 8192] ? ";
     cin >> dec >> blt_words; 
 	   cout << "How many Test loops to do ? "; 
     cin >> dec >> blt_tests; 
		 
		 if (blt_type == 0)
		 {
    		ffv1Debug->TestReadBLT(blt_words, blt_tests, blt_memory);
			}
			else
			{
    		ffv1Debug->TestWriteBLT(blt_words, blt_tests, blt_memory);
			}
		 
     // ffv1Debug->LoadFrameThresholds(1, 0, 0);
     break;
   default:
      cout << "Sorry didn't recognise that choice. Try again. " << '\n';
      break;
      }
  }

  return 0; 


//    {
//      unsigned long  mydata = 0;
//      unsigned long offset = 0;
//          int retVal=ffv1Debug->ffv1SingleRead(&mydata, offset);
//          if(retVal)
//    	cout<<"ffv1SingleRead() reported an error"<<endl;
//          cout<<"data from memory location [0] = "<<mydata<<endl;
//    }
//  	return 0;


  //initial testing routines. 

//    if(ffv1Debug->preliminaryTest(ffv1AddressItem))
//      cout<<"error reported by preliminaryTest()"<<endl; 

//    if(ffv1Debug->writeBlockMemTest())
//      cout<<"error reported by writeBlockMemTest()"<<endl; 
   
//    if(ffv1Debug->readBlockMemTest())
//      cout<<"error reported by readBlockMemTest()"<<endl; 


   unsigned long dataFromFFv1[memLength]={0};
//    if(ffv1Debug->ffv1BlockRead(dataFromFFv1, memLength))
//      cout<<"error reported by ffv1BlockRead()"<<endl; 

  unsigned long dataToFFv1[memLength]={0};
  for(unsigned long i=0; i<memLength; i++)
    dataToFFv1[i]=rand();

  if(ffv1Debug->ffv1BlockWrite(dataToFFv1, memLength))
    cout<<"error reported by ffv1BlockWrite()"<<endl; 
  

    for(unsigned long i=0; i<memLength; i++)
      {
        int retVal=ffv1Debug->ffv1SingleRead(&dataFromFFv1[i],i);
        if(retVal)
  	cout<<"ffv1SingleRead() reported an error"<<endl;
        cout<<"data from memory location ["<<i<<"] = "<<dataFromFFv1[i]<<endl;
      }

    ffv1Debug->checkData(dataToFFv1, dataFromFFv1, memLength);
  
  delete ffv1Debug;
  return 0;
}



int getBaseAddress(unsigned long * pBaseAddr)
{
  ifstream baseAddressFile;
  baseAddressFile.open("FFv1BaseAddress.dat");
  // baseAddressFile.open("/home/xdaq/TriDAS/daq/fed_debug/src/linux/x86/FFv1BaseAddress.dat");
  if(!baseAddressFile.is_open())
    {
      // cout<<"file /home/xdaq/TriDAS/daq/fed_debug/src/linux/x86/FFv1BaseAddress.dat not opened"<<endl;
      cout<<"file FFv1BaseAddress.dat not opened"<<endl;
      return 1;
    }
  baseAddressFile>>hex>>(*pBaseAddr);
  baseAddressFile.close();
  return 0;
}
 

