#include <iostream>
#include "FFv1Object.hh"
using namespace std;
int getBaseAddress(unsigned long *);

unsigned int opto_data;
int scope_len;
unsigned int readback_data;
int fe_id = 0;
int fe_chan = 1;
int dac_offset = 64;
// dac chan 1 feeds fe chan 12 !
int dac_chan_map[12] = { 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1 };
unsigned int pattern_type;
unsigned int pattern;
int temp;
int delay_chip;
int coarse, fine;
unsigned int threshold;
int be_cmd, be_rw;
unsigned int be_data;
int fe_cmd, fe_rw;
unsigned int fe_data;
int fe_id_tmp;
int clock_select;
int trigger_select;
int num_trigs = 1;
int ped_mode = 0;
int spy_cmd;
int spy_bits;
int spy_offset;
int eprom_cmd;
int eprom_mode;
unsigned int eprom_addr;
unsigned int eprom_data;
unsigned int eprom_quad;
unsigned int eprom_ser;
unsigned int eprom_fedid;
int lm82_cmd;
int lm82_nr;
int lm82_reg;
unsigned int lm82_data;
int adm1025_cmd;
int adm1025_reg;
unsigned int adm1025_data;
int ttc_cmd;
unsigned int ttc_addr;
unsigned int ttc_data;
unsigned int ttc_bxctr, ttc_evtctr;
unsigned int ttc_skew;
unsigned int ttc_skew_start, ttc_skew_stop;
int bram;
int nwords;
unsigned int mem_start;
int dac_cmd;
int dac_chan;
unsigned int dac_value;
int blt_flag;
int readout_source;
int event_format;
int event_stop;
int event_nr;
int endian_swap;
int ace_cmd;
unsigned int ace_reg;
unsigned int ace_data;
unsigned int ace_lba;
unsigned int ace_sectors;
unsigned int ace_clusters;
unsigned int ace_file;
unsigned int ace_write;
unsigned int ace_test;
unsigned int ace_rev;

unsigned int ttcvi_cmd;
unsigned int ttcvi_trig;
unsigned int ttcvi_rate;
unsigned int ttcvi_orbit;
unsigned int ttcvi_bgo_nr;
unsigned int ttcvi_bgo_reg;
unsigned int ttcvi_bgo_delay;
unsigned int ttcvi_bgo_duration;
unsigned int ttcvi_bgo_enable;
unsigned int ttcvi_bgo_sync;
unsigned int ttcvi_bgo_single;
unsigned int ttcvi_bgo_fifo;
unsigned int ttcvi_bgo_format;
unsigned int ttcvi_ctr;
unsigned int ttcvi_async_type;
unsigned long ttcvi_short_cmd;
unsigned long ttcvi_long_ttcaddr;
unsigned long ttcvi_long_subaddr;
unsigned long ttcvi_long_data;

	time_t now;
	struct tm *date;
	char start_date_str[40];
	char stop_date_str[40];



// hacked by jac 01.05.2003

//int main(void)
int main(int argc, char *argv[])
{
  unsigned int crate_nr = 0; // default is test crate
  unsigned int slot_nr = 999;
  unsigned int ser_nr = 0;
  unsigned int fed_ver = 1;

  const unsigned long memLength=0x40;

  cout << "Clunky Software presents..." << '\n';

  if (argc > 1) {
    cout << argv[1];
    for (int i = 2; i != argc; i++)
      cout << " " << argv[i];
  }
  cout << endl;

  if (argc > 1) {
    crate_nr = atoi(argv[1]);
  }
  if (argc > 2) {
    slot_nr = atoi(argv[2]);
  }

  unsigned long baseAddress=0;
  if (slot_nr == 999) { // get default base address from file
    if(getBaseAddress(&baseAddress)) {
	cout<<"base address not found"<<endl;
	return -1;
    }
  }
  else {
    baseAddress = slot_nr * 0x10000;
  }

  printf("FED:\n");
  printf("    Crate Nr = %d \n", crate_nr);
  printf("     Slot Nr = %d \n", slot_nr);
  printf("Base Address = $%08x \n", baseAddress);

  // string addressTableLocation="/home/xdaq/TriDAS/daq/fed_debug/src/linux/x86/FFv1AddressTable.dat";
  string addressTableLocation="FFv1AddressTable.dat";  

  FFv1Object * ffv1Debug= new FFv1Object(crate_nr, baseAddress,addressTableLocation);
  string ffv1AddressItem="FFv1BaseItemSingleDataNonPriv";

  cout<<"FED base address = 0x"<<hex<<baseAddress<<endl;

  ffv1Debug->ReadSerNrEPROM(&ser_nr, &eprom_fedid, 1);

  TTCvi_Card = TTCvi_Card_Base - baseAddress; // use slot nr to calculate ttcvi base relative to FED for HAL
  cout<<"TTCvi relative base address = 0x"<<hex<<TTCvi_Card<<endl;



//    {
//      unsigned long  mydata = 0;
//      unsigned long offset = 0;
//          int retVal=ffv1Debug->ffv1SingleRead(&mydata, offset);
//          if(retVal)
//    	cout<<"ffv1SingleRead() reported an error"<<endl;
//          cout<<"data from memory location [0] = "<<mydata<<endl;
//    }
//  	return 0;

  // output file

  char file_name_str[60] = "fed9u_";
	{		
		/* Convert it to a broken-down time.	*/
		time( &now );
		date = localtime( &now );

		/* Convert that to a string.		*/
		/* strftime( start_date_str, 40, "%a_%d_%b_%Y_%H%M%S", date ); */
		strftime( start_date_str, 40, "%Y_%m_%d_%H%M%S", date );

		printf( "Run Start time : %s\n", start_date_str );
       		printf( "\n" );
	}
	
	/* output file */
	strcat( file_name_str, start_date_str );

	printf( "Output file_name_str = \"%s\"\n", file_name_str );

	output_file = fopen( file_name_str, "w" );

	if ( output_file == NULL )
	{
		printf( "*** ERROR => Couldn't open output file name = %s\n", file_name_str );
		return -1;
	}
	else
	{
		printf( "INFO => Output file opened with pointer = %p\n", output_file );
	}

	// fprintf(output_file, "Test output file \n");


	// pick some sensible defaults for fibre frame thresholds and pedestals
	for (int i=0; i<chan_max; i++) {
	    fibre_thresh_calc[i] = 16;
	    fibre_ped_calc[i] = 0;
	}

  for (;;) {

  int choice = ffv1Debug->userPrompt(crate_nr, baseAddress, ser_nr);
  unsigned int num_secs = 0;

   switch (choice) {
      case 'a' :
	cout << "Please enter OptoRx control bits (Hex X7:X0): ";
	cin >> hex >> opto_data;
	ffv1Debug->SetOptoRx(fe_id, opto_data);
	break;
   case 'b' :
     cout << "Temperature LM82s (0 = Display All ; 1 = Set Register) : ";
     cin >> dec >> lm82_cmd;
     if (lm82_cmd == 1) {
       cout << "Enter Device Nr (0-7 FE FPGAs ; 8 = BE FPGA ; 9 = VME FPGA) ";
       cin >> dec >> lm82_nr;
       cout << "Enter Register Nr (hex) ";
       cin >> hex >> lm82_reg;
       cout << "Enter Data (hex) ";
       cin >> hex >> lm82_data;
       ffv1Debug->WriteLM82(lm82_nr, lm82_reg, &lm82_data, 1);
     }
     else {
       ffv1Debug->DisplayTemperatures(1);
     }    
     break;
   case 'c' :
	cout << "Set Clock Skews : ";
	cout << "Please enter Delay Chip (0-2) or 3 for ALL: ";
	cin >> dec >> delay_chip;
	cout << "Please enter Coarse delay (0-15): ";
	cin >> dec >> coarse;
	cout << "Please enter Fine delay (0-31): ";
	cin >> dec >> fine;
	ffv1Debug->SetClockSkew(fe_id, delay_chip, 0, coarse, fine);
	break;
      case 'd' :
	cout << "Select TrimDAC Cmd : (1 = Set value ; 2 = Reset ; 3 = Shutdown) : ";
	cin >> dec >> dac_cmd;
	if (dac_cmd == 2) {
	  ffv1Debug->ResetTrimDAC(fe_id, 1);
	}
	else if (dac_cmd == 3) {
	  ffv1Debug->ShutdownTrimDAC(fe_id, 1);
	}
	else {
	  cout << "Enter Chan nr : (0-11 ; 12 = ALL 12) : ";
	  cin >> dec >> dac_chan;
	  cout << "Enter value : (0-255) : ";
	  cin >> dec >> dac_value;
	  ffv1Debug->WriteTrimDAC(fe_id, dac_chan, &dac_value, 1);
	}
	break;
   case 'e' :
     cout << "Serial EPROM (0 = Display ; 1 = Single Read ; 2 = Single Write ; 3 = Enable Write ; 4 = Read FED Ser nr ; 5 = Load FED Ser nr) : ";
     cin >> dec >> eprom_cmd;
     if (eprom_cmd == 0) {
       cout << "Enter Quadrant Nr  (0 = 0-511 ; 1 = 511-1023 ; 2 = 1024-1535 ; 3 = 1536-2047) ";
       cin >> dec >> eprom_quad;
       ffv1Debug->DumpSerialEPROM(eprom_quad, 1);
     }
     else if (eprom_cmd == 3) {
       cout << "Enter Write Protection Mode  (0 = None ; 1 = Upper Quarter ; 2 = Upper Half ; 3 = All ; 4 = WPEN & Upper Half) ";
       cin >> dec >> eprom_mode;
       ffv1Debug->EnableWriteEPROM(eprom_mode, 1);
     }
     else if (eprom_cmd == 1 || eprom_cmd == 2) {
       cout << "Enter EPROM Byte Address ( 0 - 2047) : ";
       cin >> dec >> eprom_addr;
       if (eprom_cmd == 2) {
       cout << "Enter Data (0-ff) $ : ";
       cin >> hex >> eprom_data;
	 ffv1Debug->WriteSerialEPROM(eprom_addr, &eprom_data, 2);
       }
       else {
 	 ffv1Debug->ReadSerialEPROM(eprom_addr, &eprom_data, 2);
	 printf("Serial EPROM Data = $%02x \n", eprom_data);
      }
     }
     else if (eprom_cmd == 4) {
       ffv1Debug->ReadSerNrEPROM(&eprom_ser, &eprom_fedid, 1);
       printf("FED ID = $ %08x \n", eprom_fedid);
       printf("FED Serial Nr = %03d \n", eprom_ser);
      }
     else if (eprom_cmd == 5) {
       cout << "Enter FED Serial Nr (dec) ";
       cin >> dec >> eprom_ser;
       cout << "Enter FED Board Version (1 or 2) ";
       cin >> dec >> fed_ver; 
       ffv1Debug->WriteSerNrEPROM(eprom_ser, fed_ver, 1);
     }
      
     break;
      case 'f' :
	cout << "SystemACE cmds (0 = Display ; 1 = Write ; 2 = Single Read ; 3 = Access CF Contents ; 4 = Reload FPGAs ; 5 = Reset ACE) : ";
	cin >> dec >> ace_cmd;

      ffv1Debug->WordModeSystemACE(2); // must be in WORD mode before first access

      if (ace_cmd == 0) {
 	ffv1Debug->DisplaySystemACE(1);
      }
      else if (ace_cmd == 1) {
	cout << "Enter SystemACE Reg Nr (WORD $00 - $3f) Hex : ";
	cin >> hex >> ace_reg;
	cout << "Enter Value ($0-$ffff) Hex : ";
	cin >> hex >> ace_data;
 	ffv1Debug->WriteSystemACE(ace_reg, ace_data, 1);
      }
      else if (ace_cmd == 2) {
	cout << "Enter SystemACE Reg Nr (WORD $00 - $3f) Hex : ";
	cin >> hex >> ace_reg;
	ffv1Debug->ReadSystemACE(ace_reg, &ace_data, 1);
	printf("Reg nr $%02x ; Value = $%02x \n", ace_reg, ace_data);
      }
      else if (ace_cmd == 3) {
	// if reading more than one cluster (256 sectors) must read entire clusters.
	// if reading just one cluster can read any number of sectors
	cout << "Enter access type : (Read = 0 ; Write = 1) : ";
	cin >> hex >> ace_write;

	cout << "Enter Starting Logical Block Address ($00 - $ffffff) Hex : ";
	cin >> hex >> ace_lba;
	cout << "Enter Number of Clusters Dec : ";
	cin >> dec >> ace_clusters;
	if (ace_clusters > 512) {
	  ace_clusters = 512;
	  printf("WARNING: Max nr clusters for 64MB CF is 512\n");
	}
//  	if (ace_clusters == 1) {
	  cout << "Enter Number of Sectors Dec : ";
	  cin >> dec >> ace_sectors;
//  	}
//  	else {
//  	  ace_sectors = 256;  // max nr sectors per cluster
//  	}
	if (ace_write == 0) {
	  cout << "Save contents to file (0 = No ; 1 = Yes) : ";
	  cin >> dec >> ace_file;
	}
	else {
	  ace_file = 0;
	}
	cout << "Simulate hardware access (0 = No ; 1 = Yes) : ";
        cin >> dec >> ace_test;

	unsigned int verbosity = 2;
	if (ace_test == 1) verbosity = 2;

	for (unsigned int i=0; i<ace_clusters; i++) {
	  if (ace_write == 1) {
	    printf("Writing %d sectors to CF @ LBA $%04x cluster %d (end LBA = $%04x) \n",
		   ace_sectors, ace_lba, i,  (ace_clusters-1) * 256 + ace_sectors - 1);
	  }
	  else {
	    printf("Reading %d sectors from CF @ LBA $%04x cluster %d (end LBA = $%04x) \n",
		   ace_sectors, ace_lba, i,  (ace_clusters-1) * 256 + ace_sectors - 1);
	  }
	  ffv1Debug->AccessCFSectorSystemACE(ace_lba, ace_sectors, verbosity, ace_file, ace_write, ace_test, i);
	  ace_lba += 256;  // each lba points to a sector (512 byte) location
//  	  usleep(5000000);
	}
	printf("\nFinished Accessing Compact Flash Card contents\n");
      }
      else if (ace_cmd == 4) {
	cout << "Enter ACE File Rev nr (0-7) : ";
	cin >> dec >> ace_rev;
	ffv1Debug->ReloadFPGASystemACE(ace_rev, 2);
      }
      else if (ace_cmd == 5) {
	ffv1Debug->ResetSystemACE(2);
      }


//  	cout << "Please enter Frame Finding Threshold (same for ALL 12 fibres) (0-31) {x32 steps}: ";
//  	cin >> dec >> threshold;
//  	ffv1Debug->SetFrameThresholds(fe_id, threshold);

	break;
    case 'g' :
      cout << "TTCrx cmds (0 = Display ; 1 = Write ; 2 = I2C Reset ; 3 = TTCReset ; 4 = BX ctrs ; 5 = Set Fine Skew ; 6 Scan Fine Skews) : ";
      cin >> dec >> ttc_cmd;
      if (ttc_cmd == 2) {
	ffv1Debug->ResetTTCrx(1);  // reset cmd via I2C
      }
      else if (ttc_cmd == 3) {
	ttc_data = 0;
	ffv1Debug->BECommand(11, 0, &ttc_data, 2); // reset via TTCreset line
      }
      else if (ttc_cmd == 1) {
	cout << "Enter TTCrx Reg Nr (0-29) : ";
	cin >> dec >> ttc_addr;
	cout << "Enter Value (0-ff) Hex : ";
	cin >> hex >> ttc_data;
	ffv1Debug->WriteTTCrx(ttc_addr, &ttc_data, 1);
      }
      else if (ttc_cmd == 4) {
	for (int i=0 ; i<20; i++) {
	  ffv1Debug->ReadTTCrxBXCtr(1, &ttc_bxctr, &ttc_evtctr);
	  printf("TTCrx : EVT ctr = %d ; BX ctr = %d \n", ttc_evtctr, ttc_bxctr);
	}
      }
      else if (ttc_cmd == 5) {
	cout << "Enter Fine Skew 1 (0-239 steps of 104 psec) : ";
	cin >> dec >> ttc_skew;
	ffv1Debug->WriteTTCrxFineSkew1(&ttc_skew, 1);
      }
      else if (ttc_cmd == 6) {
	cout << "Enter Start Skew value (0-239 steps of 104 psec) : ";
	cin >> dec >> ttc_skew_start;
	cout << "Enter Stop Skew value (0-239 steps of 104 psec) : ";
	cin >> dec >> ttc_skew_stop;
	if (ttc_skew_start >= 0 && ttc_skew_start < 240 && ttc_skew_stop >= 0 && ttc_skew_stop < 240 && ttc_skew_stop > ttc_skew_start) {
	  for (int i=ttc_skew_start; i<ttc_skew_stop+1; i++) {
	    ttc_skew = i;
	    ffv1Debug->WriteTTCrxFineSkew1(&ttc_skew, 1);
	  }
	}
	else {
	  printf("Sorry illegal skew values \n");
	}
      }
      else {
	ffv1Debug->DisplayTTCrx(0);
      }
      break;
   case 'h' :
     cout << "BE FPGA; Please enter command code (dec): ";
     cin >> dec >> be_cmd;
     cout << "Enter 0 for Write or 1 for Read: ";
     cin >> dec >> be_rw;
     if (be_rw == 0)
       {
	 cout << "Writing: Please enter data (hex): ";
	 cin >> hex >> be_data;
       }

     ffv1Debug->BECommand(be_cmd, be_rw, &be_data, 2);
     break;
    case 'i' :
      {
	int run_type = 0;
//  	char *run_type_str[2] = {"Scope Mode", "Frame Finding Mode"};

      // set up all fpga settings in one go...

	cout << "Please enter Run Type" << '\n';
	cout << "(1 = Scope Mode ; 2 = FF Mode/VIRGIN RAW ; 3 = FF Mode/ZERO SUPPRESSED ; 4 = FF Mode/PROCESSED RAW): ";
	cin >> dec >> run_type;
       
     cout << "Please Enter Clock Source (1=Oscillator ; 2=TTC ; 4=BackPlane) :";
     cin >> dec >> clock_select;
     // this also resets FED so must be first operation
     ffv1Debug->SelectClock(clock_select, 2);
 
     cout << "Please Enter Trigger Source (1=TTC ; 2=BackPlane ; 4=Software) :";
     cin >> dec >> trigger_select;

	if (run_type == 1)
	  {
	    cout << "Setting up FED for a Scope Run: ";

	// for scope mode...  // 8 x FE FPGA
	fe_id_tmp = fe_id;
	fe_id = 15; // broadcast
	ffv1Debug->SetRunMode(fe_id, run_type); // set all fe to scope mode
	cout << "Please enter Scope Mode length for all FE's (dec): ";
	cin >> dec >> scope_len;
	ffv1Debug->SetScopeLength(fe_id, scope_len);
	fe_id = fe_id_tmp; // restore current setting

	  }
	else if (run_type == 2)
	  {
	    cout << "Setting up FED for a Frame Finding Run (with RAW Data): " << '\n';

	// for frame finding mode...  // 8 x FE FPGA
	fe_id_tmp = fe_id;
	fe_id = 15; // broadcast
	ffv1Debug->SetRunMode(fe_id, run_type); // set all fe to frame finding mode
	fe_id = fe_id_tmp; // restore current setting

	  }
	else if (run_type == 3)
	  {
	    cout << "Setting up FED for a Frame Finding Run (with ZERO Suppressed Data): " << '\n';

	// for frame finding mode...  // 8 x FE FPGA
	fe_id_tmp = fe_id;
	fe_id = 15; // broadcast
	ffv1Debug->SetRunMode(fe_id, run_type); // set all fe to frame finding mode
	fe_id = fe_id_tmp; // restore current setting
  }
	else if (run_type == 4)
	  {
	    cout << "Setting up FED for a Frame Finding Run (with Processed RAW Data): " << '\n';

	// for frame finding mode...  // 8 x FE FPGA
	fe_id_tmp = fe_id;
	fe_id = 15; // broadcast
	ffv1Debug->SetRunMode(fe_id, run_type); // set all fe to frame finding mode
	fe_id = fe_id_tmp; // restore current setting
  }
	else
	  {
	    cout << "Sorry Illegal Run Type: ";
	    break;
	  }

//  	if (run_type == 2 || run_type == 3 || run_type == 4) {
	{
  	
//      ffv1Debug->EnableAPVChans(fe_id, 0); // Enable ALL 24 channels (data passed is ignored for now)
//  	cout << "All 24 APV channels are now enabled:" << '\n';

//          cout << "Please enter Frame Finding Threshold for all 96 channels (0-31) {x32 steps}: " << '\n';
//    	cin >> dec >> threshold;
//    	ffv1Debug->SetFrameThresholds(15, threshold);

	printf("Loading Frame Thresholds with previously calculated values from scope mode run with external triggers");
	ffv1Debug->LoadFrameThresholds(1);

	}

       ffv1Debug->SetClockSkew(15, 3, 0, 0, 0);
	cout << "Setting all 96 channels Clock skews coarse = 0 ; fine = 0" << '\n';

	// reset trimDACs
	unsigned int dac_reset = 0x2000;
	ffv1Debug->FECommand(15, 6, 0, &dac_reset, 2);
         cout << "Resetting all 96 channels TrimDACs" << '\n';

        cout << "Please enter OptoRx setting (0 - 0xff) Hex: " << '\n';
  	cin >> hex >> opto_data;
  	// ffv1Debug->SetOptoRx(15, opto_data);
	ffv1Debug->FECommand(15, 0x16, 0, &opto_data, 2);
        cout << "Setting all 96 channels OptoRX offset = $" << hex << opto_data << '\n';

	printf("Setting up BE FPGA.. \n");
	ffv1Debug->InitBE(run_type, trigger_select); // BE FPGA

      }
      break;
   case 'j':
     ffv1Debug->DisplayBEStatus(1);
     break;
     case 'k' :
//         {
//  	 int num_triggers = 0;
//  	 int num_microsecs = 0;

//         cout << "Test Frame Finding " << '\n';

//  	cout << "Nr Triggers to send (dec):";
//  	cin >> dec >> num_triggers;
//  	cout << "Nr Microsecs to send APV Frames (dec):";
//  	cin >> dec >> num_microsecs;

//         ffv1Debug->TestFrameFinding(num_triggers, num_microsecs);
//         }
     cout << "ADM1025 Voltage Monitor (0 = Display ; 1 = Set Register ; 2 = Dump Registers ; 3 Set Limits) : ";
     cin >> dec >> adm1025_cmd;
     if (adm1025_cmd == 1) {
       cout << "Enter Register Nr (hex) ";
       cin >> hex >> adm1025_reg;
       cout << "Enter Data (hex) ";
       cin >> hex >> adm1025_data;
       ffv1Debug->WriteADM1025(adm1025_reg, adm1025_data, 1);
     }
     else if (adm1025_cmd == 2) {
      ffv1Debug->WriteADM1025(0x40, 0x01, 1);  // enable monitoring
      ffv1Debug->DisplayADM1025(3, 1);
     }    
     else if (adm1025_cmd == 3) {
       ffv1Debug->WriteADM1025(0x2b, 0xc8, 1);  // 2.5V high
       ffv1Debug->WriteADM1025(0x2c, 0xb8, 1);  // 2.5V low
       ffv1Debug->WriteADM1025(0x2d, 0x88, 1);  // VCCP = 1.5V high
       ffv1Debug->WriteADM1025(0x2e, 0x78, 1);  // VCCP = 1.5V low
       ffv1Debug->WriteADM1025(0x2f, 0xc8, 1);  // 3.3V high
       ffv1Debug->WriteADM1025(0x30, 0xb8, 1);  // 3.3V low
       ffv1Debug->WriteADM1025(0x31, 0xc8, 1);  // 5V high
       ffv1Debug->WriteADM1025(0x32, 0xb8, 1);  // 5V low
       ffv1Debug->WriteADM1025(0x33, 0xc4, 1);  // 12V high
       ffv1Debug->WriteADM1025(0x34, 0xbd, 1);  // 12V low
       ffv1Debug->WriteADM1025(0x35, 0xc8, 1);  // VCC = 3.3V high
       ffv1Debug->WriteADM1025(0x36, 0xb8, 1);  // VCC = 3.3V low
       ffv1Debug->WriteADM1025(0x37, 0x0, 1);  // Remote Temp hign
       ffv1Debug->WriteADM1025(0x38, 0x0, 1);  // Remote Temp low
       ffv1Debug->WriteADM1025(0x39, 0x30, 1);  // Local Temp hign
       ffv1Debug->WriteADM1025(0x3a, 0x10, 1);  // Local Temp low
         } 
     else {
      ffv1Debug->WriteADM1025(0x40, 0x01, 1);  // enable monitoring
      ffv1Debug->DisplayADM1025(0, 1);
     }    
     break;

   case 'l' :
     cout << "Please Enter Loading mode (0=Normal; 1=Single serial cmds ; 2=Multiple serial cmds ; 3=Multiple Serial cmds and BLT32 ; 5=Zero) :";
     cin >> dec >> ped_mode;
     ffv1Debug->LoadFibrePedestals(ped_mode, 2);
     break;
    case 'm':
      {
	int berr = 0;
	unsigned int fedmap[22], fedbase[22];
	FFv1Object * ffv1Debug_temp;
	unsigned int dummy1;
	unsigned long dummy2;

	for (int slot=1; slot<22; slot++) {
	  fedmap[slot] = 0;
	  ffv1Debug_temp = new FFv1Object(crate_nr, slot * 0x10000, addressTableLocation);
	  berr = ffv1Debug_temp->ffv1SingleRead(&dummy2, 0); // check for FED in slot
	  if (berr != -1) {
	    ffv1Debug_temp->ReadSerNrEPROM(&fedmap[slot], &dummy1, 1);
	    fedbase[slot] = slot * 0x10000;
	  }
	}
	printf("\n\nCrate nr = %02d \n", crate_nr);
	printf("Slot \tFED\n");
	printf("\tSer Nr \tBase Addr $ \n");
	for (int slot=1; slot<22; slot++) {
	  printf("%02d", slot);
	  if (fedmap[slot] != 0) {
	      printf("\t %03d \t$%08x\n", fedmap[slot], fedbase[slot]);
	  }
	  else {
	    printf("\t ---\n");
	  }
	}
      }
//       ffv1Debug->ReadOptoRx(fe_id, &readback_data);
//       cout << "Chip id = " << fe_id << " OptoRx control bits (Hex X7:0) = " << hex << readback_data << '\n';
     break;
   case 'n':
     ffv1Debug->DisplayFibrePedestals(2);
     break;
   case 'o':
     fe_id_tmp = fe_id;
     cout << "FE FPGA; Please enter FPGA nr (NB 0-7, 15 for all): ";
     cin >> dec >> fe_id;
     cout << "FE FPGA; Please enter command code (dec): ";
     cin >> dec >> fe_cmd;
     cout << "Enter 0 for Write or 1 for Read: ";
     cin >> dec >> fe_rw;
     if (fe_rw == 0)
       {
	 cout << "Writing: Please enter data (hex): ";
	 cin >> hex >> fe_data;
       }

     ffv1Debug->FECommand(fe_id, fe_cmd, fe_rw, &fe_data, 2);
     fe_id = fe_id_tmp; // restore current setting
     break;
   case 'p' :
     ffv1Debug->DisplayFEStatus(1);
     break;
   case 'q' :
     ffv1Debug->DisplayFirmwareVersions(stdout, 1);
     break;
   case 'r' :
     ffv1Debug->DisplayFrameThresholds(1);
     break;
   case 's' :
     cout << "Which Spy Command (7 = ARM ; 8 = FIRE ; 6 = DELAY FIRMWARE ID) : ";
     cin >> dec >> spy_cmd;
     cout << "Please enter Delay Chip (0-2 ; 3 for ALL [but only for ARM]) : ";
     cin >> dec >> delay_chip;
     if (spy_cmd == FED_SPY_FIRE || spy_cmd == FED_DELAY_ID) {
       cout << "How many bits to read back ? (0 to 41000) : ";
       cin >> dec >> spy_bits;

       ffv1Debug->FillMemory(FED_Serial_BRAM, 2048/4, 0, 0xffffffff, 0);  // pre-fill serial memory
       printf("Pre-fill Serial Memory with $ffffffff \n");

       ffv1Debug->SpyCommand(fe_id, delay_chip, spy_cmd, spy_bits);

       //      ffv1Debug->SpyDisplay(0);
     }
     else if (spy_cmd == FED_SPY_ARM) {
       ffv1Debug->SpyArm(fe_id, delay_chip);
     }
     break;
   case 't' :
     ffv1Debug->SendSWTrig(0);
     // clear readout csr to allow next trigger
     usleep(10000); // wait for vme buffer to fill with event
     ffv1Debug->ClearReadoutCSR(2);
     break;
   case 'u':
     cout << "Which Block RAM (1 = Serial Memory ; 2 = VME Buffer ; 3 = DPM Test Card) : ";
     cin >> dec >> bram;
     cout << "Transfer type? (0=Normal ; 1 = BLT32 ; 2 = Turbo BLT32) ";
     cin >> dec >> blt_flag;
     cout << "How many (32 bit) words to readout ? ";
     cin >> dec >> nwords;
     if (nwords > 8*1024) nwords = 8*1024; // max mem is 32 Kbytes
     if (bram == 1) {
       mem_start = FED_Serial_BRAM;
     }
     else if (bram == 3) {
       mem_start = DPM_Test_Card;
     }
     else {
       mem_start = FED_Readout_BRAM;
     }
     if (nwords == 0) nwords = 1024*2;
     ffv1Debug->DumpMemory(mem_start, nwords, blt_flag);

    break;
   case 'v':
     cout << "Which Block RAM (1 = Serial Memory ; 2 = VME Buffer ; 3 = DPM Test Card) : ";
     cin >> dec >> bram;
     cout << "Transfer type? (0=Normal ; 1 = BLT32 ; 2 = Turbo BLT32) ";
     cin >> dec >> blt_flag;
     cout << "How many (32 bit) words to fill? ";
     cin >> dec >> nwords;
     if (nwords > 8*1024) nwords = 8*1024; // max mem is 32 Kbytes
     cout << "Pattern type? (0=Single Value ; 1 = Sequence) ";
     cin >> dec >> pattern_type;
     if (pattern_type == 1) {
     }
     else {
       cout << "Please enter Pattern to fill VME Memory (Hex 0-fffffff) : ";
       cin >> hex >> pattern;
     }
     if (bram == 1) {
       mem_start = FED_Serial_BRAM;
     }
     else if (bram == 3) {
       mem_start = DPM_Test_Card;
     }
     else {
       mem_start = FED_Readout_BRAM;
     }
     if (nwords == 0) nwords = 1024*2;
     ffv1Debug->FillMemory(mem_start, nwords, pattern_type, pattern, blt_flag);

     break;
   case 'w':
     cout << "Please enter FE FPGA id (NB 0-7 ; 15 for Broadcast): ";
     cin >> dec >> fe_id;
     break;
   case 'x' :
     return 0;
     break;
   case 'y' :
     ffv1Debug->DisplayVMEStatus(2);
     break;
   case 'z' :
     cout << "Test readout from VME or File? (0 = VME ; 1 = File (readout_file.txt) >> ";
     cin >> dec >> readout_source;
     if (readout_source == 1) {
       cout << "Do an Endian swap ? (0 = No ; 1 = Yes) >> ";
       cin >> dec >> endian_swap;
       cout << "What type of Event Format to check? (1 = Scope Mode ; 2 = Zero Suppressed ; 3 = S-Link Pattern) >> ";
       cin >> dec >> event_format;
       cout << "Event Nr in File >> ";
       cin >> dec >> event_nr;
       ffv1Debug->TestReadoutFromFile(1, event_format, event_nr, endian_swap);
      }
     else {
       cout << "How many software triggers ? (0 = wait for external triggers ; -1 = send s/w for nsecs) >> ";
       cin >> dec >> num_trigs;
       if (num_trigs == 0) {
	 cout << "How many seconds to wait for external hardware triggers ? >> ";
	 cin >> dec >> num_secs;
       }
       else if (num_trigs == -1) {
	 cout << "How many seconds to run with software triggers ? >> ";
	 cin >> dec >> num_secs;
       }
       cout << "What type of Event Format to check? (1 = Scope Mode ; 2 = Zero Suppressed ; 3 = S-Link Pattern) >> ";
       cin >> dec >> event_format;
       cout << "Do you want to Stop test at the first error? (1 = Yes ; 2 = No) >> ";
       cin >> dec >> event_stop;
       ffv1Debug->ReadSerNrEPROM(&eprom_ser, &eprom_fedid, 1);
       printf("FED ID = $ %08x \n", eprom_fedid);
       printf("FED Serial Nr = %03d \n", eprom_ser);
       ffv1Debug->DisplayFEStatus(1);
       ffv1Debug->DisplayBEStatus(1);
       ffv1Debug->DisplayClockStatus(1);
       ffv1Debug->TestReadout(num_trigs, num_secs, 1, event_format, event_stop);
     }
     break;
   case '1' :
     ffv1Debug->ResetFED(2);
     break;
   case '2' :
     cout << "Please Enter New Clock Selection (1=Osc ; 2=TTC ; 4=BkPlane) :";
     cin >> dec >> clock_select;
     ffv1Debug->SelectClock(clock_select, 2);
     break;
   case '3' :
     // just s/w trigger, without clear of readout csr
     ffv1Debug->SendSWTrig(0);
     break;
   case '4' :
     // clear of readout csr
     ffv1Debug->ClearReadoutCSR(2);
     break;
   case '6' :
     // external TTCvi card commands
     cout << "TTCvi cmd (0 = Display; 1 = Set Defaults; 2 = Send Trig ; 3 = Sel Trig ; 4 = Sel Orbit ; 5 = Chan B cmds ; 6 = Reset Ctrs ; 7 = Select Ctr ; 8 = VME Async ChanB ; 9 = Reset Module ; 10 = BX orbit resets) : ";
     cin >> dec >> ttcvi_cmd;
     if (ttcvi_cmd == 0) {
       ffv1Debug->TTCvi_Display(TTCvi_Card, 2);
     }
     else if (ttcvi_cmd == 1) {
       //       ffv1Debug->TTCvi_Set_Defaults(TTCvi_Card, 2);
     }
     else if (ttcvi_cmd == 2) {
       ffv1Debug->TTCvi_SW_Trigger(TTCvi_Card, 2);
     }
     else if (ttcvi_cmd == 3) {
       cout << "TTCvi : Trigger Source (0 = Random; 1 = Calibr; 2 = VME cmd; 3 = L1A<0>; 4 = L1A<1>; 5 = L1A<2>; 6 = L1A<3>; 7 = Disable ) : ";
       cin >> dec >> ttcvi_trig;
       if (ttcvi_trig == 0 ) {
	 cout << "TTCvi : Random Rate (0 = 1 Hz ; 1 = 100 Hz ; 2 = 1 kHz ; 3 = 5 kHz ; 4 = 10 kHz ; 5 = 25 kHz ; 6 = 50 kHz ; 7 = 100 kHz) : ";
	 cin >> dec >> ttcvi_rate;
       }
       ffv1Debug->TTCvi_Select_Trigger(TTCvi_Card, ttcvi_trig, ttcvi_rate, 2);
     }
     else if (ttcvi_cmd == 4) {
       // differs from TTCvi register description?
       cout << "TTCvi : Orbit signal (1 = Internal; 0 = External) : ";
       cin >> dec >> ttcvi_orbit;
       ffv1Debug->TTCvi_Select_Orbit(TTCvi_Card, ttcvi_orbit, 2);
     }
     else if (ttcvi_cmd == 5) {
       cout << "TTCvi : Chan B : Select B-Go  (0 - 3) : ";
       cin >> dec >> ttcvi_bgo_nr;
       cout << "TTCvi : Chan B : Select cmd (0 = Inhibit ; 1 = Mode ; 2 = Data ; 3 = Write ; 4 = Reset FIFO) : ";
       cin >> dec >> ttcvi_bgo_reg;
       if (ttcvi_bgo_reg == 0) {
        cout << "TTCvi : Enter BGO Inhibit Delay (0-2047) : ";
	cin >> dec >> ttcvi_bgo_delay;
        cout << "TTCvi : Enter BGO Inhibit Duration (0-255) : ";
	cin >> dec >> ttcvi_bgo_duration;
	ffv1Debug->TTCvi_BGO_Inhibit(TTCvi_Card, ttcvi_bgo_nr, ttcvi_bgo_delay, ttcvi_bgo_duration, 2);
      }
      else if (ttcvi_bgo_reg == 1) {
        cout << "TTCvi : BGO : Front Panel Input (0 = Enable; 1 = Disable) : ";
	cin >> dec >> ttcvi_bgo_enable;
        cout << "TTCvi : BGO : Synch (0 = Synchronous; 1 = Asynchronous) : ";
	cin >> dec >> ttcvi_bgo_sync;
        cout << "TTCvi : BGO : Single (0 = Single ; 1 = Repetitive) : ";
	cin >> dec >> ttcvi_bgo_single;
        cout << "TTCvi : BGO : FIFO (0 = Start not Empty; 1 = Don't look at FIFO) : ";
	cin >> dec >> ttcvi_bgo_fifo;
	ffv1Debug->TTCvi_BGO_Mode(TTCvi_Card, ttcvi_bgo_nr, ttcvi_bgo_enable, ttcvi_bgo_sync, ttcvi_bgo_single, ttcvi_bgo_fifo, 2);
      }
      else if (ttcvi_bgo_reg == 2) {
        cout << "TTCvi : BGO : FIFO Command Format (0 = Short ; 1 = Long) ";
	cin >> dec >> ttcvi_bgo_format;
	ffv1Debug->TTCvi_BGO_Data(TTCvi_Card, ttcvi_bgo_nr, ttcvi_bgo_format, 2);
      }
      else if (ttcvi_bgo_reg == 3) {
	ffv1Debug->TTCvi_BGO_Write(TTCvi_Card, ttcvi_bgo_nr, 2);
      }
      else if (ttcvi_bgo_reg == 4) {
	ffv1Debug->TTCvi_BGO_Reset_FIFO(TTCvi_Card, ttcvi_bgo_nr, 2);
      }
     }
     else if (ttcvi_cmd == 6) {
       ffv1Debug->TTCvi_Reset_Counters(TTCvi_Card, 2);
     }
     else if (ttcvi_cmd == 7) {
        cout << "TTCvi : Counter (0 = Events ; 1 = Orbits) ";
	cin >> dec >> ttcvi_ctr;
        ffv1Debug->TTCvi_Select_Counter(TTCvi_Card, ttcvi_ctr, 2);
     } 
     else if (ttcvi_cmd == 8) {
        cout << "TTCvi : Send Async Chan B cmd (0 = Short ; 1 = Long) ";
	cin >> dec >> ttcvi_async_type;
	if (ttcvi_async_type == 0) {
	  cout << "TTCvi : Enter Short Command (0-255) : ";
	  cin >> dec >> ttcvi_short_cmd;
	  ffv1Debug->TTCvi_Async_Short(TTCvi_Card, ttcvi_short_cmd, 2);
	}
	else if (ttcvi_async_type == 1) {
	  cout << "TTCvi : Enter TTCrx Address Command (0-2047) : ";
	  cin >> dec >> ttcvi_long_ttcaddr;
	  cout << "TTCvi : Enter Subaddr (0-255) : ";
	  cin >> dec >> ttcvi_long_subaddr;
	  cout << "TTCvi : Enter Data (0-255) : ";
	  cin >> dec >> ttcvi_long_data;

	  ffv1Debug->TTCvi_Async_Long(TTCvi_Card, ttcvi_long_ttcaddr, ttcvi_long_subaddr, ttcvi_long_data, 2);
	}
     }
      else if (ttcvi_cmd == 9) {
       ffv1Debug->TTCvi_Reset_Module(TTCvi_Card, 2);
     }
      else if (ttcvi_cmd == 10) {
	// set up BGO<0> to generate BX reset on each orbit
        ffv1Debug->TTCvi_Select_Counter(TTCvi_Card, 0, 2);
	ffv1Debug->TTCvi_Reset_Counters(TTCvi_Card, 2);

	ffv1Debug->TTCvi_BGO_Reset_FIFO(TTCvi_Card, 0, 2);
 	ffv1Debug->TTCvi_BGO_Retransmit(TTCvi_Card, 0, 2);
 	ffv1Debug->TTCvi_BGO_Inhibit(TTCvi_Card, 0, 1, 1, 2);
	ffv1Debug->TTCvi_BGO_Mode(TTCvi_Card, 0, 1, 0, 1, 1, 2);
	ffv1Debug->TTCvi_BGO_Data(TTCvi_Card, 0, 0, 2);
 
        ffv1Debug->TTCvi_Select_Orbit(TTCvi_Card, 1, 2);
     }

//       ffv1Debug->DisplayClockCounters(2);
     break;
   case '7' :
     cout << "How many bits of offset before spy data? ";
     cin >> dec >> spy_offset;
     ffv1Debug->SpyDisplay(spy_offset);
     break;
   case '8' :
     ffv1Debug->DisplayFibreBufferLevels(1);
     break;
   case '9' :
     ffv1Debug->LoadFrameThresholds(1);
     break;
   default:
      cout << "Sorry didn't recognise that choice. Try again. " << '\n';
      break;
      }
  }

  return 0; 


//    {
//      unsigned long  mydata = 0;
//      unsigned long offset = 0;
//          int retVal=ffv1Debug->ffv1SingleRead(&mydata, offset);
//          if(retVal)
//    	cout<<"ffv1SingleRead() reported an error"<<endl;
//          cout<<"data from memory location [0] = "<<mydata<<endl;
//    }
//  	return 0;


  //initial testing routines. 

//    if(ffv1Debug->preliminaryTest(ffv1AddressItem))
//      cout<<"error reported by preliminaryTest()"<<endl; 

//    if(ffv1Debug->writeBlockMemTest())
//      cout<<"error reported by writeBlockMemTest()"<<endl; 
   
//    if(ffv1Debug->readBlockMemTest())
//      cout<<"error reported by readBlockMemTest()"<<endl; 


   unsigned long dataFromFFv1[memLength]={0};
//    if(ffv1Debug->ffv1BlockRead(dataFromFFv1, memLength))
//      cout<<"error reported by ffv1BlockRead()"<<endl; 

  unsigned long dataToFFv1[memLength]={0};
  for(unsigned long i=0; i<memLength; i++)
    dataToFFv1[i]=rand();

  if(ffv1Debug->ffv1BlockWrite(dataToFFv1, memLength))
    cout<<"error reported by ffv1BlockWrite()"<<endl; 
  

    for(unsigned long i=0; i<memLength; i++)
      {
        int retVal=ffv1Debug->ffv1SingleRead(&dataFromFFv1[i],i);
        if(retVal)
  	cout<<"ffv1SingleRead() reported an error"<<endl;
        cout<<"data from memory location ["<<i<<"] = "<<dataFromFFv1[i]<<endl;
      }

    ffv1Debug->checkData(dataToFFv1, dataFromFFv1, memLength);
  
  delete ffv1Debug;
  return 0;
}



int getBaseAddress(unsigned long * pBaseAddr)
{
  ifstream baseAddressFile;
  baseAddressFile.open("FFv1BaseAddress.dat");
  // baseAddressFile.open("/home/xdaq/TriDAS/daq/fed_debug/src/linux/x86/FFv1BaseAddress.dat");
  if(!baseAddressFile.is_open())
    {
      // cout<<"file /home/xdaq/TriDAS/daq/fed_debug/src/linux/x86/FFv1BaseAddress.dat not opened"<<endl;
      cout<<"file FFv1BaseAddress.dat not opened"<<endl;
      return 1;
    }
  baseAddressFile>>hex>>(*pBaseAddr);
  baseAddressFile.close();
  return 0;
}
 

