-- hds header_start
--
-- VHDL Architecture CMSdelay.skew_pulsegen.untitled
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BELMOPAN)
--          at - 08:46:02 10/17/01
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2001.3 (Build 11)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY skew_pulsegen IS
Port (
	clk 			: IN		std_logic;
	rst				: IN		std_logic;
	en				: IN 		std_logic;
	skew			: IN		std_logic_vector(4 downto 0);
	ps_fin			: IN		std_logic;
--	DCM_skew_out 	: OUT		std_logic_vector(2 downto 0);
	sel_a			: OUT		std_logic;
	sel_b			: OUT	    std_logic;
	skew_fin		: OUT		std_logic;
	ps_shift		: OUT		std_logic;
	ps_dir			: BUFFER	std_logic
	);

END skew_pulsegen ;

-- hds interface_end
ARCHITECTURE rtl OF skew_pulsegen IS
type state_type is (s0, s1, s2, idle);
signal state : state_type;
BEGIN
process(clk,rst)
variable dcm_skew 		: unsigned(2 downto 0);
variable wanted_skew	: unsigned(2 downto 0);	
begin
if rst = '1' then
skew_fin 	<= '0';
ps_dir		<= '0';
ps_shift 	<= '0';
dcm_skew	:= "100";			-- the DCM resets to zero phase shift ie 8 steps from the start
wanted_skew := "100";
state		<= idle;			-- so the counter needs to start at 8 as well.
sel_a 		<= '0';
sel_b 		<= '0';

elsif clk'event and clk = '1' then
 if en = '1' then
	wanted_skew := unsigned(skew(2 downto 0));
 
	If 	wanted_skew <= dcm_skew then
		ps_dir <= '0';
	else
		ps_dir <= '1';
	end if;

	

	case state is
		when s0 => state <= s1;				-- start the shift
			ps_shift <= '1';
	

		when s1 => 
			ps_shift <= '0';

		 	if ps_fin = '1' then			-- wait for it to finish.
				state <= s2;
			else
				state <= s1;
			end if;

		when s2 => state <= idle;
			ps_shift <= '0';
			if  ps_dir = '1' then
				dcm_skew := dcm_skew + 1;
			else
				dcm_skew := dcm_skew - 1;
			end if;

		when idle => state <= idle;

			If wanted_skew = dcm_skew then
				skew_fin <= '1';
				ps_shift <= '0';			-- stop
				state <= idle;
			else
				skew_fin <= '0';
				state 	 <= s0;				-- go round again
			end if;
		when others => state <= idle;
	end case;
	end if;
-- dcm_skew_out <= conv_std_logic_vector(dcm_skew,3);-- tap port for Bill's tests
 sel_a <= skew(3);
 sel_b <= skew(4);
end if;
end process;
END rtl;
