-- hds header_start
--
-- VHDL Architecture CMSdelay.skew_calc.interface
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BELMOPAN)
--          at - 09:38:24 10/18/01
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2001.3 (Build 11)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY skew_calc IS
   PORT( 
      clk        : IN     std_logic;
      rst        : IN     std_logic;
	  EN		 : IN 	  std_logic;
      skew_1_out : OUT    std_logic_vector (4 DOWNTO 0);
      skew_2_out : OUT    std_logic_vector (4 DOWNTO 0);
      skew_3_out : OUT    std_logic_vector (4 DOWNTO 0);
      skew_4_out : OUT    std_logic_vector (4 DOWNTO 0);
      overflow_1 : OUT    std_logic;
      overflow_2 : OUT    std_logic;
      overflow_3 : OUT    std_logic;
      overflow_4 : OUT    std_logic;
      samplepos  : IN     std_logic_vector (4 DOWNTO 0);
      skew_1_in  : IN     std_logic_vector (4 DOWNTO 0);
      skew_2_in  : IN     std_logic_vector (4 DOWNTO 0);
      skew_3_in  : IN     std_logic_vector (4 DOWNTO 0);
      skew_4_in  : IN     std_logic_vector (4 DOWNTO 0)
   );

-- Declarations

END skew_calc ;

-- hds interface_end
ARCHITECTURE untitled OF skew_calc IS
BEGIN
process( clk, rst)
variable skew_1_out_int	: unsigned(4 downto 0);
variable skew_2_out_int : unsigned(4 downto 0);
variable skew_3_out_int : unsigned(4 downto 0);
variable skew_4_out_int : unsigned(4 downto 0);
variable skew_1_in_int	: unsigned(4 downto 0);
variable skew_2_in_int	: unsigned(4 downto 0);
variable skew_3_in_int	: unsigned(4 downto 0);
variable skew_4_in_int	: unsigned(4 downto 0);
variable samplepos_int 	: unsigned(4 downto 0);
begin
if rst = '1' then 
	skew_1_out  	<= "10000";
	skew_2_out  	<= "10000";
	skew_3_out  	<= "10000";
	skew_4_out   	<= "10000";
	skew_1_in_int   := "10000";
	skew_2_in_int   := "10000";
	skew_3_in_int   := "10000";
	skew_4_in_int   := "10000";
	skew_1_out_int  := "10000";
	skew_2_out_int  := "10000";
	skew_3_out_int  := "10000";
	skew_4_out_int  := "10000";
	samplepos_int   := ( others => '0');

elsif clk'event and clk = '1' then
	if en = '1' then
	-- test if need to add one to whole clk delays
	if samplepos > skew_1_in then
		overflow_1 <= '1';
	else
		overflow_1 <= '0';
	end if;

	if samplepos > skew_2_in then
		overflow_2 <= '1';
	else
		overflow_2 <= '0';
	end if;

	if samplepos > skew_3_in then
		overflow_3 <= '1';
	else
		overflow_3 <= '0';
	end if;

	if samplepos > skew_4_in then
		overflow_4 <= '1';
	else
		overflow_4 <= '0';
	end if;
	-- end tests for whole clk delays

	skew_1_in_int := unsigned(skew_1_in);
	skew_2_in_int := unsigned(skew_2_in);
	skew_3_in_int := unsigned(skew_3_in);
	skew_4_in_int := unsigned(skew_4_in);
	samplepos_int := unsigned(samplepos);



	skew_1_out_int := skew_1_in_int - samplepos_int;
	skew_2_out_int := skew_2_in_int - samplepos_int;
 	skew_3_out_int := skew_3_in_int - samplepos_int;
	skew_4_out_int := skew_4_in_int - samplepos_int;
	

	skew_1_out <= conv_std_logic_vector(skew_1_out_int,5);	
	skew_2_out <= conv_std_logic_vector(skew_2_out_int,5);
	skew_3_out <= conv_std_logic_vector(skew_3_out_int,5);
	skew_4_out <= conv_std_logic_vector(skew_4_out_int,5);
end if;

 end if;

end process;

END untitled;
