-- hds header_start
--
-- VHDL Architecture CMSdelay.shifter.RTL
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BELMOPAN)
--          at - 10:56:06 10/10/01
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2001.3 (Build 11)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY shifter IS
port (
	clk			: IN std_logic;
	rst			: IN std_logic;
	ps_shift 	: IN std_logic;
	psdir		: IN std_logic;
	psdone		: IN std_logic;
	ps_fin		: OUT std_logic;
	Psincdec 	: OUT std_logic;
	psen		: OUT std_logic
	);
 
END shifter ;

-- hds interface_end
ARCHITECTURE RTL OF shifter IS

type state_type is (idle, start, s1, s2, s3, s4, s5, done);
signal    state : state_type;
BEGIN
process(clk,rst)
 variable  count : unsigned (4 downto 0);
begin

If rst = '1' then

	psen 		<= '0';
	psincdec	<= '0';
	ps_fin 		<= '0';
	count 		:= ( others => '0');
	state 		<= idle;
elsif clk'event and clk = '1' then

	

	case state is
		when start => state <= s1;
			psen 		<= '0';
			psincdec 	<= psdir;  		-- only set in start state so cant change 1/2 way throw.
			count 		:= ( others => '0');
			ps_fin 		<= '0';
		
		when s1 => state <= s2;
			psen 		<= '1' after 0.1 ns;
			ps_fin 		<= '0';
		
		when s2 => state <= s3;
			psen 		<= '0' after 0.1 ns;
			ps_fin 		<= '0';
		
		when s3 => 
			psen 		<= '0';
			ps_fin 		<= '0';
			if psdone = '1' then
				state <= s4;
			else
				state <= s3;
		    end if;
	   	
		when s4 => state <= s5;
			psen 		<= '0';   		-- blank state to give DCM a rest
			ps_fin 		<= '0';
			count 		:= count + 1;

		when s5 => 
			psen 		<= '0';
			ps_fin 		<= '0';
			if count < 16 then
				state <= s1;
			else
				state <= done;
			end if;

		when done => state <= idle;
			psen 		<= '0';
			ps_fin 		<= '1';
			count 		:= ( others => '0');

		when idle => 
			psen 		<= '0';
			psincdec	<= '0';
			ps_fin 		<= '0';
			count		:= ( others => '0');
			if ps_shift = '1' then
				state <= start;
			else
				state <= idle;
			end if;



		when others => state <= idle;
		end case;


END IF;
end process;
  
END RTL;
