-- hds header_start
--
-- VHDL Architecture CMSdelay.shift_calc.interface
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BELMOPAN)
--          at - 10:53:35 10/08/01
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2001.3 (Build 11)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.VITAL_Timing.ALL;
LIBRARY STD;
USE STD.TEXTIO.ALL;

ENTITY shift_calc IS
   PORT( 
      clk     	: IN     std_logic;
      offset  	: IN     std_logic_vector (3 DOWNTO 0);
      rst     	: IN     std_logic;
	  overflow	: IN	 std_logic;
      address 	: OUT    std_logic_vector (3 DOWNTO 0)
   );

-- Declarations

END shift_calc ;

-- hds interface_end
ARCHITECTURE untitled OF shift_calc IS
 
BEGIN
process ( clk,rst)
variable offset_int : unsigned(3 downto 0);
variable address_int : unsigned(3 downto 0);
begin
if rst = '1' then
		address <= "0001";				    -- zero delay is 1 level of register to alow for roll back
		offset_int := ( others => '0');	    -- from skew.
elsif clk'event and clk = '1' then		    
 	offset_int  := unsigned(offset);
	if overflow = '1' then
		address_int	:= offset_int  - 1;
	else
		address_int	:= offset_int;
	end if;

	   address <= conv_std_logic_vector(address_int,4);
 end if;
end process;			
		

END untitled;
