-- hds header_start
--
-- VHDL Architecture CMSdelay.serial_decode_tester.interface
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BELMOPAN)
--          at - 09:26:38 11/09/01
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2001.3 (Build 11)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY serial_decode_tester IS
   PORT( 
      clk        : BUFFER std_logic;
      command_in : BUFFER std_logic;
      rst        : BUFFER std_logic;
      data_valid : IN     std_logic;
	  arm		 : IN 	  std_logic;
	  fire		 : IN 	  std_logic;
      skew1      : IN     std_logic_vector (4 DOWNTO 0);
      skew2      : IN     std_logic_vector (4 DOWNTO 0);
      skew3      : IN     std_logic_vector (4 DOWNTO 0);
      skew4      : IN     std_logic_vector (4 DOWNTO 0);
      coarse1    : IN     std_logic_vector (3 DOWNTO 0);
      coarse2    : IN     std_logic_vector (3 DOWNTO 0);
      coarse3    : IN     std_logic_vector (3 DOWNTO 0);
      coarse4    : IN     std_logic_vector (3 DOWNTO 0)
   );

-- Declarations

END serial_decode_tester ;

-- hds interface_end
ARCHITECTURE untitled OF serial_decode_tester IS
begin
 vecgen : process(clk,rst)
  begin

    if (rst = 'U') then
      rst    <= '1' after 0 ns;				-- at start all signals are U ( undifined )
      clk    <= '0' after 0 ns;				-- so set reset to 1 for 10 ns
    end if;
    
    If (rst = '1') then
		rst 	<= '0' after 25 ns;			-- after 10 ns ser rst to zero  
   	end if;									-- this line will zero reset after 10 ns 
											-- nomatter what set it


    -- Main clock loop

    if (clk'event) then					-- clock is activated my an event on its self
      if (clk = '1') then
        clk <= '0' after 12.5 ns;			-- generate clock on 20ns cycle ie 50Mhz
      else
        clk <= '1' after 12.5 ns;
      end if;
    end if;
  end process;
  -- end of clock generation 

 -- start stimulus for item on test
  stim : process
	
 	 begin
	 wait for 12.5 ns;	   -- sync to rising edge
	 command_in <= '0';	   -- wait for reset
	wait for 200 ns;

	command_in <= '1';
	wait for 25 ns;	    	-- send start of message
	command_in <= '0';
	wait for 25 ns;
							-- designator 5 bits
	command_in <= '0';		-- 1=load skew,	6=load coarse, 7=arm, 8=fire,
	wait for 25 ns;		    -- sk,	cor, 	arm,	fire
	command_in <= '0';	    -- 0,	0,		0,		1,
	wait for 25 ns;			
	command_in <= '0';	    -- 0,`  1,		1,		0,
	wait for 25 ns;
	command_in <= '0';	   	-- 0,  	1,		1,		0,
	wait for 25 ns;
	command_in <= '1';	    -- 1,  	0,		1,		0,
	wait for 25 ns;

	command_in <= '1'; 		-- start of length signifier
	wait for 25 ns;



	command_in <= '0';  	-- MSB of length 
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;			     -- the combined length of the data packets to follow
	command_in <= '0';		     -- ie skew is 4 sets of 5 bits so length = 20
	wait for 25 ns;			     -- coarse is 4 sets of 4 bitd so length = 16
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '1';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns; 
	command_in <= '1';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns; 
	command_in <= '0';
	wait for 25 ns;		    -- LSB of length


	command_in <= '1';	  	-- MSB of coarse 1
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';   	-- LSB of coarse 1
	wait for 25 ns;

	command_in <= '0';	  	-- MSB of skew 1
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '1';
	wait for 25 ns;		    -- LSB of skew 1




	command_in <= '1';	  	-- MSB of coarse 2
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';   	-- LSB of coarse 2
	wait for 25 ns;

	command_in <= '0';	  	-- MSB of skew 2
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '1';
	wait for 25 ns;		    -- LSB of skew 2
	 



	command_in <= '1';	  	-- MSB of coarse 3
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';   	-- LSB of coarse 3
	wait for 25 ns;

	command_in <= '0';	  	-- MSB of skew 3
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '1';
	wait for 25 ns;		    -- LSB of skew 3



	command_in <= '1';	  	-- MSB of coarse 4
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';   	-- LSB of coarse 4
	wait for 25 ns;

	command_in <= '0';	  	-- MSB of skew 4
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '0';
	wait for 25 ns;
	command_in <= '1';
	wait for 25 ns;		    -- LSB of skew 4
	
	command_in <= '0';	-- make sure its at zero when finished
		 wait;
	end process;


end untitled;
