-- with 4 bit coarse value in
-- hds header_start
--
-- VHDL Architecture CMSdelay.serial_decode.symbol
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BELMOPAN)
--          at - 09:15:21 11/09/01
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2001.3 (Build 11)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY serial_decode IS
   PORT( 
      rst        : IN     std_logic;
      clk        : IN     std_logic;
      command_in : IN     std_logic;
      data_valid : OUT    std_logic;
      arm        : OUT    std_logic;
      fire       : OUT    std_logic;
      skew1      : BUFFER std_logic_vector (4 DOWNTO 0);
      skew2      : BUFFER std_logic_vector (4 DOWNTO 0);
      skew3      : BUFFER std_logic_vector (4 DOWNTO 0);
      skew4      : BUFFER std_logic_vector (4 DOWNTO 0);
      coarse1    : BUFFER std_logic_vector (3 DOWNTO 0);
      coarse2    : BUFFER std_logic_vector (3 DOWNTO 0);
      coarse3    : BUFFER std_logic_vector (3 DOWNTO 0);
      coarse4    : BUFFER std_logic_vector (3 DOWNTO 0)
   );

-- Declarations

END serial_decode ;

-- hds interface_end
ARCHITECTURE rtl2 OF serial_decode IS

type state_type is (s0, s1, s2 );
signal state : state_type;
signal load_skew : std_logic;
signal load_coarse 		: std_logic;
signal r_wB : std_logic;
signal designator : unsigned(4 downto 0);
signal length_field : unsigned(7 downto 0);

BEGIN
process(clk,rst)
begin
if rst = '1' then
	
	state 			<= s0;
	length_field 	<= ( others => '0');
	designator 		<= ( others => '0');
	r_wB			<= '0';
elsif clk'event and clk = '1' then

	case state is
		when s0 =>
			r_wB <= designator(4);
			designator <= (designator(3 downto 0) & command_in);
			if r_wB = '1' then
				state <= s1;
			else
				state <= s0;
			end if;

		When s1 =>
			length_field <= length_field(6 downto 0) & command_in;
			if (length_field(7) = '1') then
				state <= s2;
			else 
				state <= s1;
			end if;

	   

	   When s2 =>
	   		length_field <= length_field - '1';
			if (length_field = 1) then
				state <= s0;
				designator <= ( others => '0');
				r_wB		<= '0';
			else 
				state <= s2;
			end If;

	   when others => state <= s0;

  	end case;

end if;
end process;
load_skew 		<= '1' when ((state = s2) and (designator = 1)) else '0';	
load_coarse		<= '1' when ((state = s2) and (designator = 6)) else '0';
fire 			<= '1' when ((state = s2) and (designator = 8)) else '0';
arm 			<= '1' when ((state = s2) and (designator = 7)) else '0';


process(clk,rst)
variable coarse_1 : std_logic_vector(4 downto 0);
variable coarse_2 : std_logic_vector(4 downto 0);
variable coarse_3 : std_logic_vector(4 downto 0);
variable coarse_4 : std_logic_vector(4 downto 0);
begin
if rst = '1' then
	skew1 		<= "10000";
	skew2 		<= "10000";
	skew3 		<= "10000";
	skew4 		<= "10000";
	coarse1 	<= (others => '0');
	coarse2		<= (others => '0');
	coarse3		<= (others => '0');
	coarse4		<= (others => '0');
	coarse_1 	:= (others => '0');
	coarse_2	:= (others => '0');
	coarse_3	:= (others => '0');
	coarse_4	:= (others => '0');
	data_valid	<= '0';

elsif clk'event and clk = '1' then
	if load_skew = '1' then
		skew1 	<= skew1(3 downto 0) & skew2(4);
		skew2 	<= skew2(3 downto 0) & skew3(4);
		skew3 	<= skew3(3 downto 0) & skew4(4);
		skew4 	<= skew4(3 downto 0) & command_in;
	end if;


	if load_coarse = '1' then
		coarse_1		:= coarse1( 3 downto 0) & coarse_2(4);
		coarse_2		:= coarse2( 3 downto 0) & coarse_3(4);
		coarse_3		:= coarse3( 3 downto 0) & coarse_4(4); 
		coarse_4		:= coarse4( 3 downto 0)& command_in;
		coarse1 		<= coarse_1(3 downto 0);
		coarse2 		<= coarse_2(3 downto 0);
		coarse3 		<= coarse_3(3 downto 0);
		coarse4 		<= coarse_4(3 downto 0);
	end if;

	if ((state = s0) and (designator = 0) and (length_field = 0)) then
		data_valid <= '1';
	else
		data_valid <= '0';
	end if;

end if;
end process;
END rtl2;
