-- hds header_start
--
-- VHDL Architecture CMSdelay.reg_selector.interface
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BELMOPAN)
--          at - 10:45:05 10/18/01
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2001.3 (Build 11)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY reg_selector IS
   PORT( 
      clk    : IN     std_logic;
      rst    : IN     std_logic;
      skew_1 : IN     std_logic_vector (4 DOWNTO 0);
      skew_2 : IN     std_logic_vector (4 DOWNTO 0);
      skew_3 : IN     std_logic_vector (4 DOWNTO 0);
      skew_4 : IN     std_logic_vector (4 DOWNTO 0);
      sel_1  : OUT    std_logic;
      sel_2  : OUT    std_logic;
      sel_3  : OUT    std_logic;
      sel_4  : OUT    std_logic
   );

-- Declarations

END reg_selector ;

-- hds interface_end
ARCHITECTURE untitled OF reg_selector IS
BEGIN
process(clk, rst)

begin
if rst = '1' then
	sel_3 <= '1';
	sel_2 <= '1';
	sel_3 <= '1';			-- defalt to 1 as at zero phase shift data is in reg B
	sel_4 <= '1';
 elsif clk'event and clk = '1' then




 	 	case skew_1 is

		when "00000"	=> sel_1 <= '0'; -- 0	    reg A
		when "00001" 	=> sel_1 <= '0'; -- 1
 		when "00010" 	=> sel_1 <= '0'; -- 2
		when "00011" 	=> sel_1 <= '0'; -- 3
		when "00100" 	=> sel_1 <= '0'; -- 4
		when "00101" 	=> sel_1 <= '0'; -- 5
	   	when "00110" 	=> sel_1 <= '0'; -- 6
		when "00111" 	=> sel_1 <= '0'; -- 7
		when "01000" 	=> sel_1 <= '0'; -- 8
		when "01001" 	=> sel_1 <= '0'; -- 9	  Flip to reg B
		when "01010" 	=> sel_1 <= '0'; -- 10
		when "01011" 	=> sel_1 <= '0'; -- 11
		when "01100" 	=> sel_1 <= '0'; -- 12		
		when "01101" 	=> sel_1 <= '0'; -- 13
		when "01110" 	=> sel_1 <= '0'; -- 14
		when "01111" 	=> sel_1 <= '0'; -- 15
 		when "10000" 	=> sel_1 <= '0'; -- 16
		when "10001" 	=> sel_1 <= '1'; -- 17   flip back to reg A
 		when "10010" 	=> sel_1 <= '1'; -- 18
		when "10011" 	=> sel_1 <= '1'; -- 19
		when "10100" 	=> sel_1 <= '1'; -- 20
		when "10101" 	=> sel_1 <= '1'; -- 21
		when "10110" 	=> sel_1 <= '1'; -- 22
		when "10111" 	=> sel_1 <= '1'; -- 23
		when "11000" 	=> sel_1 <= '1'; -- 24
		when "11001" 	=> sel_1 <= '1'; -- 25   flip to reg B
		when "11010" 	=> sel_1 <= '1'; -- 26
		when "11011" 	=> sel_1 <= '1'; -- 27
		when "11100" 	=> sel_1 <= '1'; -- 28
		when "11101" 	=> sel_1 <= '1'; -- 29
		when "11110" 	=> sel_1 <= '1'; -- 30
		when "11111" 	=> sel_1 <= '1'; -- 31
		when others     => sel_1 <= '0'; -- error
	end case;

	 	case skew_2 is

		when "00000"	=> sel_2 <= '0'; -- 0	    reg A
		when "00001" 	=> sel_2 <= '0'; -- 1
 		when "00010" 	=> sel_2 <= '0'; -- 2
		when "00011" 	=> sel_2 <= '0'; -- 3
		when "00100" 	=> sel_2 <= '0'; -- 4
		when "00101" 	=> sel_2 <= '0'; -- 5
	   	when "00110" 	=> sel_2 <= '0'; -- 6
		when "00111" 	=> sel_2 <= '0'; -- 7
		when "01000" 	=> sel_2 <= '0'; -- 8
		when "01001" 	=> sel_2 <= '0'; -- 9	  Flip to reg B
		when "01010" 	=> sel_2 <= '0'; -- 10
		when "01011" 	=> sel_2 <= '0'; -- 11
		when "01100" 	=> sel_2 <= '0'; -- 12		
		when "01101" 	=> sel_2 <= '0'; -- 13
		when "01110" 	=> sel_2 <= '0'; -- 14
		when "01111" 	=> sel_2 <= '0'; -- 15
 		when "10000" 	=> sel_2 <= '1'; -- 16
		when "10001" 	=> sel_2 <= '1'; -- 17   flip back to reg A
 		when "10010" 	=> sel_2 <= '1'; -- 18
		when "10011" 	=> sel_2 <= '1'; -- 19
		when "10100" 	=> sel_2 <= '1'; -- 20
		when "10101" 	=> sel_2 <= '1'; -- 21
		when "10110" 	=> sel_2 <= '1'; -- 22
		when "10111" 	=> sel_2 <= '1'; -- 23
		when "11000" 	=> sel_2 <= '1'; -- 24
		when "11001" 	=> sel_2 <= '1'; -- 25   flip to reg B
		when "11010" 	=> sel_2 <= '1'; -- 26
		when "11011" 	=> sel_2 <= '1'; -- 27
		when "11100" 	=> sel_2 <= '1'; -- 28
		when "11101" 	=> sel_2 <= '1'; -- 29
		when "11110" 	=> sel_2 <= '1'; -- 30
		when "11111" 	=> sel_2 <= '1'; -- 31
		when others     => sel_2 <= '0'; -- error
	end case;


	 	case skew_3 is

		when "00000"	=> sel_3 <= '0'; -- 0	    reg A
		when "00001" 	=> sel_3 <= '0'; -- 1
 		when "00010" 	=> sel_3 <= '0'; -- 2
		when "00011" 	=> sel_3 <= '0'; -- 3
		when "00100" 	=> sel_3 <= '0'; -- 4
		when "00101" 	=> sel_3 <= '0'; -- 5
	   	when "00110" 	=> sel_3 <= '0'; -- 6
		when "00111" 	=> sel_3 <= '0'; -- 7
		when "01000" 	=> sel_3 <= '0'; -- 8
		when "01001" 	=> sel_3 <= '0'; -- 9	  Flip to reg B
		when "01010" 	=> sel_3 <= '0'; -- 10
		when "01011" 	=> sel_3 <= '0'; -- 11
		when "01100" 	=> sel_3 <= '0'; -- 12		
		when "01101" 	=> sel_3 <= '0'; -- 13
		when "01110" 	=> sel_3 <= '0'; -- 14
		when "01111" 	=> sel_3 <= '0'; -- 15
 		when "10000" 	=> sel_3 <= '1'; -- 16
		when "10001" 	=> sel_3 <= '1'; -- 17   flip back to reg A
 		when "10010" 	=> sel_3 <= '1'; -- 18
		when "10011" 	=> sel_3 <= '1'; -- 19
		when "10100" 	=> sel_3 <= '1'; -- 20
		when "10101" 	=> sel_3 <= '1'; -- 21
		when "10110" 	=> sel_3 <= '1'; -- 22
		when "10111" 	=> sel_3 <= '1'; -- 23
		when "11000" 	=> sel_3 <= '1'; -- 24
		when "11001" 	=> sel_3 <= '1'; -- 25   flip to reg B
		when "11010" 	=> sel_3 <= '1'; -- 26
		when "11011" 	=> sel_3 <= '1'; -- 27
		when "11100" 	=> sel_3 <= '1'; -- 28
		when "11101" 	=> sel_3 <= '1'; -- 29
		when "11110" 	=> sel_3 <= '1'; -- 30
		when "11111" 	=> sel_3 <= '1'; -- 31
		when others     => sel_3 <= '0'; -- error
	end case;

	 	case skew_4 is

		when "00000"	=> sel_4 <= '0'; -- 0	    reg A
		when "00001" 	=> sel_4 <= '0'; -- 1
 		when "00010" 	=> sel_4 <= '0'; -- 2
		when "00011" 	=> sel_4 <= '0'; -- 3
		when "00100" 	=> sel_4 <= '0'; -- 4
		when "00101" 	=> sel_4 <= '0'; -- 5
	   	when "00110" 	=> sel_4 <= '0'; -- 6
		when "00111" 	=> sel_4 <= '0'; -- 7
		when "01000" 	=> sel_4 <= '0'; -- 8
		when "01001" 	=> sel_4 <= '0'; -- 9	  Flip to reg B
		when "01010" 	=> sel_4 <= '0'; -- 10
		when "01011" 	=> sel_4 <= '0'; -- 11
		when "01100" 	=> sel_4 <= '0'; -- 12		
		when "01101" 	=> sel_4 <= '0'; -- 13
		when "01110" 	=> sel_4 <= '0'; -- 14
		when "01111" 	=> sel_4 <= '0'; -- 15
 		when "10000" 	=> sel_4 <= '1'; -- 16
		when "10001" 	=> sel_4 <= '1'; -- 17   flip back to reg A
 		when "10010" 	=> sel_4 <= '1'; -- 18
		when "10011" 	=> sel_4 <= '1'; -- 19
		when "10100" 	=> sel_4 <= '1'; -- 20
		when "10101" 	=> sel_4 <= '1'; -- 21
		when "10110" 	=> sel_4 <= '1'; -- 22
		when "10111" 	=> sel_4 <= '1'; -- 23
		when "11000" 	=> sel_4 <= '1'; -- 24
		when "11001" 	=> sel_4 <= '1'; -- 25   flip to reg B
		when "11010" 	=> sel_4 <= '1'; -- 26
		when "11011" 	=> sel_4 <= '1'; -- 27
		when "11100" 	=> sel_4 <= '1'; -- 28
		when "11101" 	=> sel_4 <= '1'; -- 29
		when "11110" 	=> sel_4 <= '1'; -- 30
		when "11111" 	=> sel_4 <= '1'; -- 31
		when others     => sel_4 <= '0'; -- error
	end case;


end if;
end process;
END untitled;
