-- hds header_start
--
-- VHDL Architecture CMSdelay.p_s_conv_40bit.interface
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BELMOPAN)
--          at - 08:44:44 11/05/01
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2001.3 (Build 11)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY p_s_conv_40bit IS
   PORT( 
      clk          : IN     std_logic;
      data_out_ch1 : IN     std_logic_VECTOR (9 DOWNTO 0);
      data_out_ch2 : IN     std_logic_VECTOR (9 DOWNTO 0);
      data_out_ch3 : IN     std_logic_VECTOR (9 DOWNTO 0);
      data_out_ch4 : IN     std_logic_VECTOR (9 DOWNTO 0);
      rst          : IN     std_logic;
	  load		   : IN		std_logic;
      sent         : OUT    std_logic;
      serial_out   : OUT    std_logic
   );

-- Declarations

END p_s_conv_40bit ;

-- hds interface_end
ARCHITECTURE rtl OF p_s_conv_40bit IS
signal count : natural;
signal data : std_logic_vector(0 to 39);
signal run : std_logic;
BEGIN
process(clk, rst)

begin
if rst = '1' then

  serial_out 	<= '0';
  count 		<=  40;
  data 			<= (others => '0');
  sent 			<= '0';
  run 			<= '0';

elsif clk'event and clk = '1' then
	 if load = '1' then
	 	data 	<=  data_out_ch1 & data_out_ch2 & data_out_ch3 & data_out_ch4 ;
		count 	<= 0;
		sent 	<= '0';
		run 	<= '1';
	 elsif run = '1' then
	 	if count /= 40 then
 	 		count 		<= count + 1;
			serial_out 	<= data(count);
			sent 		<= '0';
		 else
	 		sent <= '1';
			serial_out <= '0';
			count <= 0;
			run <= '0';
		end if;
		else
			sent <= '0';
			serial_out <= '0';
			count <= 0;
			run <= '0';
	 	end if;


end if;
end process;
END rtl;
