-- hds header_start
--
-- VHDL Architecture CMSdelay.load_counter_10bit.interface
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BELMOPAN)
--          at - 09:41:00 10/29/01
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2001.3 (Build 11)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY load_counter_10bit IS
   PORT( 
      clk             : IN     std_logic;
      en_read_address : IN     std_logic;
      rst             : IN     std_logic;
      load            : IN     std_logic;
	  sent			  : IN 	   std_logic;
	  done			  : OUT    std_logic;
      start_address   : IN     std_logic_vector (9 DOWNTO 0);
      read_addr       : OUT    std_logic_vector (9 DOWNTO 0)
   );

-- Declarations

END load_counter_10bit ;

-- hds interface_end
ARCHITECTURE rtl OF load_counter_10bit IS
signal run : std_logic;
BEGIN
process ( clk, rst)
variable count : unsigned(9 downto 0);
variable start_count : unsigned(9 downto 0);
begin
if rst = '1' then
  	count := ( others => '0');
  	read_addr <= ( others => '0');
	done <= '0';
	run <= '0';


elsif clk'event and clk = '1' then

	if load = '1' then
	  	start_count := unsigned(start_address);
		count := start_count;
		run <= '1';
	end if;

	If en_read_address = '1' and sent = '1'  then

	 	if (run = '1') then
			count := count + 1;
			read_addr <= conv_std_logic_vector(count,10);
			done <= '0';
		else
			done <= '1';
		end if;
		
   		if    (count = start_count) then

			run <= '0';
		else
			run <= '1';
		end if;

	end if;	
end if;
end process;
END rtl;
