-- hds header_start
--
-- VHDL Architecture CMSdelay.input_tester.interface
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BELMOPAN)
--          at - 12:01:22 10/17/01
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2001.3 (Build 11)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY input_tester IS
   PORT( 
      adc1_clk        : IN     std_logic;
      adc2_clk        : IN     std_logic;
      adc3_clk        : IN     STD_LOGIC;
      adc4_clk        : IN     STD_LOGIC;
      locked_1        : IN     std_logic;
	  arm			  : IN 	   std_logic;
	  fire			  : IN 	   std_logic;
	  serial_out	  : IN	   std_logic;
      locked_2        : IN     std_logic;
      locked_3        : IN     std_logic;
      locked_4        : IN     std_logic;
      skew_fin_1      : IN     std_logic;
      skew_fin_2      : IN     std_logic;
      skew_fin_3      : IN     std_logic;
      skew_fin_4      : IN     std_logic;
	  skew_1		  : OUT	   std_logic_vector(4 downto 0);
	  skew_2		  : OUT	   std_logic_vector(4 downto 0);
	  skew_3		  : OUT	   std_logic_vector(4 downto 0);
	  skew_4		  : OUT	   std_logic_vector(4 downto 0);
      output_channel1 : IN     std_logic_vector (9 DOWNTO 0);
      output_channel2 : IN     std_logic_vector (9 DOWNTO 0);
      output_channel3 : IN     std_logic_vector (9 DOWNTO 0);
      output_channel4 : IN     std_logic_vector (9 DOWNTO 0);
      clk	          : BUFFER std_ulogic;
      data_adc1       : OUT    std_logic_vector (9 DOWNTO 0);
      data_adc2       : OUT    std_logic_vector (9 DOWNTO 0);
      data_adc3       : OUT    std_logic_vector (9 DOWNTO 0);
      data_adc4       : OUT    std_logic_vector (9 DOWNTO 0);
      offset_1        : OUT    std_logic_vector (3 DOWNTO 0);
      offset_2        : OUT    std_logic_vector (3 DOWNTO 0);
      offset_3        : OUT    std_logic_vector (3 DOWNTO 0);
      offset_4        : OUT    std_logic_vector (3 DOWNTO 0);
      rst             : BUFFER std_logic;
      sel_1           : OUT    std_logic;
      sel_2           : OUT    std_logic;
      sel_3           : OUT    std_logic;
      sel_4           : OUT    std_logic
   );

-- Declarations

END input_tester ;

-- hds interface_end
ARCHITECTURE untitled OF input_tester IS
BEGIN
vecgen : process(clk,rst)
  begin

    if (rst = 'U') then
      rst    <= '1' after 0 ns;				-- at start all signals are U ( undifined )
      clk  <= '0' after 0 ns;				-- so set reset to 1 for 10 ns
    end if;
    
    If (rst = '1') then
		rst 	<= '0' after 25 ns;			-- after 10 ns ser rst to zero  
   	end if;									-- this line will zero reset after 10 ns 
											-- nomatter what set it


    -- Main clock loop

    if (clk'event) then					-- clock is activated my an event on its self
      if (clk = '1') then
        clk <= '0' after 12.5 ns;			-- generate clock on 20ns cycle ie 50Mhz
      else
        clk <= '1' after 12.5 ns;
      end if;
    end if;
  end process;
  -- end of clock generation 

stim : process(adc1_clk, rst)
variable data_int1 : unsigned (9 downto 0);
begin
	if rst = '1' then 
	
      Data_adc1     <= (others => '0');
      offset_1   	<= "1001";
      offset_2   	<= "1001";	    -- 1001 is an off set of -7 it the quickest it can be 
      offset_3   	<= "1001";
      offset_4   	<= "1001";
      sel_1         <= '1';
      sel_2      	<= '0';
      sel_3         <= '1';
      sel_4         <= '0';
	  skew_1		<= "10000";
	  skew_2		<= "10000";
	  skew_3		<= "10000";	     -- DCM start at zero phase shift ie 16 steps from start
	  skew_4		<= "10000";

	  data_int1		:= ( others => '0');
  
	elsif adc1_clk'event then
	  	data_int1 := data_int1 + 1;  --data synced to chn. 1
	end if;
	data_adc1 <= conv_std_logic_vector(data_int1,10) after 0.5 ns;

end process;

 stim2 : process(adc2_clk, rst)
variable data_int2 : unsigned (9 downto 0);
begin
	if rst = '1' then 

		 data_int2 := ( others => '0');
		 Data_adc2     <= (others => '0');

elsif adc2_clk'event then
	  	data_int2 := data_int2 + 1;   -- generate data from cannle 2 clk
	end if;
	data_adc2 <= conv_std_logic_vector(data_int2,10) after 0.5 ns;
end process;


 stim3 : process(adc3_clk, rst)
variable data_int3 : unsigned (9 downto 0);
begin
	if rst = '1' then 

		 data_int3 := ( others => '0');
		 Data_adc3     <= (others => '0');
      

elsif adc3_clk'event then
	  	data_int3 := data_int3 + 1;   -- generate data from cannle 2 clk
	end if;
	data_adc3 <= conv_std_logic_vector(data_int3,10) after 0.5 ns;
end process;



 stim4 : process(adc4_clk, rst)
variable data_int4 : unsigned (9 downto 0);
begin
	if rst = '1' then 

		 data_int4 := ( others => '0');
		 Data_adc4 <= (others => '0');

elsif adc4_clk'event then
	  	data_int4 := data_int4 + 1;   -- generate data from cannle 2 clk
	end if;
	data_adc4 <= conv_std_logic_vector(data_int4,10) after 0.5 ns;
end process;




END untitled;
