-- hds header_start
--
-- VHDL Architecture CMSdelay.input_ddr_registers_tester.tester
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BELMOPAN)
--          at - 16:00:22 11/05/01
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2001.3 (Build 11)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.VITAL_Timing.ALL;
LIBRARY STD;
USE STD.TEXTIO.ALL;

ENTITY input_ddr_registers_tester IS
   PORT( 
      d    : IN     std_logic_vector (9 DOWNTO 0);
      Data : OUT    std_logic_vector (9 DOWNTO 0);
      clk  : BUFFER    std_logic;
      rst  : BUFFER    std_logic;
      sel  : OUT    std_logic
   );

-- Declarations

END input_ddr_registers_tester ;

-- hds interface_end
ARCHITECTURE tester OF input_ddr_registers_tester IS
BEGIN
vecgen : process(clk,rst)
  begin

    if (rst = 'U') then
      rst    <= '1' after 0 ns;				-- at start all signals are U ( undifined )
      clk  <= '0' after 0 ns;				-- so set reset to 1 for 10 ns
    end if;
    
    If (rst = '1') then
		rst 	<= '0' after 10 ns;			-- after 10 ns ser rst to zero  
   	end if;									-- this line will zero reset after 10 ns 
											-- nomatter what set it


    -- Main clock loop

    if (clk'event) then					-- clock is activated my an event on its self
      if (clk = '1') then
        clk <= '0' after 10 ns;			-- generate clock on 20ns cycle ie 50Mhz
      else
        clk <= '1' after 10 ns;
      end if;
    end if;
  end process;
  -- end of clock generation 

 -- start stimulus for item on test
 	 stim : process(clk, rst)
	 variable count : unsigned( 9 downto 0);
 	 begin
	 if rst = '1' then
	 count := ( others => '0');
	 data <= ( others => '0') ;
	 elsif clk'event then
	 count := count + 1;
	 data <= conv_std_logic_vector(count,10);
	   end if;


	end process;

	-- concurent sigals

END tester;
