-- hds header_start
--
-- VHDL Architecture CMSdelay.input_ddr_registers.rtl_V2
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BELMOPAN)
--          at - 15:45:58 11/05/01
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2001.3 (Build 11)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.VITAL_Timing.ALL;
LIBRARY STD;
USE STD.TEXTIO.ALL;

ENTITY input_ddr_registers IS
   PORT( 
      Data : IN     std_logic_vector (9 DOWNTO 0);
      clk  : IN     std_logic;
      rst  : IN     std_logic;
      sel  : IN     std_logic;
      d    : OUT    std_logic_vector (9 DOWNTO 0)
   );

-- Declarations


END input_ddr_registers ;

-- hds interface_end
ARCHITECTURE rtl_V2 OF input_ddr_registers Is
signal q1 , q2 : std_logic_vector(9 downto 0);
attribute IOB : boolean;
attribute IOB of q1 : signal is true;
attribute IOB of q2 : signal is true;
BEGIN

q1reg : process (clk, data, rst)
	begin
if rst='1' then 					--asynchronous reset, active high
		q1 <= (others => '0');
	elsif clk'event and clk='1' then 	--Clock event - posedge
		q1 <= data;
	end if;

end process;
 	--		d <= q1 when sel = '0' else (others => 'Z');

q2reg : process (clk, data, rst)
	begin
		if rst='1' then --asynchronous reset, active high
			q2 <= (others => '0');
		elsif clk'event and clk='0' then --Clock event - negedge
			q2 <= data;
		end if;
		end process;
	--	  d <= q2 when sel = '1' else (others => 'Z');
	tristaste : process(q1, q2, sel)
	begin
	if sel = '1' then
		d <= q2;
	else
		d <= q1;
	end if;
	end process;
END rtl_V2;
