-- hds header_start
--
-- VHDL Architecture CMSdelay.InputDDR.untitled
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BELMOPAN)
--          at - 10:11:33 10/03/01
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2001.3 (Build 11)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.VITAL_Timing.ALL;
LIBRARY STD;										   
USE STD.TEXTIO.ALL;


-- From Virtex-II Platform FPGA User Guide
entity inputDDR is
Port(
	clk 	: in std_logic;
	rst 	: in std_logic;
	Data	: in std_logic_vector(9 downto 0);
	q1 		: out std_logic_vector(9 downto 0);
	q2 		: out std_logic_vector(9 downto 0)
);

attribute IOB : boolean;
attribute IOB of q1 : signal is true;		-- this line dosnt work you need to turn on Push flip flops into IOB in ISE
attribute IOB of q2 : signal is true;

end inputDDR;
--Describe input DDR registers (behaviorally) to be inferred

architecture behavioral of inputDDR is

begin
q1reg : process (clk, data, rst)
	begin
	if rst='1' then 					--asynchronous reset, active high
		q1 <= (others => '0');
	elsif clk'event and clk='1' then 	--Clock event - posedge
		q1 <= data;
	end if;
end process;


q2reg : process (clk, data, rst)
	begin
		if rst='1' then --asynchronous reset, active high
			q2 <= (others => '0');
		elsif clk'event and clk='0' then --Clock event - negedge
			q2 <= data;
		end if;
end process;

end behavioral;




