-- hds header_start
--
-- VHDL Architecture CMSdelay.counter_blockram.interface
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BELMOPAN)
--          at - 10:09:41 11/07/01
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2001.3 (Build 11)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY counter_blockram IS
   PORT( 
      clk      : IN     std_logic;
      rst      : IN     std_logic;
      fire     : IN     std_logic;
      address  : OUT    std_logic_vector (9 DOWNTO 0);
      write_en : OUT    std_logic;
      done     : OUT    std_logic;
      ena      : IN     std_logic;
      enb      : IN     std_logic
   );

-- Declarations

END counter_blockram ;

-- hds interface_end
ARCHITECTURE rtl OF counter_blockram IS
signal run : std_logic;
BEGIN
process ( clk, rst)
variable count 			: unsigned(9 downto 0);
variable start_count 	: unsigned(9 downto 0);
begin
if rst = '1' then
  	count := ( others => '0');
	start_count := ( others => '0');
  	address <= ( others => '0');
	run <= '0';
	done <= '0';

elsif clk'event and clk = '1' then

	if fire = '1' then 
		start_count := count;
	end if;




	if ena = '1' then 
		-- counter for write
		count := count + 1;
		write_en <= '1';
		address <= conv_std_logic_vector(count,10);
		done <= '0';
	 
	elsif enb = '1' then 
			-- counter for read
	
	 		if (run = '1') then
				count := count + 1;
				address <= conv_std_logic_vector(count,10);
				
			end if;
   		
			if    (count = start_count) then
				run <= '0';
				done <= '1';
			else
				run <= '1';
				done <= '0';
			end if;

	
	end if;	
end if;
end process;
END rtl;
