-- hds header_start
--
-- VHDL Architecture CMSdelay.counter_10bit.interface
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BELMOPAN)
--          at - 12:56:04 10/26/01
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2001.3 (Build 11)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY counter_10bit IS
   PORT( 
      clk              : IN     std_logic;
      rst              : IN     std_logic;
      write_en         : OUT     std_logic;
      write_addr       : OUT    std_logic_vector (9 DOWNTO 0);
      en_write_address : IN     std_logic
   );

-- Declarations

END counter_10bit ;

-- hds interface_end
ARCHITECTURE rtl OF counter_10bit IS
BEGIN
process ( clk, rst)
variable count : unsigned(9 downto 0);
begin
if rst = '1' then
  	count := ( others => '0');
  	write_addr <= ( others => '0');


elsif clk'event and clk = '1' then
	If en_write_address = '1' then
	 	
		count := count + 1;
		write_en <= '1';
		write_addr <= conv_std_logic_vector(count,10);

	 else
		write_en <= '0';

	end if;	
end if;
end process;
END rtl;
