-- hds header_start
--
-- VHDL Architecture CMSdelay.cms_delay_tester.interface
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BELMOPAN)
--          at - 11:04:36 11/09/01
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2001.3 (Build 11)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY cms_delay_tester IS
   PORT( 
      busy                 : IN     std_logic;
      bot_clk_a		       : IN     STD_ULOGIC;
      bot_clk_b		       : IN     STD_ULOGIC;
      top_clk_a            : IN     STD_ULOGIC;
      top_clk_b            : IN     STD_ULOGIC;
      ddr_bot_a			   : IN     std_logic_vector (4 DOWNTO 0);
      ddr_bot_b			   : IN     std_logic_vector (4 DOWNTO 0);
      ddr_top_a			   : IN     std_logic_vector (4 DOWNTO 0);
      ddr_top_b			   : IN     std_logic_vector (4 DOWNTO 0);
      serial_out           : IN     std_logic;
      command_in           : OUT    std_logic;
      top_da		       : OUT    std_logic_vector (9 DOWNTO 0);
      top_db		       : OUT    std_logic_vector (9 DOWNTO 0);
      bot_da		       : OUT    std_logic_vector (9 DOWNTO 0);
      bot_db		       : OUT    std_logic_vector (9 DOWNTO 0);
      reset                : BUFFER std_logic;
      clock                : BUFFER std_logic
   );

-- Declarations

END cms_delay_tester ;

-- hds interface_end
ARCHITECTURE tester OF cms_delay_tester IS
BEGIN
vecgen : process(clock,reset)
  begin

    if (reset = 'U') then
      reset    <= '1' after 0 ns;				-- at start all signals are U ( undifined )
      clock    <= '0' after 0 ns;				-- so set reset to 1 for 10 ns
    end if;
    
    If (reset = '1') then
		reset 	<= '0' after 25 ns;			-- after 10 ns ser rst to zero  
   	end if;									-- this line will zero reset after 10 ns 
											-- nomatter what set it


    -- Main clock loop

    if (clock'event) then					-- clock is activated my an event on its self
      if (clock = '1') then
        clock <= '0' after 12.5 ns;			-- generate clock on 20ns cycle ie 50Mhz
      else
        clock <= '1' after 12.5 ns;
      end if;
    end if;
  end process;
  -- end of clock generation 



  -- data gen. for ch1

   stim_top_a : process(top_clk_a, reset)
variable data_int1 : unsigned (9 downto 0);
begin
	if reset = '1' then 
	
      top_da	    <= (others => '0');
	  data_int1		:= ( others => '0');
  
	elsif top_clk_a'event then
	  	data_int1 := data_int1 + 1;  --data synced to chn. 1
	end if;
	top_da <= conv_std_logic_vector(data_int1,10) after 0.5 ns;

end process;



-- data gen. for ch2

stim_topb : process(top_clk_b, reset)
variable data_int2 : unsigned (9 downto 0);
begin
	if reset = '1' then 
	
      top_db     <= (others => '0');
	  data_int2		:= "0101010011";
  
	elsif top_clk_b'event then
	  	data_int2 := data_int2 + 1;  --data synced to chn. 1
	
	end if;
	
	   	top_db <= conv_std_logic_vector(data_int2,10) after 0.5 ns;
end process;

   -- data gen. for ch3

stim_bota : process(bot_clk_a, reset)
variable data_int3 : unsigned (9 downto 0);
begin
	if reset = '1' then 
	
      bot_da     <= (others => '0');
	  data_int3		:= "1101010011";
  
	elsif bot_clk_a'event then
	  	data_int3 := data_int3 + 1;  --data synced to chn. 1
	end if;
	bot_da <= conv_std_logic_vector(data_int3,10) after 0.5 ns;

end process;

	-- data gen. for ch4

stimd : process(bot_clk_b, reset)
variable data_int4 : unsigned (9 downto 0);
begin
	if reset = '1' then 
	
     bot_db     <= (others => '0');
	  data_int4		:= "1111111111";
  
	elsif bot_clk_b'event then
	  	data_int4 := data_int4 + 1;  --data synced to chn. 1
	end if;
	bot_db <= conv_std_logic_vector(data_int4,10) after 0.5 ns;

end process;

 
 -- start stimulus for item on test
  stim : process
	
 	 begin

	command_in <= '0';	   -- wait for reset
	 wait for 1 us ;
	-- wait for 12.5 ns;	   -- sync to rising edge

	wait for 1250 ns;


	



	command_in <= '1';

	wait for 25 ns;	    	-- send start of message

	command_in <= '0';	    -- If it seems as if theres a bit missing from here then Its because 
							-- data is changing on falling edge not rising edge
	wait for 25 ns;

							-- designator 5 bits
							-- 1=load skew,	6=load coarse, 7=arm, 8=fire,
							-- sk,	cor, 	arm,	fire
							
							
	command_in <= '0';		-- 0,	0,		0,		0,
	
	wait for 25 ns;		    

	command_in <= '0';	    -- 0,	0,		0,		1,

	wait for 25 ns;			

	command_in <= '1';	    -- 0,`  1,		1,		0,

	wait for 25 ns;

	command_in <= '1';	   	-- 0,  	1,		1,		0,

	wait for 25 ns;

	command_in <= '1';	    -- 1,  	0,		1,		0,

	wait for 25 ns;


	command_in <= '0'; 		-- blank bit

	wait for 25 ns;

	command_in <= '1'; 		-- start of length signifier

	wait for 25 ns;




	 

	command_in <= '0';  	-- MSB of length 

	wait for 25 ns;

	command_in <= '0';

	wait for 25 ns;

	command_in <= '0';

	wait for 25 ns;			     -- the combined length of the data packets to follow

	command_in <= '0';		     -- ie skew is 4 sets of 5 bits + 4 sets of 5 bits so length = 36

	wait for 25 ns;			     

	command_in <= '0';

	wait for 25 ns;

	command_in <= '0';

	wait for 25 ns;

	command_in <= '0';

	wait for 25 ns;

	command_in <= '0';

	wait for 25 ns;

	command_in <= '0';

	wait for 25 ns;

	command_in <= '0';

	wait for 25 ns;

	command_in <= '0';

	wait for 25 ns;

	command_in <= '1';

	wait for 25 ns;

	command_in <= '1';

	wait for 25 ns; 

	command_in <= '1';

	wait for 25 ns;

	command_in <= '1';

	wait for 25 ns; 

	command_in <= '1';

	wait for 25 ns;		    -- LSB of length





	
	

	command_in <= '0';	-- make sure its at zero when finished

		 wait;  
	end process;


END tester;
