#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e "s/${PKG}\-//" -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e "s/${PKG}\-${VER}\-//"`
export FULLPKG=${PKG}-${VER}-${REL}

# determine correct decompression option and tarball filename
if [ -e ${PKG}-${VER}-src.tar.gz ] ; then
  export opt_decomp=z
  export src_orig_pkg_ext=gz
elif [ -e ${PKG}-${VER}-src.tar.bz2 ] ; then
  export opt_decomp=j
  export src_orig_pkg_ext=bz2
fi

export src_orig_pkg_name=${PKG}-${VER}-src.tar.${src_orig_pkg_ext}
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export srcdir=${topdir}/${PKG}-${VER}-${REL}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
# run on
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-cygwin
prefix=/usr
sysconfdir=/etc

MY_CFLAGS='-Wall -O2'
MY_LDFLAGS='-s -Wl,--stack=0x00800000'
MY_CXXFLAGS='-O2'

export TCL_LIBRARY=/usr/share/tcl8.4
export DEJAGNULIBS=/usr/share/dejagnu

# The directories that should be part of the various language-specific
# tar files.  These are all relative to the top of the source tree.
SOURCE_DIRECTORY=${PKG}-${VER}-${REL}

ADA_DIRS="${SOURCE_DIRECTORY}/gcc/ada"
CPLUSPLUS_DIRS="${SOURCE_DIRECTORY}/gcc/cp ${SOURCE_DIRECTORY}/libstdc++-v3"
FORTRAN_DIRS="${SOURCE_DIRECTORY}/gcc/f ${SOURCE_DIRECTORY}/libf2c"
JAVA_DIRS="${SOURCE_DIRECTORY}/gcc/java ${SOURCE_DIRECTORY}/libjava ${SOURCE_DIRECTORY}/libffi ${SOURCE_DIRECTORY}/fastjar ${SOURCE_DIRECTORY}/zlib ${SOURCE_DIRECTORY}/boehm-gc"
OBJECTIVEC_DIRS="${SOURCE_DIRECTORY}/gcc/objc ${SOURCE_DIRECTORY}/libobjc"
TESTSUITE_DIRS="${SOURCE_DIRECTORY}/gcc/testsuite"
GPC_DIRS="${SOURCE_DIRECTORY}/gcc/p"

# all available = c,c++,f77,objc,ada,java,pascal
languages_to_build="c"

all_source_packages="${PKG}-core-${VER}-${REL}-src.tar.bz2\
 ${PKG}-ada-${VER}-${REL}-src.tar.bz2\
 ${PKG}-g++-${VER}-${REL}-src.tar.bz2\
 ${PKG}-g77-${VER}-${REL}-src.tar.bz2\
 ${PKG}-gpc-${VER}-${REL}-src.tar.bz2\
 ${PKG}-java-${VER}-${REL}-src.tar.bz2\
 ${PKG}-objc-${VER}-${REL}-src.tar.bz2\
 ${PKG}-testsuite-${VER}-${REL}-src.tar.bz2"

# This is the main DESTDIR target:
PKG1=${instdir}/package-gcc

# These are the directories to build other packages in:
PKG2=${instdir}/package-gcc-g++
PKG3=${instdir}/package-gcc-g77
PKG4=${instdir}/package-gcc-gnat
PKG5=${instdir}/package-gcc-java
PKG6=${instdir}/package-gcc-objc
PKG7=${instdir}/package-gcc-gpc

# Main script

mkdirs() {
  (cd ${topdir} && \
   rm -fr ${objdir} ${instdir} ${srcinstdir} && \
   mkdir -p ${objdir} && \
   mkdir -p ${instdir} && \
   mkdir -p ${srcinstdir} 
  )
}
prep() {
  (cd ${topdir} && \
   tar xvjf ${PKG}-core-${VER}-${REL}-src.tar.bz2 && \
   if [ -f ${PKG}-ada-${VER}-${REL}-src.tar.bz2 ] ; then
     tar xvjf ${PKG}-ada-${VER}-${REL}-src.tar.bz2
   fi
   if [ -f ${PKG}-g++-${VER}-${REL}-src.tar.bz2 ] ; then
     tar xvjf ${PKG}-g++-${VER}-${REL}-src.tar.bz2 
   fi
   if [ -f ${PKG}-g77-${VER}-${REL}-src.tar.bz2 ] ; then
     tar xvjf ${PKG}-g77-${VER}-${REL}-src.tar.bz2
   fi
   if [ -f ${PKG}-gpc-${VER}-${REL}-src.tar.bz2 ] ; then
     tar xvjf ${PKG}-gpc-${VER}-${REL}-src.tar.bz2
   fi
   if [ -f ${PKG}-java-${VER}-${REL}-src.tar.bz2 ] ; then
     tar xvjf ${PKG}-java-${VER}-${REL}-src.tar.bz2
   fi
   if [ -f ${PKG}-objc-${VER}-${REL}-src.tar.bz2 ] ; then
     tar xvjf ${PKG}-objc-${VER}-${REL}-src.tar.bz2
   fi
   if [ -f ${PKG}-testsuite-${VER}-${REL}-src.tar.bz2 ] ; then
     tar xvjf ${PKG}-testsuite-${VER}-${REL}-src.tar.bz2
   fi
   cd ${topdir} && \
   mkdirs && \
   patch -p0<${src_patch_name} )
}
# configure is interactive when building pascal front end
conf() {
  (# check which front ends are available to build
   if [ -d ${PKG}-${VER}-${REL}/gcc/ada ] ; then
     languages_to_build="${languages_to_build},ada"
   fi
   if [ -d ${PKG}-${VER}-${REL}/gcc/cp ] ; then
     languages_to_build="${languages_to_build},c++"
   fi
   if [ -d ${PKG}-${VER}-${REL}/gcc/f ] ; then
     languages_to_build="${languages_to_build},f77"
   fi
   if [ -d ${PKG}-${VER}-${REL}/gcc/p ] ; then
     languages_to_build="${languages_to_build},pascal"
   fi
   if [ -d ${PKG}-${VER}-${REL}/gcc/java ] ; then
     languages_to_build="${languages_to_build},java"
   fi
   if [ -d ${PKG}-${VER}-${REL}/gcc/objc ] ; then
     languages_to_build="${languages_to_build},objc"
   fi
   cd ${objdir} && \
   CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" CXXFLAGS="${MY_CXXFLAGS}" \
   ${srcdir}/configure \
	--with-gcc --with-gnu-ld --with-gnu-as --prefix=/usr \
	--exec-prefix=/usr --sysconfdir=/etc --libdir=/usr/lib \
	--libexecdir=/usr/sbin 	--mandir=/usr/share/man \
	--infodir=/usr/share/info \
	--enable-languages=${languages_to_build} \
	--enable-libgcj --enable-threads=posix --with-system-zlib \
	--enable-nls --without-included-gettext \
	--enable-interpreter --enable-sjlj-exceptions \
	--disable-version-specific-runtime-libs \
	--enable-shared --disable-win32-registry \
	--enable-java-gc=boehm --disable-hash-synchronization \
	--verbose --target=${target} --host=${host} --build=${host} )
}
build() {
  (cd ${objdir} && \
   make BOOT_CFLAGS='-O2 -march=i486 -mcpu=i686' \
       STAGE1_CFLAGS='-O2 -march=i486 -mcpu=i686' \
       CFLAGS='-O2 -march=i486 -mcpu=i686' \
       CXXFLAGS='-O2 -march=i486 -mcpu=i686' \
       LIBCFLAGS='-O2 -march=i486 -mcpu=i686' \
       LIBCXXFLAGS='-O2 -march=i486 -mcpu=i686 -fno-implicit-templates' \
       JCFLAGS='-O2 -march=i486 -mcpu=i686' \
       GCJFLAGS='-O2 -march=i486 -mcpu=i686' \
       LIBGCJ_CFLAGS='-O2 -march=i486 -mcpu=i686 -D__NO_MATH_INLINES -ffloat-store' \
       LIBGCJ_CXXFLAGS='-O2 -march=i486 -mcpu=i686 -D__NO_MATH_INLINES -ffloat-store -fno-implicit-templates' \
       LDFLAGS='-s -Wl,--stack=0x00800000' \
        bootstrap
   ( cd gcc && \
     make CFLAGS=-O2 GNATLIBCFLAGS=-O2 \
          LDFLAGS='-s -Wl,--stack=0x00800000' \
           gnatlib_and_tools    ) && \
   make info
  )
}
check() {
  (cd ${objdir} && \
   make -k check | tee ${checkfile} 2>&1 )
}
clean() {
  (cd ${objdir} && \
   make clean )
}
install() {
  (cd ${objdir} && \
   make install prefix=${PKG1}${prefix} exec_prefix=${PKG1}${prefix} \
    bindir=${PKG1}${prefix}/bin libdir=${PKG1}${prefix}/lib \
    sysconfdir=${PKG1}etc includedir=${PKG1}${prefix}/include \
    mandir=${PKG1}${prefix}/share/man infodir=${PKG1}${prefix}/share/info \
    tooldir=${PKG1}${prefix} && \
   make -i install-info prefix=${PKG1}${prefix} exec_prefix=${PKG1}${prefix} \
    bindir=${PKG1}${prefix}/bin libdir=${PKG1}${prefix}/lib \
    sysconfdir=${PKG1}etc includedir=${PKG1}${prefix}/include \
    mandir=${PKG1}${prefix}/share/man infodir=${PKG1}${prefix}/share/info \
    tooldir=${PKG1}${prefix} )
}
install2() {
  (cd ${objdir} && \
   rm -f ${PKG1}${prefix}/lib/libiberty.a && \
   ( cd ${PKG1}${prefix}/bin && \
    mv -f ${target}-gcc-${VER} ${target}-gcc-${VER}.exe && \
    rm -f ${target}-c++.exe  && \
    rm -f ${target}-g++.exe && \
    rm -f ${target}-gcc.exe && \
    rm -f ${target}-gcj.exe && \
    ln -sf g77.exe f77.exe && \
    ln -sf gcc.exe cc.exe && \
    ln -sf g++.exe c++.exe && \
    ln -sf gcc.exe ${target}-gcc.exe && \
    ln -sf g++.exe ${target}-c++.exe && \
    ln -sf g++.exe ${target}-g++.exe && \
    ln -sf gcj.exe ${target}-gcj.exe ) && \
   ( cd ${PKG1}${prefix}/share/info ; rm -f dir ; gzip -fq9 * ) && \
   ( cd ${PKG1}${prefix}/share/man && \
    gzip -fq9 */* && \
    cd man1 && \
    ln -sf g++.1.gz c++.1.gz && \
    ln -sf g77.1.gz f77.1.gz && \
    ln -sf gcc.1.gz cc.1.gz && \
    cd ${PKG1}${prefix}/share/info && \
    ln -sf fastjar.info.gz jar.info.gz ) && \
   ( cd ${srcdir} && \
    mkdir -p ${PKG1}${prefix}/share/doc/Cygwin && cp ${topdir}/gcc-${VER}-${REL}.README ${PKG1}${prefix}/share/doc/Cygwin && \
    mkdir -p ${PKG7}${prefix}/share/doc/Cygwin && cp ${topdir}/gcc-gpc-${VER}-${REL}.README ${PKG7}${prefix}/share/doc/Cygwin && \
    mkdir -p ${PKG1}${prefix}/share/doc/${PKG}-${VER}-${REL} && \
    cp -a \
      BUGS COPYING COPYING.LIB ChangeLog FAQ INSTALL MAINTAINERS README* *.html \
      ${PKG1}${prefix}/share/doc/${PKG}-${VER}-${REL} && \
    mkdir -p ${PKG1}${prefix}/share/doc/${PKG}-${VER}-${REL}/gcc && \
    mkdir -p ${PKG3}${prefix}/share/doc/${PKG}-${VER}-${REL}/gcc/f && \
    mkdir -p ${PKG3}${prefix}/share/doc/Cygwin && cp ${topdir}/gcc-g77-${VER}-${REL}.README ${PKG3}${prefix}/share/doc/Cygwin && \
    mkdir -p ${PKG4}${prefix}/share/doc/${PKG}-${VER}-${REL}/gnat && \
    mkdir -p ${PKG4}${prefix}/share/doc/Cygwin && cp ${topdir}/gcc-ada-${VER}-${REL}.README ${PKG4}${prefix}/share/doc/Cygwin && \
    mkdir -p ${PKG6}${prefix}/share/doc/${PKG}-${VER}-${REL}/gcc/objc && \
    mkdir -p ${PKG6}${prefix}/share/doc/Cygwin && cp ${topdir}/gcc-objc-${VER}-${REL}.README ${PKG6}${prefix}/share/doc/Cygwin && \
    ( cd gcc && \
      cp -a ABOUT* COPYING* LANG* NEWS README* SERVICE \
         ${PKG1}${prefix}/share/doc/${PKG}-${VER}-${REL}/gcc && \
      cd f && \
      cp -a BUGS NEWS README RELEASE-PREP \
         ${PKG3}${prefix}/share/doc/${PKG}-${VER}-${REL}/gcc/f && \
      cd ../objc && \
      cp -a README ${PKG6}${prefix}/share/doc/${PKG}-${VER}-${REL}/gcc/objc && \
      cd ../ada && \
      cp -a ChangeLog \
         ${PKG4}${prefix}/share/doc/${PKG}-${VER}-${REL}/gnat ) && \
    mkdir -p ${PKG5}${prefix}/share/doc/${PKG}-${VER}-${REL}/fastjar && \
    mkdir -p ${PKG5}${prefix}/share/doc/Cygwin && cp ${topdir}/gcc-java-${VER}-${REL}.README ${PKG5}${prefix}/share/doc/Cygwin && \
    ( cd fastjar && \
      cp -a \
        AUTHORS CHANGES COPYING ChangeLog NEWS README \
        ${PKG5}${prefix}/share/doc/${PKG}-${VER}-${REL}/fastjar  ) && \
    mkdir -p ${PKG3}${prefix}/share/doc/${PKG}-${VER}-${REL}/libf2c && \
    mkdir -p ${PKG3}${prefix}/share/doc/${PKG}-${VER}-${REL}/libf2c/libF77 && \
    mkdir -p ${PKG3}${prefix}/share/doc/${PKG}-${VER}-${REL}/libf2c/libI77 && \
    mkdir -p ${PKG3}${prefix}/share/doc/${PKG}-${VER}-${REL}/libf2c/libU77 && \
    ( cd libf2c && \
      cp -a \
        README TODO disclaimer.netlib permission.netlib readme.netlib \
        ${PKG3}${prefix}/share/doc/${PKG}-${VER}-${REL}/libf2c && \
        ( cd libF77 && \
          cp -a Notice README.netlib \
            ${PKG3}${prefix}/share/doc/${PKG}-${VER}-${REL}/libf2c/libF77 ) && \
        ( cd libI77 && \
          cp -a Notice README.netlib \
            ${PKG3}${prefix}/share/doc/${PKG}-${VER}-${REL}/libf2c/libI77 ) && \
        ( cd libU77 && \
          cp -a COPYING.LIB PROJECTS README \
            ${PKG3}${prefix}/share/doc/${PKG}-${VER}-${REL}/libf2c/libU77 )) && \
    mkdir -p ${PKG5}${prefix}/share/doc/${PKG}-${VER}-${REL}/libjava && \
    ( cd libjava && \
      cp -a \
        COPYING ChangeLog HACKING LIBGCJ_LICENSE NEWS README THANKS \
        ${PKG5}${prefix}/share/doc/${PKG}-${VER}-${REL}/libjava  ) && \
    mkdir -p ${PKG6}${prefix}/share/doc/${PKG}-${VER}-${REL}/libobjc && \
    ( cd libobjc && \
      cp -a README README.threads THREADS THREADS.MACH \
        ${PKG6}${prefix}/share/doc/${PKG}-${VER}-${REL}/libobjc ) && \
    mkdir -p ${PKG2}${prefix}/share/doc/${PKG}-${VER}-${REL}/libstdc++-v3 && \
    mkdir -p ${PKG2}${prefix}/share/doc/Cygwin && cp ${topdir}/gcc-g++-${VER}-${REL}.README ${PKG2}${prefix}/share/doc/Cygwin && \
    ( cd libstdc++-v3 && \
      cp -a README ${PKG2}${prefix}/share/doc/${PKG}-${VER}-${REL}/libstdc++-v3 && \
      cp -a docs/html/faq/index.html ${PKG2}${prefix}/share/doc/${PKG}-${VER}-${REL}/libstdc++-v3/faq.html     )
   ) && \
    mkdir -p ${PKG7}/usr/share/doc/${PKG}-${VER}-${REL}/ && \
    mv ${PKG1}/usr/doc/gpc ${PKG7}/usr/share/doc/${PKG}-${VER}-${REL}/ && \
    rm -rf ${PKG1}/usr/doc 
  )
}
strip_exe() {
  (cd ${instdir} && \
    find . | xargs file | grep "MS Windows PE 32-bit Intel 80386 console executable not relocatable" | grep 80386 | cut -f 1 -d : | xargs strip --strip-unneeded
    find ${PKG1}/usr/lib/gcc-lib -name "*.a" | xargs strip -g && \
    touch ${PKG1}/usr/lib/libgcj.a && \
   true )
}
pre_pkg() {
  (cd ${instdir} && \
   ( cd ${PKG1} && \
    for file in `find . -type f -name "*.la"` ; do
      cat $file | sed -e 's%-L/gcc/[[:graph:]]* % %g' > ${TMP}/tmp-la-file
      cat ${TMP}/tmp-la-file > $file
    done && \
    rm ${TMP}/tmp-la-file ) && \
    ( cd ${PKG2} && \
      mkdir -p usr/bin && \
      mv ${PKG1}/usr/bin/*++* usr/bin && \
      mkdir -p usr/include && \
      mv ${PKG1}/usr/include/c++ usr/include && \
      mkdir -p usr/lib && \
      mv ${PKG1}/usr/lib/*++* usr/lib && \
      mkdir -p usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/cc1plus.exe usr/lib/gcc-lib/${target}/${VER} && \
      mkdir -p usr/share/man/man1 && \
      mv ${PKG1}/usr/share/man/man1/*++* usr/share/man/man1 )
    ( cd ${PKG3} && \
      mkdir -p usr/bin && \
      mv ${PKG1}/usr/bin/*77* usr/bin && \
      mkdir -p usr/share/info && \
      mv ${PKG1}/usr/share/info/g77* usr/share/info && \
      mkdir -p usr/lib && \
      mv ${PKG1}/usr/lib/libfrtbegin.a usr/lib && \
      mv ${PKG1}/usr/lib/libg2c* usr/lib && \
      mkdir -p usr/lib/gcc-lib/${target}/${VER}/include && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/f771.exe usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/include/g2c.h usr/lib/gcc-lib/${target}/${VER}/include && \
      mkdir -p usr/share/man/man1 && \
      mv ${PKG1}/usr/share/man/man1/*77* usr/share/man/man1 )
    ( cd ${PKG4} && \
      mkdir -p usr/bin && \
      mv ${PKG1}/usr/bin/gnat* usr/bin && \
      mkdir -p usr/share/info && \
      mv ${PKG1}/usr/share/info/gnat* usr/share/info && \
      mkdir -p usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/gnat1.exe usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/adainclude usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/adalib usr/lib/gcc-lib/${target}/${VER} )
    ( cd ${PKG5} && \
      mkdir -p usr/bin && \
      mv ${PKG1}/usr/bin/addr2name.awk usr/bin && \
      mv ${PKG1}/usr/bin/*gcj* usr/bin && \
      mv ${PKG1}/usr/bin/gij.exe usr/bin && \
      mv ${PKG1}/usr/bin/grepjar.exe usr/bin && \
      mv ${PKG1}/usr/bin/jar.exe usr/bin && \
      mv ${PKG1}/usr/bin/jcf-dump.exe usr/bin && \
      mv ${PKG1}/usr/bin/jv-* usr/bin && \
      mv ${PKG1}/usr/bin/rmi* usr/bin && \
      mkdir -p usr/include && \
      mv ${PKG1}/usr/include/gcj usr/include && \
      mv ${PKG1}/usr/include/gnu usr/include && \
      mv ${PKG1}/usr/include/java usr/include && \
      mv ${PKG1}/usr/include/javax usr/include && \
      mv ${PKG1}/usr/include/jni.h usr/include && \
      mv ${PKG1}/usr/include/jvmpi.h usr/include && \
      mv ${PKG1}/usr/include/ffi.h usr/include && \
      mv ${PKG1}/usr/include/ffi_mips.h usr/include && \
      mv ${PKG1}/usr/include/fficonfig.h usr/include && \
      mkdir -p usr/share/info && \
      mv ${PKG1}/usr/share/info/gcj.* usr/share/info && \
      mv ${PKG1}/usr/share/info/fastjar.info.gz usr/share/info && \
      mv ${PKG1}/usr/share/info/jar.info.gz usr/share/info && \
      mkdir -p usr/lib/gcc-lib/${target}/${VER}/include && \
      mv ${PKG1}/usr/lib/libgcj* usr/lib && \
      mv ${PKG1}/usr/lib/libffi* usr/lib && \
      mv ${PKG1}/usr/lib/lib-org* usr/lib && \
      mv ${PKG1}/usr/lib/security usr/lib && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/jc1.exe usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/jvgenmain.exe usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/include/gcj usr/lib/gcc-lib/${target}/${VER}/include && \
      mkdir -p usr/share/man/man1 && \
      mv ${PKG1}/usr/share/man/man1/gcj.1.gz usr/share/man/man1 && \
      mv ${PKG1}/usr/share/man/man1/gcjh.1.gz usr/share/man/man1 && \
      mv ${PKG1}/usr/share/man/man1/gij.1.gz usr/share/man/man1 && \
      mv ${PKG1}/usr/share/man/man1/grepjar.1.gz usr/share/man/man1 && \
      mv ${PKG1}/usr/share/man/man1/jar.1.gz usr/share/man/man1 && \
      mv ${PKG1}/usr/share/man/man1/jcf-dump.1.gz usr/share/man/man1 && \
      mv ${PKG1}/usr/share/man/man1/jv-convert.1.gz usr/share/man/man1 && \
      mv ${PKG1}/usr/share/man/man1/jv-scan.1.gz usr/share/man/man1 && \
      mv ${PKG1}/usr/share/man/man1/rmic.1.gz usr/share/man/man1 && \
      mv ${PKG1}/usr/share/man/man1/rmiregistry.1.gz usr/share/man/man1 && \
      mv ${PKG1}/usr/share/java usr/share )
    ( cd ${PKG6} && \
      mkdir -p usr/lib && \
      mv ${PKG1}/usr/lib/libobjc* usr/lib && \
      mkdir -p usr/lib/gcc-lib/${target}/${VER}/include && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/cc1obj.exe usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/include/objc usr/lib/gcc-lib/${target}/${VER}/include )
    ( cd ${PKG7} && \
      mkdir -p usr/bin && \
      mv ${PKG1}/usr/bin/binobj.exe usr/bin && \
      mv ${PKG1}/usr/bin/gpidump.exe usr/bin && \
      mv ${PKG1}/usr/bin/gpc* usr/bin && \
      mkdir -p usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/*gpc* usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/units usr/lib/gcc-lib/${target}/${VER} && \
      mkdir -p usr/share/info && \
      mv ${PKG1}/usr/share/info/gpc* usr/share/info && \
      mkdir -p usr/share/man/man1 && \
      mv ${PKG1}/usr/share/man/man1/gp* usr/share/man/man1 && \
      mkdir -p usr/share/doc/${PKG}-${VER}-${REL} && \
      mv ${PKG1}/usr/share/doc/${PKG}-${VER}-${REL}/gpc usr/share/doc/${PKG}-${VER}-${REL} )
    rm -rf ${PKG1}/usr/include )
}
pkg() {
  (cd ${instdir} && \
   ( cd ${PKG1} && \
    ( cd ${PKG1} && \
      tar cjvf ${topdir}/${PKG}-${VER}-${REL}.tar.bz2 usr/  && \
    )
    ( cd ${PKG2} && \
      tar cjvf ${topdir}/${PKG}-g++-${VER}-${REL}.tar.bz2 usr/  && \
    )
    ( cd ${PKG3} && \
      tar cjvf ${topdir}/${PKG}-g77-${VER}-${REL}.tar.bz2 usr/  && \
    )
    ( cd ${PKG4} && \
      tar cjvf ${topdir}/${PKG}-ada-${VER}-${REL}.tar.bz2 usr/  && \
    )
    ( cd ${PKG5} && \
      tar cjvf ${topdir}/${PKG}-java-${VER}-${REL}.tar.bz2 usr/  && \
    )
    ( cd ${PKG6} && \
      tar cjvf ${topdir}/${PKG}-objc-${VER}-${REL}.tar.bz2 usr/  && \
    )
    ( cd ${PKG7} && \
      tar cjvf ${topdir}/${PKG}-gpc-${VER}-${REL}.tar.bz2 usr/  && \
    )
  )
 )
}
mkpatch() {
  (cd ${srcdir} && \
  for i in ${all_source_packages}; do tar xvjf ../${i} ; done ;\
  mv ${PKG}-${VER}-${REL} ../${PKG}-${VER}-${REL}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' -x 'CVS' -x 'MinGW' \
    ${PKG}-${VER}-${REL}-orig ${PKG}-${VER}-${REL} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${PKG}-${VER}-${REL}-orig )
}
spkg() {
  (mkpatch && \
  patch -R -p0<${srcinstdir}/${src_patch_name} && \
  chmod -R a+r ${SOURCE_DIRECTORY} && \
  find ${SOURCE_DIRECTORY} -type d -exec chmod 777 {} \; && \
  tar cjvf ${PKG}-${VER}-src.tar.bz2 \
      --exclude MinGW --exclude CVS \
      --exclude .build --exclude .inst --exclude .sinst ${SOURCE_DIRECTORY} && \
  tar cjvf ${PKG}-ada-${VER}-${REL}-src.tar.bz2 --exclude CVS ${ADA_DIRS} && \
  tar cjvf ${PKG}-g++-${VER}-${REL}-src.tar.bz2 --exclude CVS ${CPLUSPLUS_DIRS} && \
  tar cjvf ${PKG}-g77-${VER}-${REL}-src.tar.bz2 --exclude CVS ${FORTRAN_DIRS} && \
  tar cjvf ${PKG}-java-${VER}-${REL}-src.tar.bz2 --exclude CVS ${JAVA_DIRS} && \
  tar cjvf ${PKG}-objc-${VER}-${REL}-src.tar.bz2 --exclude CVS ${OBJECTIVEC_DIRS} && \
  tar cjvf ${PKG}-testsuite-${VER}-${REL}-src.tar.bz2 --exclude CVS ${TESTSUITE_DIRS} && \
  tar cjvf ${PKG}-gpc-${VER}-${REL}-src.tar.bz2 --exclude CVS ${GPC_DIRS} && \
  EXCLUDES="--exclude MinGW --exclude CVS --exclude .build --exclude .inst --exclude .sinst" && \
  for x in ${ADA_DIRS} ${CPLUSPLUS_DIRS} ${FORTRAN_DIRS} \
    ${JAVA_DIRS} ${OBJECTIVEC_DIRS} ${TESTSUITE_DIRS} \
    ${GPC_DIRS}; do
    EXCLUDES="${EXCLUDES} --exclude $x"
  done && \
  cp -f ${srcinstdir}/${src_patch_name} ./${src_patch_name} && \
  tar cjvf ${PKG}-core-${VER}-${REL}-src.tar.bz2 ${EXCLUDES} \
    ${SOURCE_DIRECTORY} `basename $0` ${src_patch_name} *.README && \
  cp ${all_source_packages} ${srcinstdir}/ && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cp *.README ${srcinstdir}/ && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * && \
  cd ${topdir} && \
  patch -p0<${srcinstdir}/${src_patch_name}
 )
}
finish() {
  rm -rf ${srcdir} 
}
case $1 in
  prep*)	prep ; STATUS=$? ;;
  mkdirs)	mkdirs; STATUS=$? ;;
  conf*)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  install2)	install2 ; STATUS=$? ;;
  strip_exe)	strip_exe ; STATUS=$? ;;
  pre_pkg)	pre_pkg ; STATUS=$? ;;
  pkg)		pkg ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  mkpatch)	mkpatch ; STATUS=$? ;;
  spkg)		spkg ; STATUS=$? ;;
  finish) 	finish ; STATUS=$? ;;
  all) conf && build && install && install2 && \
     strip_exe && pre_pkg && pkg && spkg ; \
	  STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}

