/* This file is part of the KDE libraries
    Copyright (C) 1997, 1998 Sven Radej (sven@lisa.exp.univie.ac.at)
    Copyright (C) 1997 Matthias Ettrich (ettrich@kde.org)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

//$Id: kmenubar.h,v 1.1.1.1 2001/05/20 08:14:53 habacker Exp $
//$Log: kmenubar.h,v $
//Revision 1.1.1.1  2001/05/20 08:14:53  habacker
//original version 1.1.2
//
//Revision 1.15.4.3  1999/05/29 18:55:00  denis
//Broken files repaired.
//It looks like nothing has missed.
//
//Revision 1.15.4.2  1999/04/18 18:36:27  radej
//sven: Docs.
//
//Revision 1.15.4.1  1999/03/24 16:48:57  ettrich
//workaround for qt-1.44 behaviour
//
//Revision 1.15  1998/12/16 01:27:14  ettrich
//fixed slightly broken macstyle removal
//
//Revision 1.14  1998/11/25 13:24:53  radej
//sven: Someone changed protected things to private (was it me?).
//
//Revision 1.13  1998/11/23 15:34:05  radej
//sven: Nicer sysmenu button
//
//Revision 1.12  1998/11/22 13:35:47  radej
//sven: IMPROVED Mac menubar: Accelerators, SystemMenu, look...
//
//Revision 1.11  1998/11/15 09:22:59  garbanzo
//Clean up kmenubar.h
//
//Revision 1.10  1998/11/11 14:32:12  radej
//sven: *Bars can be made flat by MMB (Like in Netscape, but this works)
//
//Revision 1.9  1998/08/31 00:52:12  torben
//Torben: One new function and made others virtual
//=> binary incompatible. Sorry. Please use virtual whenever it is
//not a performance problem.
//
//Revision 1.8  1998/05/07 23:13:23  radej
//Moving with KToolBoxManager
//

#ifndef _KMENUBAR_H
#define _KMENUBAR_H

#include <qmenubar.h>

class KToolBoxManager;

class _menuBar : public QMenuBar
 {
   Q_OBJECT

 public:
   _menuBar(QWidget *parent=0, const char *name=0);
   ~_menuBar();
protected:
     void resizeEvent( QResizeEvent* );
 };

/**
 * This is floatable toolbar. It can be set to float, Top, or Bottom
 * of KTopLevelWidget. It can be used without KTopLevelWidget, but
 * then you should maintain items (toolbars, menubar, statusbar)
 * yourself.
 *
 * Interface is the same as QMenuBar, except that you can't
 * add pixmaps.
 *
 * If you want to add other methods for 100% compatibility with QMenuBar
 * just add those methods, and pass all arguments ot menu bar.
 * see kmenubar.cpp for details. It is extremly simple.
 * @short KDE floatable menubar
 */
class KMenuBar : public QFrame
 {
   Q_OBJECT

 public:

   /**
    * Positions of menubar.
    */
   enum menuPosition{Top, Bottom, Floating, Flat, FloatingSystem};

   /**
    * Constructor. For all details about inserting items see
    * @ref QMenuBar
    */
   KMenuBar( QWidget *parent=0, const char *name=0);

   /**
    * Destructor. Embeds menubar back if floating. Delete menubar
    * in your destructor or closeEvent for 100% safety
    */
   ~KMenuBar();

   /**
    * Enable or disable moving. This only disables user moving
    * menubar can be moved wit @ref #setMenuBarPos.
    */
   void enableMoving(bool flag = TRUE);

   /**
    * Returns menubar position.
    */
   menuPosition menuBarPos() {return position;};

   /**
    * Enables/disables floating.
    */
   void enableFloating(bool flag = TRUE);

   /**
    * Sets position. Can be used when floating or moving is disabled.
    * This cannot be used to set toolbar flat. For that, use @ref setFlat .
    */
   void setMenuBarPos(menuPosition mpos);

   /**
    * Sets title for floating menu bar. Default is Main widget title.
    */
   void setTitle(const char *_title) {title = _title;};

   /**
    * The rest is standard QMenuBar interface. See Qt docs for
    * details.
    */
   virtual uint count();
   virtual int insertItem(const char *text,
                  const QObject *receiver, const char *member,
                  int accel=0 );

   virtual int insertItem(const char *text, int id=-1, int index=-1 );
   virtual int insertItem(const char *text, QPopupMenu *popup,
                  int id=-1, int index=-1 );

   virtual void insertSeparator(int index=-1 );
   virtual void removeItem(int id);
   virtual void removeItemAt(int index);
   virtual void clear();
   virtual int accel(int id);
   virtual void setAccel(int key, int id );
   virtual const char *text(int id);
   virtual void changeItem(const char *text, int id);
   virtual void setItemChecked(int id , bool flag);
   virtual void setItemEnabled(int id, bool flag);
   virtual int idAt( int index );

   int heightForWidth ( int max_width ) const;

   /**
   * This method switches flat/unflat mode. Carefull: might not work
   * If menubar is floating.
   */
   void setFlat (bool);

 protected slots:
   void ContextCallback(int index);
   void slotActivated (int id);
   void slotHighlighted (int id);
   void slotReadConfig ();
   void slotHotSpot (int i);

 protected:
   void init();
   void mousePressEvent ( QMouseEvent *m );
   void resizeEvent( QResizeEvent *e );
   void paintEvent(QPaintEvent *);
   void closeEvent (QCloseEvent *e);
   void leaveEvent (QEvent *e);
   bool eventFilter(QObject *, QEvent *);

private:
   bool moving;
   QWidget *Parent;
   int oldX;
   int oldY;
   int oldWFlags;
   const char *title;
   menuPosition position;
   menuPosition lastPosition;
   menuPosition movePosition;

   QPopupMenu *context;
   QMenuBar *menu;
   QFrame *frame;

signals:
    /**
     * This signal is connected to @ref KTopLevel::updateRects. It is
     * emited when menu bar changes its position.
     */
    void moved (menuPosition);

    /**
     * This signal is emited when item id is highlighted.
     */
    void highlighted(int id);

    /**
     * This signal is emited when item id is activated.
     */
    void activated(int id);

private:
   QFrame *handle;
   QPoint pointerOffset;
   QPoint parentOffset;
   int oldMenuFrameStyle;
   KToolBoxManager *mgr;
   bool highlight;
   bool transparent;
 };

#endif
