#!/bin/sh
#
# iu-config, Copyright 2001, Red Hat Inc.
#
# This file is part of the Cygwin port of Berkley inetutils.

# set -x

# Subdirectory where the new package is being installed
PREFIX=/usr

# Directory where the config files are stored
SYSCONFDIR=/etc

progname=$0
auto_answer=""

request()
{
  if [ "${auto_answer}" = "yes" ]
  then
    return 0
  elif [ "${auto_answer}" = "no" ]
  then
    return 1
  fi

  answer=""
  while [ "X${answer}" != "Xyes" -a "X${answer}" != "Xno" ]
  do
    echo -n "$1 (yes/no) "
    read answer
  done
  if [ "X${answer}" = "Xyes" ]
  then
    return 0
  else
    return 1
  fi
}

# Check how the script has been started.  If it has been started by
# giving the full path and that path is /etc/postinstall, set
# auto_answer to "no".  This allows automatic creation of the
# config files in /etc w/o overwriting them if they already exist.
progdir=`dirname $0`
if [ "$progdir" = "/etc/postinstall" ]
then
  auto_answer="no"
fi

# Check options

while :
do
  case $# in
  0)
    break
    ;;
  esac

  option=$1
  shift

  case "$option" in
  -d | --debug )
    set -x
    ;;

  -y | --yes )
    auto_answer=yes
    ;;

  -n | --no )
    auto_answer=no
    ;;
  *)
    echo "usage: ${progname} [OPTION]..."
    echo
    echo "This script creates an OpenSSH host configuration."
    echo
    echo "Options:"
    echo "    --debug  -d     Enable shell's debug output."
    echo "    --yes    -y     Answer all questions with \"yes\" automatically."
    echo "    --no     -n     Answer all questions with \"no\" automatically."
    echo
    exit 1
    ;;

  esac
done

# Check for ${SYSCONFDIR} directory

if [ -e "${SYSCONFDIR}" -a ! -d "${SYSCONFDIR}" ]
then
  echo
  echo "${SYSCONFDIR} is existant but not a directory."
  echo "Cannot create global configuration files."
  echo
  exit 1
fi

# Create it if necessary

if [ ! -e "${SYSCONFDIR}" ]
then
  mkdir "${SYSCONFDIR}"
  if [ ! -e "${SYSCONFDIR}" ]
  then
    echo
    echo "Creating ${SYSCONFDIR} directory failed"
    echo
    exit 1
  fi
fi

# Check if ftpusers exists. If yes, ask for overwriting

if [ -f "${SYSCONFDIR}/ftpusers" ]
then
  if request "Overwrite existing ${SYSCONFDIR}/ftpusers file?"
  then
    rm -f "${SYSCONFDIR}/ftpusers"
    if [ -f "${SYSCONFDIR}/ftpusers" ]
    then
      echo "Can't overwrite. ${SYSCONFDIR}/ftpusers is write protected."
    fi
  fi
fi

if [ ! -f "${SYSCONFDIR}/ftpusers" ]
then
  echo "Creating default ${SYSCONFDIR}/ftpusers file"
  cat > ${SYSCONFDIR}/ftpusers << EOF
ftp
anonymous
EOF
fi

# Check if ftpwelcome exists. If yes, ask for overwriting

if [ -f "${SYSCONFDIR}/ftpwelcome" ]
then
  if request "Overwrite existing ${SYSCONFDIR}/ftpwelcome file?"
  then
    rm -f "${SYSCONFDIR}/ftpwelcome"
    if [ -f "${SYSCONFDIR}/ftpwelcome" ]
    then
      echo "Can't overwrite. ${SYSCONFDIR}/ftpwelcome is write protected."
    fi
  fi
fi

if [ ! -f "${SYSCONFDIR}/ftpwelcome" ]
then
  echo "Creating default ${SYSCONFDIR}/ftpwelcome file"
  cat > ${SYSCONFDIR}/ftpwelcome << EOF

Wow! I have found the ftp daemon! Let's see...

EOF
fi

# Check if inetd.conf exists. If yes, ask for overwriting

if [ -f "${SYSCONFDIR}/inetd.conf" ]
then
  if request "Overwrite existing ${SYSCONFDIR}/inetd.conf file?"
  then
    rm -f "${SYSCONFDIR}/inetd.conf"
    if [ -f "${SYSCONFDIR}/inetd.conf" ]
    then
      echo "Can't overwrite. ${SYSCONFDIR}/inetd.conf is write protected."
    fi
  fi
fi

if [ ! -f "${SYSCONFDIR}/inetd.conf" ]
then
  echo "Creating default ${SYSCONFDIR}/inetd.conf file"
  cat > ${SYSCONFDIR}/inetd.conf << EOF
# See "man 8 inetd" for more information.
#
# If you make changes to this file, either reboot your machine or restart
# inetd:
#   "net stop inetd"
#   "net start inetd"
# The inetd will then re-read this file.
#
# <service_name> <sock_type> <proto> <flags> <user> <server_path> <args>
#
echo    stream  tcp     nowait  root    internal
echo    dgram   udp     wait    root    internal
discard stream  tcp     nowait  root    internal
discard dgram   udp     wait    root    internal
daytime stream  tcp     nowait  root    internal
daytime dgram   udp     wait    root    internal
chargen stream  tcp     nowait  root    internal
chargen dgram   udp     wait    root    internal
time    stream  tcp     nowait  root    internal
time    dgram   udp     wait    root    internal
#
# The external services are typically called via 'tcpd' for
# security reasons, eg.
# ftp   stream  tcp     nowait  root    /usr/sbin/tcpd in.ftpd
#
# but tcpd is not part of the inetutils, unfortunately.
# Nevertheless there's a port contributed by Prentis Brooks <prentis@aol.net>
#
# We are calling the services here directly.
#
# These are standard services.
#
ftp     stream  tcp     nowait  root    /usr/sbin/in.ftpd in.ftpd
telnet  stream  tcp     nowait  root    /usr/sbin/in.telnetd in.telnetd
#
# Shell, login, exec and talk are BSD protocols.
#
shell   stream  tcp     nowait  root    /usr/sbin/in.rshd in.rshd -L
login   stream  tcp     nowait  root    /usr/sbin/in.rlogind in.rlogind
exec    stream  tcp     nowait  root    /usr/sbin/in.rexecd in.rexecd
talk    dgram   udp     wait    root    /usr/sbin/in.talkd in.talkd
ntalk   dgram   udp     wait    root    /usr/sbin/in.talkd in.talkd
#
# The Internet UUCP service.
#
uucp    stream  tcp     nowait  uucp    /usr/sbin/in.uucpd in.uucpd
#
# Tftp service is provided primarily for booting.  Most sites
# run this only on machines acting as "boot servers." 
#
# tftp  dgram   udp     wait    nobody  /usr/sbin/in.tftpd in.tftpd
EOF
fi

# Check if motd exists. If yes, ask for overwriting

if [ -f "${SYSCONFDIR}/motd" ]
then
  if request "Overwrite existing ${SYSCONFDIR}/motd file?"
  then
    rm -f "${SYSCONFDIR}/motd"
    if [ -f "${SYSCONFDIR}/motd" ]
    then
      echo "Can't overwrite. ${SYSCONFDIR}/motd is write protected."
    fi
  fi
fi

if [ ! -f "${SYSCONFDIR}/motd" ]
then
  echo "Creating default ${SYSCONFDIR}/motd file"
  cat > ${SYSCONFDIR}/motd << EOF
Fanfare!!!
You are successfully logged in to this server!!!
EOF
fi

# Check if shells exists. If yes, ask for overwriting

if [ -f "${SYSCONFDIR}/shells" ]
then
  if request "Overwrite existing ${SYSCONFDIR}/shells file?"
  then
    rm -f "${SYSCONFDIR}/shells"
    if [ -f "${SYSCONFDIR}/shells" ]
    then
      echo "Can't overwrite. ${SYSCONFDIR}/shells is write protected."
    fi
  fi
fi

if [ ! -f "${SYSCONFDIR}/shells" ]
then
  echo "Creating default ${SYSCONFDIR}/shells file"
  cat > ${SYSCONFDIR}/shells << EOF
/bin/sh
/bin/bash
/bin/ksh
/bin/pdksh
/bin/tcsh
/bin/zsh
/usr/bin/sh
/usr/bin/bash
/usr/bin/ksh
/usr/bin/pdksh
/usr/bin/tcsh
/usr/bin/zsh
EOF
fi

echo
echo "Configuration finished. Have fun!"
